unit FrameRdRecChX5Unit;

interface

uses Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,DataRdRecReserve,DataRdRecReserveFolder,DataRdRecReserveInfo,
  DataRdRecReserveChannel,DataDefineRd,DataRdRecReserveEncode, ExtCtrls;

type
  TFrameRdRecChX5 = class(TFrame)
    Label3: TLabel;
    CBoxChannel: TComboBox;
    RGrpEncode: TRadioGroup;
    procedure RGrpEncodeClick(Sender: TObject);
    procedure CBoxChannelClick(Sender: TObject);
  private
    { Private 錾 }
    FRdInfo: TDataRdRecReserveInfo;
    FRd: TDataRdRecReserveItem;
    FRDDefine: TDataDefineRdItem;
    procedure ShowCh();
    procedure ShowEnc();
    procedure ViewCh();
    procedure ViewEnc();
  public
    { Public 錾 }
    procedure Show();
    procedure View();
    property Rd : TDataRdRecReserveItem read FRd write FRd;
    property RdInfo : TDataRdRecReserveInfo read FRdInfo write FRdInfo;
    property RDDefine : TDataDefineRdItem read FRDDefine write FRDDefine;
  end;

implementation

{$R *.DFM}

{ TFrameRdRecChX5 }

procedure TFrameRdRecChX5.Show;
begin
  ShowCh();
  ShowEnc();
end;

procedure TFrameRdRecChX5.View;
begin
  ViewCh();
  ViewEnc();
end;

procedure TFrameRdRecChX5.ShowCh;
var
  i : Integer;
  d : TDataRdRecReserveChannelItem;
  dc : TComboBox;
begin
  dc := CBoxChannel;
  dc.Clear;
  for i := 0 to FRdInfo.Channels.Items.Count-1 do begin
    d := FRdInfo.Channels.Items[i];
    dc.Items.AddObject(d.NameInfo,d);
    if d.Value = FRd.ChannelStr then begin
      dc.ItemIndex := i;
    end;
  end;
end;

procedure TFrameRdRecChX5.ShowEnc;
var
  i : Integer;
  dr : TRadioGroup;
  d : TDataRdRecReserveEncodeItem;
begin
  dr := RGrpEncode;
  dr.Items.Clear;
  for i := 0 to FRDDefine.Encode.Items.Count-1 do begin
    d := FRDDefine.Encode.Items[i];
    dr.Items.AddObject(d.NameInfo,d);
  end;
end;

procedure TFrameRdRecChX5.ViewCh;
var
  i : Integer;
  d : TDataRdRecReserveChannelItem;
  dc : TComboBox;
begin
  dc := CBoxChannel;
  for i := 0 to dc.Items.Count-1 do begin
    d := TDataRdRecReserveChannelItem(dc.Items.Objects[i]);
    if d.Value = FRd.ChannelStr then begin
      dc.ItemIndex := i;
    end;
  end;
end;

procedure TFrameRdRecChX5.ViewEnc;
var
  i : Integer;
  dr : TRadioGroup;
  d : TDataRdRecReserveEncodeItem;
begin
  dr := RGrpEncode;
  for i := 0 to dr.Items.Count-1 do begin
    d := TDataRdRecReserveEncodeItem(dr.Items.Objects[i]);
    if d.Mode = FRd.Encoder then begin
      dr.ItemIndex := i;
    end;
  end;
end;

procedure TFrameRdRecChX5.RGrpEncodeClick(Sender: TObject);
var
  i : Integer;
  dr : TRadioGroup;
  d : TDataRdRecReserveEncodeItem;
begin
  dr := RGrpEncode;
  i := dr.ItemIndex;
  if i = -1 then exit;
  d := TDataRdRecReserveEncodeItem(dr.Items.Objects[i]);
  FRd.Encoder := d.Mode;
end;

procedure TFrameRdRecChX5.CBoxChannelClick(Sender: TObject);
var
  i : Integer;
  d : TDataRdRecReserveChannelItem;
  dc : TComboBox;
begin
  dc := CBoxChannel;
  i := dc.ItemIndex;
  if i = -1 then exit;
  d := TDataRdRecReserveChannelItem(dc.Items.Objects[i]);
  FRd.ChannelStr := d.Value;
  ViewCh();
end;

end.
