unit FrameMainUnit;

interface

uses Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls,DataTvSchedule,DataRd,
  DateTimeCtrl,DataTvSchedulePaperRect,PanelRdList,
  DataRdRecReserve,FrameTvPaperUnit, FrameRdRecListUnit,FrameWebCMUnit,
  PanelTvProgramColumn,StringListKey;

type
  TFrameMain = class(TFrame)
    PCtrl: TPageControl;
    TabSheetTv: TTabSheet;
    TabSheetRdRec: TTabSheet;
    procedure TabSheetTvShow(Sender: TObject);
  private
    { Private 錾 }
    FFrameTvPaper : TFrameTvPaper;
    FFrameRdRecList : TFrameRdRecList;
  public
    { Public 錾 }
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    // ݒȂǂ̍ēǍ{\
    procedure Show();
    // ݒύXOɌĂяoŃG[h~
    procedure Clear();
    // Iꂽǂԑg\ɔf
    procedure ColumnReLoad();
  end;

implementation

uses FormConfigUnit,FormDefineUnit,FormVersionUnit,DMUnit;

{$R *.DFM}

{ TFrameMain }

constructor TFrameMain.Create(AOwner: TComponent);
begin
  inherited;
  FFrameRdRecList := TFrameRdRecList.Create(Self);
  FFrameRdRecList.Parent := TabSheetRdRec;
  FFrameRdRecList.Align := alClient;

  FFrameTvPaper := TFrameTvPaper.Create(Self);
  FFrameTvPaper.Parent := TabSheetTv;
  FFrameTvPaper.Align := alClient;

end;

destructor TFrameMain.Destroy;
begin
  FFrameTvPaper.Free;
  FFrameRdRecList.Free;
  inherited;

end;

procedure TFrameMain.Show;
var
  d : TDataRdItem;
  i : Integer;
begin
  if DM.Config.TvChannel.Items.Count = 0 then exit;
  FFrameRdRecList.Show();
  FFrameTvPaper.Show;
  for i := 0 to DM.Config.Rd.Items.Count-1 do begin
    d := DM.Rd.Items[i];
    d.GetRd.RecList();
  end;
end;


procedure TFrameMain.TabSheetTvShow(Sender: TObject);
begin
  FFrameTvPaper.ActiveCursor();
end;

procedure TFrameMain.Clear;
begin
  FFrameTvPaper.Clear;
end;

procedure TFrameMain.ColumnReLoad;
begin
  FFrameTvPaper.ColumnReLoad();
end;

end.
