unit FrameDefineRdUnit;

interface

uses Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
     StdCtrls,DataDefine,DataDefineRd, ExtCtrls, ComCtrls,
  FrameDefineRdEtcUnit, FrameDefineRdEncodeUnit;

type
  TFrameDefineRd = class(TFrame)
    GroupBox1: TGroupBox;
    LBoxRd: TListBox;
    BtnAdd: TButton;
    BtnDel: TButton;
    PanelClient: TPanel;
    PanelName: TPanel;
    Label1: TLabel;
    Label2: TLabel;
    EditName: TEdit;
    CBoxEngine: TComboBox;
    PageControl1: TPageControl;
    TabSheetEncode: TTabSheet;
    TabSheetEtc: TTabSheet;
    BtnUp: TButton;
    BtnDown: TButton;
    FrameDefineRdEtc1: TFrameDefineRdEtc;
    FrameDefineRdEncode1: TFrameDefineRdEncode;
    procedure LBoxRdClick(Sender: TObject);
    procedure EditNameExit(Sender: TObject);
    procedure CBoxEngineChange(Sender: TObject);
    procedure BtnUpClick(Sender: TObject);
    procedure BtnDownClick(Sender: TObject);
    procedure BtnDelClick(Sender: TObject);
    procedure BtnAddClick(Sender: TObject);
  private
    { Private 錾 }
    FDefine: TDataDefine;
    FRd : TDataDefineRdItem;
    procedure ShowEngine();
    procedure ShowRdList();
    procedure ShowRdItem(rd : TDataDefineRdItem);
    procedure ViewEngine();
    procedure ViewRdList();
  public
    { Public 錾 }
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure Show();
    property Define : TDataDefine read FDefine write FDefine;
  end;

implementation

{$R *.DFM}

{ TFrameDefineRd }

constructor TFrameDefineRd.Create(AOwner: TComponent);
begin
  inherited;
end;

destructor TFrameDefineRd.Destroy;
begin
  inherited;
end;

procedure TFrameDefineRd.Show;
begin
  ShowEngine();
  ShowRdList();
end;

procedure TFrameDefineRd.ShowRdList;
var
  i,j : Integer;
  dl : TListBox;
  d : TDataDefineRdItem;
begin
  dl := LBoxRd;
  j := dl.ItemIndex;
  dl.Clear;
  for i := 0 to FDefine.Rd.Items.Count-1 do begin
    d := FDefine.Rd.Items[i];
    dl.Items.AddObject(d.Name,d);
  end;
  if j < dl.Items.Count then begin
    dl.ItemIndex := j;
  end;
  if (dl.ItemIndex = -1) and (dl.Items.Count > 0) then begin
    dl.ItemIndex := 0;
    d := TDataDefineRdItem(dl.Items.Objects[0]);
    ShowRdItem(d);
  end;
end;

procedure TFrameDefineRd.ViewRdList;
var
  i : Integer;
  dl : TListBox;
  d : TDataDefineRdItem;
begin
  dl := LBoxRd;
  for i := 0 to dl.Items.Count-1 do begin
    d := TDataDefineRdItem(dl.Items.Objects[i]);
    dl.Items.Strings[i] := d.Name;
  end;

end;

procedure TFrameDefineRd.ShowRdItem(rd: TDataDefineRdItem);
begin
  FRd := rd;
  ViewEngine();
  EditName.Text := FRd.Name;
  FrameDefineRdEtc1.RD := FRd;
  FrameDefineRdEtc1.Show();
  FrameDefineRdEncode1.RD := FRd;
  FrameDefineRdEncode1.Show();
  PanelClient.Enabled := True;
end;

procedure TFrameDefineRd.LBoxRdClick(Sender: TObject);
var
  i : Integer;
  dl : TListBox;
  d : TDataDefineRdItem;
begin
  dl := LBoxRd;
  i := dl.ItemIndex;
  if i = -1 then exit;
  d := TDataDefineRdItem(dl.Items.Objects[i]);
  ShowRdItem(d);
end;

procedure TFrameDefineRd.ShowEngine;
var
  i : Integer;
  dc : TComboBox;
  s : string;
begin
  dc := CBoxEngine;
  dc.Clear;
  for i := 0 to High(TDataDefineRdItemEngineModeStr) do begin
    s := TDataDefineRdItemEngineModeStr[i];
    dc.Items.AddObject(s,Pointer(i));
  end;

end;

procedure TFrameDefineRd.ViewEngine;
var
  i : Integer;
  dc : TComboBox;
  m : TDataDefineRdItemEngineMode;
begin
  dc := CBoxEngine;
  for i := 0 to High(TDataDefineRdItemEngineModeStr) do begin
    m := TDataDefineRdItemEngineMode(dc.Items.Objects[i]);
    if m = FRd.Engine then begin
      dc.ItemIndex := i;
      break;
    end;
  end;
end;

procedure TFrameDefineRd.EditNameExit(Sender: TObject);
begin
  FRd.Name := EditName.Text;
  ViewRdList();
end;

procedure TFrameDefineRd.CBoxEngineChange(Sender: TObject);
var
  i : Integer;
  dc : TComboBox;
  m : TDataDefineRdItemEngineMode;
begin
  dc := CBoxEngine;
  i := dc.ItemIndex;
  if i = -1 then exit;
  m := TDataDefineRdItemEngineMode(dc.Items.Objects[i]);
  FRd.Engine := m;
end;

procedure TFrameDefineRd.BtnUpClick(Sender: TObject);
var
  i : Integer;
  dl : TListBox;
begin
  dl := LBoxRd;
  i := dl.ItemIndex;
  if i = -1 then exit;
  if i = 0 then exit;
  FDefine.Rd.Items.Exchange(i,i-1);
  dl.Items.Exchange(i,i-1);
  dl.ItemIndex := i - 1;
  ViewRdList();
end;

procedure TFrameDefineRd.BtnDownClick(Sender: TObject);
var
  i : Integer;
  dl : TListBox;
begin
  dl := LBoxRd;
  i := dl.ItemIndex;
  if i = -1 then exit;
  if i = dl.Items.Count-1 then exit;
  FDefine.Rd.Items.Exchange(i,i+1);
  dl.Items.Exchange(i,i+1);
  dl.ItemIndex := i + 1;
  ViewRdList();
end;

procedure TFrameDefineRd.BtnAddClick(Sender: TObject);
var
  d : TDataDefineRdItem;
begin
  d := FDefine.Rd.Items.Add();
  d.Name := 'RD-';
  ShowRdList();
  //
end;

procedure TFrameDefineRd.BtnDelClick(Sender: TObject);
var
  i : Integer;
  dl : TListBox;
begin
  dl := LBoxRd;
  i := dl.ItemIndex;
  if i = -1 then exit;
  dl.Items.Delete(i);
  ShowRdList();
end;

end.
