unit FrameDefineRdEtcUnit;

interface

uses Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,DataDefineRd;

type
  TFrameDefineRdEtc = class(TFrame)
    GroupBox2: TGroupBox;
    ChkBoxChapterDvd: TCheckBox;
    ChkBoxFolder: TCheckBox;
    ChkBoxAspect: TCheckBox;
    ChkBoxChapMultiVoice: TCheckBox;
    ChkBoxChapSilent: TCheckBox;
    procedure ChkBoxFolderClick(Sender: TObject);
    procedure ChkBoxAspectClick(Sender: TObject);
    procedure ChkBoxChapterDvdClick(Sender: TObject);
    procedure ChkBoxChapMultiVoiceClick(Sender: TObject);
    procedure ChkBoxChapSilentClick(Sender: TObject);
  private
    { Private 錾 }
    FRd: TDataDefineRdItem;
  public
    { Public 錾 }
    procedure Show();
    property RD : TDataDefineRdItem read FRd write FRd;
  end;

implementation

{$R *.DFM}

{ TFrameDefineRdEtc }

procedure TFrameDefineRdEtc.Show;
begin
  ChkBoxFolder.Checked := FRd.Folder;
  ChkBoxAspect.Checked := FRd.Aspect;
  ChkBoxChapterDvd.Checked := FRd.ChapterDvd;
  ChkBoxChapMultiVoice.Checked := FRd.ChapterMultiVoice;
  ChkBoxChapSilent.Checked := FRd.ChapterSilent;
end;

procedure TFrameDefineRdEtc.ChkBoxFolderClick(Sender: TObject);
var
  f : Boolean;
begin
  f := TCheckBox(Sender).Checked;
  FRd.Folder := f;
end;

procedure TFrameDefineRdEtc.ChkBoxAspectClick(Sender: TObject);
var
  f : Boolean;
begin
  f := TCheckBox(Sender).Checked;
  FRd.Aspect := f;
end;

procedure TFrameDefineRdEtc.ChkBoxChapterDvdClick(Sender: TObject);
var
  f : Boolean;
begin
  f := TCheckBox(Sender).Checked;
  FRd.ChapterDvd := f;
end;

procedure TFrameDefineRdEtc.ChkBoxChapMultiVoiceClick(Sender: TObject);
var
  f : Boolean;
begin
  f := TCheckBox(Sender).Checked;
  FRd.ChapterMultiVoice := f;
end;

procedure TFrameDefineRdEtc.ChkBoxChapSilentClick(Sender: TObject);
var
  f : Boolean;
begin
  f := TCheckBox(Sender).Checked;
  FRd.ChapterSilent := f;
end;

end.
