unit FrameDefineRdEncodeUnit;

interface

uses Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls,DataDefineRd,DataRdRecReserveEncode;

type
  TFrameDefineRdEncode = class(TFrame)
    GroupBox3: TGroupBox;
    LBoxEncode: TListBox;
    BtnAdd: TButton;
    BtnDel: TButton;
    PanelItem: TPanel;
    GroupBox1: TGroupBox;
    EditName: TEdit;
    GroupBox2: TGroupBox;
    EditNo: TEdit;
    GroupBox4: TGroupBox;
    EditValue: TEdit;
    GroupBox5: TGroupBox;
    CBoxMode: TComboBox;
    procedure BtnAddClick(Sender: TObject);
    procedure BtnDelClick(Sender: TObject);
    procedure EditNameExit(Sender: TObject);
    procedure EditValueExit(Sender: TObject);
    procedure CBoxModeChange(Sender: TObject);
    procedure LBoxEncodeClick(Sender: TObject);
  private
    { Private 錾 }
    FRd: TDataDefineRdItem;
    FEncode : TDataRdRecReserveEncodeItem;
    procedure ShowModeItem(d : TDataRdRecReserveEncodeItem);
    procedure ShowMode();
    procedure View();
  public
    { Public 錾 }
    procedure Show();
    property RD : TDataDefineRdItem read FRd write FRd;
  end;

implementation

{$R *.DFM}

{ TFrameDefineRdEncode }

procedure TFrameDefineRdEncode.Show;
var
  i,j : Integer;
  dl : TListBox;
  d : TDataRdRecReserveEncodeItem;
begin
  ShowMode();
  PanelItem.Enabled := False;
  dl := LBoxEncode;
  j := dl.ItemIndex;
  dl.Clear;
  for i := 0 to FRd.Encode.Items.Count-1 do begin
    d := FRd.Encode.Items[i];
    dl.Items.AddObject(d.NameInfo,d);
  end;
  if (j >= 0) and (j < dl.Items.Count) then begin
    dl.ItemIndex := j;
  end
  {
  else if (j-1 < dl.Items.Count) and (j-1 >= 0) then begin
    dl.ItemIndex := j-1;
  end
  }
  else if dl.Items.Count > 0 then begin
    dl.ItemIndex := 0;
  end;
  if dl.ItemIndex >= 0 then begin
    d := TDataRdRecReserveEncodeItem(dl.Items.Objects[dl.ItemIndex]);
    ShowModeItem(d);
    PanelItem.Enabled := True;
  end;
end;

procedure TFrameDefineRdEncode.View;
var
  i : Integer;
  dl : TListBox;
  d : TDataRdRecReserveEncodeItem;
begin
  dl := LBoxEncode;
  for i := 0 to FRd.Encode.Items.Count-1 do begin
    d := FRd.Encode.Items[i];
    dl.Items.Strings[i] := d.NameInfo;
  end;
end;

procedure TFrameDefineRdEncode.ShowMode;
var
  i : Integer;
  dc : TComboBox;
  s : string;
begin
  dc := CBoxMode;
  dc.Clear;
  for i := 0 to High(TDataRdRecReserveEncodeItemModeStr) do begin
    s := TDataRdRecReserveEncodeItemModeStr[i];
    dc.Items.AddObject(s,Pointer(i));
  end;

end;

procedure TFrameDefineRdEncode.ShowModeItem(
  d: TDataRdRecReserveEncodeItem);
begin
  FEncode := d;
  EditName.Text := d.NameInfo;
  EditValue.Text := d.Value;
  CBoxMode.ItemIndex := Ord(d.Mode);
end;

procedure TFrameDefineRdEncode.LBoxEncodeClick(Sender: TObject);
var
  i : Integer;
  dl : TListBox;
  d : TDataRdRecReserveEncodeItem;
begin
  dl := LBoxEncode;
  i := dl.ItemIndex;
  if i = -1 then exit;
  d := TDataRdRecReserveEncodeItem(dl.Items.Objects[i]);
  ShowModeItem(d);
end;

procedure TFrameDefineRdEncode.BtnAddClick(Sender: TObject);
var
  d : TDataRdRecReserveEncodeItem;
begin
  d := FRd.Encode.Items.Add();
  d.Mode := encR1;
  d.NameInfo := d.ModeStr;
  d.Value := '0';
  Show();
end;

procedure TFrameDefineRdEncode.BtnDelClick(Sender: TObject);
var
  i : Integer;
begin
  i := LBoxEncode.ItemIndex;
  if i = -1 then exit;
  FRd.Encode.Items.Delete(i);
  Show();
end;

procedure TFrameDefineRdEncode.EditNameExit(Sender: TObject);
begin
  FEncode.NameInfo := TEdit(Sender).Text;
  View();
  //
end;

procedure TFrameDefineRdEncode.EditValueExit(Sender: TObject);
begin
  FEncode.Value := TEdit(Sender).Text;
end;

procedure TFrameDefineRdEncode.CBoxModeChange(Sender: TObject);
var
  dc : TComboBox;
begin
  dc := CBoxMode;
  FEncode.Mode := TDataRdRecReserveEncodeItemMode(dc.ItemIndex);
end;

end.
