unit FrameConfigTvColumnUnit;

interface

uses Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls,DataTvSchedulePaperColumn,DataConfig,DataTvChannel,
  PanelTvProgramColumnConfig;

type
  TFrameConfigTvColumn = class(TFrame)
    PanelView: TPanel;
    PanelViewNon: TPanel;
    PanelMenu: TPanel;
    BtnAdd: TButton;
    BtnDel: TButton;
    GroupBox1: TGroupBox;
    GroupBox2: TGroupBox;
    LBoxView: TListBox;
    LBoxViewNon: TListBox;
    BtnUp: TButton;
    BtnDown: TButton;
    procedure FrameResize(Sender: TObject);
    procedure BtnAddClick(Sender: TObject);
    procedure BtnDelClick(Sender: TObject);
    procedure BtnUpClick(Sender: TObject);
    procedure BtnDownClick(Sender: TObject);
  private
    { Private 錾 }
    FConfig: TPanelTvProgramColumnConfig;
    procedure ShowCh();
  public
    { Public 錾 }
    procedure Show();
    property Config : TPanelTvProgramColumnConfig read FConfig write FConfig;
  end;

implementation

uses DMUnit;

{$R *.DFM}

procedure TFrameConfigTvColumn.FrameResize(Sender: TObject);
var
  xh : Integer;
begin
  //
  xh := TFrame(Sender).ClientWidth;
  PanelView.Width := (xh - 80) div 2;
  PanelViewNon.Width := (xh - 80) div 2;

end;

procedure TFrameConfigTvColumn.Show;
begin
  ShowCh();
end;

procedure TFrameConfigTvColumn.ShowCh;
var
  i,j : Integer;
  d : TPanelTvProgramColumnConfigItem;
  dc : TDataTvChannelItem;
  dl : TListBox;
  t : TList;
begin
  t := TList.Create;
  try
    dl := LBoxView;
    j := dl.ItemIndex;
    dl.Clear;
    for i := 0 to FConfig.Columns.Count-1 do begin
      d := FConfig.Columns[i];
      dc := DM.Config.TvChannel.Items.TvExs[d.ChannelTv,d.ChannelEx];
      if dc = nil then continue;
      if not dc.Visible then continue;
      t.Add(dc);
      dl.Items.AddObject(dc.Name,d);
    end;
    if j < dl.Items.Count then dl.ItemIndex := j;

    dl := LBoxViewNon;
    j := dl.ItemIndex;
    dl.Clear;
    for i := 0 to DM.Config.TvChannel.Items.Count-1 do begin
      dc := DM.Config.TvChannel.Items[i];
      if t.IndexOf(dc) <> -1 then continue;
      if not dc.Visible then continue;
      dl.Items.AddObject(dc.Name,dc);
    end;
    if j < dl.Items.Count then dl.ItemIndex := j;
  finally
    t.Free;
  end;


end;

procedure TFrameConfigTvColumn.BtnAddClick(Sender: TObject);
var
  i : Integer;
  dl : TListBox;
  d : TPanelTvProgramColumnConfigItem;
  dc : TDataTvChannelItem;
begin
  dl := LBoxViewNon;
  i := dl.ItemIndex;
  if i = -1 then exit;
  dc := TDataTvChannelItem(dl.Items.Objects[i]);
  d := FConfig.Columns.Add();
  d.ChannelTv := dc.ChannelTv;
  d.ChannelEx := dc.ChannelEx;
  ShowCh();

end;

procedure TFrameConfigTvColumn.BtnDelClick(Sender: TObject);
var
  i,j : Integer;
  dl : TListBox;
  dc : TDataTvChannelItem;
begin
  dl := LBoxView;
  i := dl.ItemIndex;
  if i = -1 then exit;
  dc := TDataTvChannelItem(dl.Items.Objects[i]);
  j := FConfig.Columns.IndexOf(dc);
  if j = -1 then exit;
  FConfig.Columns.Delete(j);
  ShowCh();
end;

procedure TFrameConfigTvColumn.BtnUpClick(Sender: TObject);
var
  i : Integer;
  dl : TListBox;
begin
  dl := LBoxView;
  i := dl.ItemIndex;
  if i < 1 then exit;
  FConfig.Columns.Exchange(i,i-1);
  dl.ItemIndex := i -1;
  ShowCh();
end;

procedure TFrameConfigTvColumn.BtnDownClick(Sender: TObject);
var
  i : Integer;
  dl : TListBox;
begin
  dl := LBoxView;
  i := dl.ItemIndex;
  if i > dl.Items.Count-2 then exit;
  FConfig.Columns.Exchange(i,i+1);
  dl.ItemIndex := i +1;
  ShowCh();
end;

end.
