unit FrameConfigTvChUvUnit;

interface

uses Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, ComCtrls, StdCtrls, CheckLst,GetTvAnalogAdr,GetTvChOnTvJapanUv,
  DataTvChannel;

type
  TFrameConfigTvChUv = class(TFrame)
    GroupBox1: TGroupBox;
    ChkLBoxAdr: TCheckListBox;
    PCtrl: TPageControl;
    TabSheetCh: TTabSheet;
    GroupBox2: TGroupBox;
    ChkLBoxCh: TCheckListBox;
    TabSheetWait: TTabSheet;
    Panel1: TPanel;
    ChkLBoxTest: TCheckListBox;
    BtnReLoadAdr: TButton;
    procedure ChkLBoxAdrClickCheck(Sender: TObject);
    procedure ChkLBoxAdrClick(Sender: TObject);
    procedure ChkLBoxChClickCheck(Sender: TObject);
    procedure BtnReLoadAdrClick(Sender: TObject);
  private
    { Private 錾 }
    FGetAdr : TGetTvAnalogAdr;
    FGetCh : TGetTvChOnTvJapanUv;
    FConfig: TDataTvChannel;
    FOnChkChange: TNotifyEvent;

    procedure ShowAdr();
    procedure ViewAdr();
    procedure ShowCh();
    procedure ShowChSub();

    procedure ChAdd(dc : TDataTvChannelItem);
    procedure ChDel(dc : TDataTvChannelItem);

    procedure DoChkChange();

    procedure OnAdrReceive(Sender: TObject);
    procedure OnAdrError(Sender: TObject);
    procedure OnChReceive(Sender: TObject);
    procedure OnChError(Sender: TObject);
  public
    { Public 錾 }
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure Show();
    property Config : TDataTvChannel read FConfig write FConfig;
    // gp`l`FbNnm^neeƂ̃Cxg
    property OnChkChange : TNotifyEvent read FOnChkChange write FOnChkChange;
  end;

implementation

{$R *.DFM}

{ TFrameConfigTvChUv }

constructor TFrameConfigTvChUv.Create(AOwner: TComponent);
begin
  inherited;
  FGetAdr := TGetTvAnalogAdr.Create;
  FGetAdr.OnReceive := OnAdrReceive;
  FGetAdr.OnError := OnAdrError;
  FGetCh := TGetTvChOnTvJapanUv.Create;
  FGetCh.OnReceive := OnChReceive;
  FGetCh.OnError := OnChError;
end;

destructor TFrameConfigTvChUv.Destroy;
begin
  FGetCh.Free;
  FGetAdr.Free;
  inherited;
end;

procedure TFrameConfigTvChUv.Show;
begin
  FGetAdr.Get();
  ShowCh();
end;

procedure TFrameConfigTvChUv.OnAdrError(Sender: TObject);
begin

end;

procedure TFrameConfigTvChUv.OnAdrReceive(Sender: TObject);
begin
  ShowAdr();
end;

procedure TFrameConfigTvChUv.OnChError(Sender: TObject);
begin

end;

procedure TFrameConfigTvChUv.OnChReceive(Sender: TObject);
begin
  ShowCh();
end;

procedure TFrameConfigTvChUv.ChkLBoxAdrClick(Sender: TObject);
var
  i : Integer;
  Adr : string;
begin
  PCtrl.ActivePage := TabSheetWait;
  i := TCheckListBox(Sender).ItemIndex;
  Adr := FGetAdr.Items[i].Code;
  FGetCh.Get(Adr);
end;

procedure TFrameConfigTvChUv.ChkLBoxAdrClickCheck(Sender: TObject);
var
  i : Integer;
  Adr : string;
begin
  PCtrl.ActivePage := TabSheetWait;
  i := TCheckListBox(Sender).ItemIndex;
  Adr := FGetAdr.Items[i].Code;
  FGetCh.Get(Adr);
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@nꗗXg\@`                                            //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TFrameConfigTvChUv.ShowAdr;
var
  i,j,k : Integer;
  Adr : string;
  da : TGetTvAnalogAdrItem;
  dc : TDataTvChannelItem;
begin
  k := -1;
  ChkLBoxAdr.Clear;
  for i := 0 to FGetAdr.Items.Count-1 do begin
    da := FGetAdr.Items[i];
    ChkLBoxAdr.Items.AddObject(da.Name,da);
    for j := 0 to FConfig.Items.Count-1 do begin
      dc := FConfig.Items[j];
      if da.Code = dc.AdrNo then begin
        if k = -1 then k := i;
        Adr := da.Code;
        ChkLBoxAdr.Checked[i] := True;
        break;
      end;
    end;

  end;
  if Adr = '' then exit;
  ChkLBoxAdr.ItemIndex := k;
  FGetCh.Get(Adr);

end;

procedure TFrameConfigTvChUv.ViewAdr;
  function Check(d : TGetTvAnalogAdrItem) : Boolean;
  var
    i : Integer;
    dc : TDataTvChannelItem;
  begin
    result := False;
    for i := 0 to FConfig.Items.Count-1 do begin
      dc := FConfig.Items[i];
      if (dc.AdrNo = d.Code) and
         (dc.Visible) then begin
        result := True;
        exit;
      end;
    end;

  end;
var
  i : Integer;
  da : TGetTvAnalogAdrItem;
  dc : TCheckListBox;
begin
  dc := ChkLBoxAdr;
  for i := 0 to dc.Items.Count-1 do begin
    da := TGetTvAnalogAdrItem(dc.Items.Objects[i]);
    dc.Checked[i] := Check(da);

  end;
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@ǈꗗXg\@`                                          //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TFrameConfigTvChUv.ShowCh;
var
  i,j : Integer;
  d1,d2 : TDataTvChannelItem;
  dc : TCheckListBox;
begin
  dc := ChkLBoxCh;
  dc.Clear;
  for j := 0 to FGetCh.Items.Count-1 do begin       // 擾\ȕǈꗗ[v
    d1 := FGetCh.Items[j];                          // ǏQ
    i := FConfig.Items.IndexOfTvEx(d1);             // I𒆂̕ǈꗗYǂ擾
    dc.Items.AddObject(d1.Name,d1);                 // I̗LɊ֌WȂꗗɂ͕\
    if i = -1 then continue;                        // IĂȂꍇ͈Ȍ㖢

    d2 := FConfig.Items[i];                         // ǑIԊǗNXQ
    dc.Checked[j] := d2.Visible;                    // I̗L𔽉f

  end;
  for i := 0 to dc.Items.Count-1 do begin           // 쐬Xg[v
    if dc.Checked[i] then begin                     // `FbNĂŏ̕ǂ̏ꍇ
      dc.ItemIndex := i;                            // ̕ǂɃJ[\ړ
      break;
    end;
  end;

  PCtrl.ActivePage := TabSheetCh;                   // ^uIԂɂ

end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@ǈꗗXg\@`                                          //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//   J[\ړ^üړsȂ                                   //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TFrameConfigTvChUv.ShowChSub;
var
  d : TDataTvChannelItem;
  dc : TCheckListBox;
  i,j : Integer;
begin
  dc := ChkLBoxTest;
  dc.Clear;
  for j := 0 to FConfig.Items.Count-1 do begin
    d := FConfig.Items[j];

    dc.Items.AddObject(d.Name,d);
    i := FConfig.Items.IndexOfOnTvJapan(d,cmNormal);
    if i = -1 then continue;
    dc.Checked[dc.Items.Count-1] := FConfig.Items[i].Visible;

  end;
end;

procedure TFrameConfigTvChUv.ChkLBoxChClickCheck(Sender: TObject);
var
  d : TDataTvChannelItem;
  dc : TCheckListBox;
  i : Integer;
  f : Boolean;
begin
  dc := TCheckListBox(Sender);
  i := dc.ItemIndex;
  if i = -1 then exit;
  f := dc.Checked[i];
  d := TDataTvChannelItem(dc.Items.Objects[i]);
  if f then begin
    ChAdd(d);
  end
  else begin
    ChDel(d);
  end;
  ViewAdr();
  DoChkChange();
end;

procedure TFrameConfigTvChUv.ChAdd(dc: TDataTvChannelItem);
var
  i,j,Page : Integer;
  Adr : string;
  d1,d2 : TDataTvChannelItem;
begin
  Adr := dc.AdrNo;
  Page := dc.PageNo;
  i := FConfig.Items.IndexOfTvEx(dc);
  if i <> -1 then begin
    d1 := FConfig.Items[i];
    d1.Visible := True;
    ShowChSub();
    exit;
  end;
  d1 := FConfig.Items.Add();
  d1.Assign(dc);
  d1.Visible := True;

  for j := 0 to FGetCh.Items.Count-1 do begin
    d1 := FGetCh.Items[j];
    if (d1.AdrNo <> Adr) or
       (d1.PageNo <> Page) then continue;
    i := FConfig.Items.IndexOfTvEx(d1);
    if i <> -1 then continue;
    d2 := FConfig.Items.Add();
    d2.Assign(d1);

  end;
  ShowChSub();
end;

procedure TFrameConfigTvChUv.ChDel(dc: TDataTvChannelItem);
var
  i,j,Page : Integer;
  Adr : string;
  d1 : TDataTvChannelItem;
  f : Boolean;
begin
  Adr := dc.AdrNo;
  Page := dc.PageNo;
  i := FConfig.Items.IndexOfTvEx(dc);
  if i = -1 then exit;

  d1 := FConfig.Items[i];
  d1.Visible := False;
  {
  f := False;
  for j := 0 to FConfig.Items.Count-1 do begin
    d1 := FConfig.Items[j];
    if (d1.AdrNo = Adr) and
       (d1.PageNo = Page) and
       (d1.Visible) then begin
       f := True;
       break;
    end;
  end;
  if f then begin
    ShowTest();
    exit;
  end;
  }
  for j := FConfig.Items.Count-1 downto 0 do begin
    d1 := FConfig.Items[j];
    if (d1.AdrNo = Adr) and
       (d1.PageNo = Page) then begin
      FConfig.Items.Delete(j);
      break;
    end;
  end;

  ShowChSub();
end;

procedure TFrameConfigTvChUv.DoChkChange;
begin
  if Assigned(FOnChkChange) then begin
    FOnChkChange(Self);
  end;
end;

procedure TFrameConfigTvChUv.BtnReLoadAdrClick(Sender: TObject);
begin
  FGetAdr.Get();
end;

end.
