unit FrameConfigTvChUnit;

interface

uses Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
     DataTvChannel, CheckLst,FrameConfigTvChUvUnit,
     FrameConfigTvChCs110Unit, ComCtrls, StdCtrls, ExtCtrls,
     FrameConfigTvChCsUnit,FrameConfigTvChBsDUnit,FrameConfigTvChCATVUnit;

type
  TFrameConfigTvCh = class(TFrame)
    PanelTvMode: TPanel;
    Label1: TLabel;
    ChkLBoxMode: TCheckListBox;
    PCtrl: TPageControl;
    TabSheetUV: TTabSheet;
    TabSheetBSD: TTabSheet;
    TabSheetCS: TTabSheet;
    TabSheetCS110: TTabSheet;
    TabSheetCATV: TTabSheet;
    procedure ChkLBoxModeClick(Sender: TObject);
    procedure ChkLBoxModeClickCheck(Sender: TObject);
  private
    { Private 錾 }
    FConfig: TDataTvChannel;
    FFrameUv : TFrameConfigTvChUv;
    FFrameCs110 : TFrameConfigTvChCs110;
    FFrameCs : TFrameConfigTvChCs;
    FFrameBsD : TFrameConfigTvChBsD;
    FFrameCATV : TFrameConfigTvChCATV;
    procedure ShowMode();
    procedure ViewMode();
    procedure OnCheckChange(Sender: TObject);
  public
    { Public 錾 }
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure Show();
    property Config : TDataTvChannel read FConfig write FConfig;
  end;

implementation

{$R *.DFM}

{ TFrameConfigTvCh }

constructor TFrameConfigTvCh.Create(AOwner: TComponent);
begin
  inherited;
  FFrameUv := TFrameConfigTvChUv.Create(Self);
  FFrameUv.Parent := TabSheetUV;
  FFrameUv.Align := alClient;
  FFrameUv.OnChkChange := OnCheckChange;

  FFrameCs110 := TFrameConfigTvChCs110.Create(Self);
  FFrameCs110.Parent := TabSheetCS110;
  FFrameCs110.Align := alClient;
  FFrameCs110.OnChkChange := OnCheckChange;

  FFrameCs := TFrameConfigTvChCs.Create(Self);
  FFrameCs.Parent := TabSheetCS;
  FFrameCs.Align := alClient;
  FFrameCs.OnChkChange := OnCheckChange;

  FFrameBsD := TFrameConfigTvChBsD.Create(Self);
  FFrameBsD.Parent := TabSheetBSD;
  FFrameBsD.Align := alClient;
  FFrameBsD.OnChkChange := OnCheckChange;

  FFrameCATV := TFrameConfigTvChCATV.Create(Self);
  FFrameCATV.Parent := TabSheetCATV;
  FFrameCATV.Align := alClient;
  FFrameCATV.OnChkChange := OnCheckChange;
end;

destructor TFrameConfigTvCh.Destroy;
begin
  FFrameCATV.Free;
  FFrameBsD.Free;
  FFrameCs.Free;
  FFrameCs110.Free;
  FFrameUv.Free;
  inherited;
end;

procedure TFrameConfigTvCh.Show;
begin
  FFrameUv.Config := FConfig;
  FFrameCs.Config := FConfig;
  FFrameCs110.Config := FConfig;
  FFrameBsD.Config := FConfig;
  FFrameCATV.Config := FConfig;
  ShowMode();
  FFrameUv.Show;
  FFrameCs110.Show;
  FFrameCs.Show;
  FFrameBsD.Show;
  FFrameCATV.Show;
  PCtrl.ActivePage := TabSheetUV;
end;

procedure TFrameConfigTvCh.ShowMode;
var
  i : Integer;
  dc : TDataTvChannelItem;
begin
  for i := 0 to ChkLBoxMode.Items.Count-1 do begin
    ChkLBoxMode.Checked[i] := False;
  end;

  for i := 0 to FConfig.Items.Count-1 do begin
    dc := FConfig.Items[i];
    case dc.Mode of
      cmNormal    : ChkLBoxMode.Checked[0] := True;
      cmBsDigital : ChkLBoxMode.Checked[1] := True;
      cmCsAnalog  : ChkLBoxMode.Checked[2] := True;
      cmCsDigital : ChkLBoxMode.Checked[3] := True;
      cmCATV      : ChkLBoxMode.Checked[4] := True;
    end;

  end;
end;

procedure TFrameConfigTvCh.ViewMode;
var
  i : Integer;
  f : Boolean;
begin
  for i := 0 to ChkLBoxMode.Items.Count-1 do begin
    f := ChkLBoxMode.Checked[i];
    case i of
      0: TabSheetUV.TabVisible := f;
      1: TabSheetBSD.TabVisible := f;
      2: TabSheetCS.TabVisible := f;
      3: TabSheetCS110.TabVisible := f;
      4: TabSheetCATV.TabVisible := f;
    end;

  end;
end;

procedure TFrameConfigTvCh.ChkLBoxModeClick(Sender: TObject);
var
  i : Integer;
begin
  i := TCheckListBox(Sender).ItemIndex;
  if i = -1 then exit;
  case i of
    0: PCtrl.ActivePage := TabSheetUV;
    1: PCtrl.ActivePage := TabSheetBSD;
    2: PCtrl.ActivePage := TabSheetCS;
    3: PCtrl.ActivePage := TabSheetCS110;
    4: PCtrl.ActivePage := TabSheetCATV;
  end;
end;

procedure TFrameConfigTvCh.ChkLBoxModeClickCheck(Sender: TObject);
begin
  ViewMode();
end;

procedure TFrameConfigTvCh.OnCheckChange(Sender: TObject);
begin
  ShowMode();
end;

end.
