unit FrameConfigTvChCs110Unit;

interface

uses Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, CheckLst,GetTvChCs110,DataTvChannel,GetTvChOnTvJapanEx,
  ComCtrls, ExtCtrls,StringListKey,ProcPublicFileName;

type
  TFrameConfigTvChCs110 = class(TFrame)
    PCtrl: TPageControl;
    TabSheetCh: TTabSheet;
    TabSheetWait: TTabSheet;
    GroupBox2: TGroupBox;
    ChkLBoxCh: TCheckListBox;
    GroupBox1: TGroupBox;
    CBoxGenre: TComboBox;
    PBar: TProgressBar;
    Label1: TLabel;
    PanelMenu: TPanel;
    BtnReLoad: TButton;
    procedure CBoxGenreChange(Sender: TObject);
    procedure BtnReLoadClick(Sender: TObject);
    procedure ChkLBoxChClickCheck(Sender: TObject);
  private
    { Private 錾 }
    FConfig: TDataTvChannel;
    FChannel : TDataTvChannel;
    FGetCh : TGetTvChCs110;
    FGetChOnTv : TGetTvOnTvJapanEx;
    FReadOnTvJapan : Boolean;
    FReadSkyPerfectTv : Boolean;
    FOnChkChange: TNotifyEvent;

    procedure Get();
    procedure ShowCh();
    procedure ShowGenre();
    procedure ShowChGenre(const Genre : string);

    function GetFileName() : string;
    function DataLoad() : Boolean;
    function DataSave() : Boolean;

    procedure DoChkChange();

    procedure OnChReceive(Sender: TObject);
    procedure OnChError(Sender: TObject);
    procedure OnChReceiveTv(Sender: TObject);
    procedure OnChErrorTv(Sender: TObject);
    procedure OnChProcessTv(Sender: TObject);
  public
    { Public 錾 }
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure Show();
    property Config : TDataTvChannel read FConfig write FConfig;
    // gp`l`FbNnm^neeƂ̃Cxg
    property OnChkChange : TNotifyEvent read FOnChkChange write FOnChkChange;
  end;

implementation

{$R *.DFM}

{ TFrameConfigTvChCs110 }

constructor TFrameConfigTvChCs110.Create(AOwner: TComponent);
begin
  inherited;
  FChannel := TDataTvChannel.Create;

  FGetCh := TGetTvChCs110.Create;
  FGetCh.OnReceive := OnChReceive;
  FGetCh.OnError := OnChError;

  FGetChOnTv := TGetTvOnTvJapanEx.Create;
  FGetChOnTv.OnReceive := OnChReceiveTv;
  FGetChOnTv.OnError := OnChErrorTv;
  FGetChOnTv.OnProcess := OnChProcessTv;
end;

destructor TFrameConfigTvChCs110.Destroy;
begin
  FGetChOnTv.Free;
  FGetCh.Free;

  FChannel.Free;
  inherited;
end;

procedure TFrameConfigTvChCs110.Show;
begin
  if DataLoad() then begin     // t@CȌԂ擾łꍇ
    ShowGenre();
    ShowChGenre('');
    PCtrl.ActivePage := TabSheetCh;
  end
  else begin                   // t@C擾łȂꍇ
    Get();                     // z[y[W擾
  end;
end;

procedure TFrameConfigTvChCs110.Get;
begin
  FChannel.Items.Clear;
  FReadOnTvJapan := False;
  FReadSkyPerfectTv := False;
  FGetCh.Get();
  PCtrl.ActivePage := TabSheetWait;
  FGetChOnTv.Get(cmCsDigital);
end;

procedure TFrameConfigTvChCs110.ShowGenre;
var
  i,j : Integer;
  d : TDataTvChannelItem;
  dc : TComboBox;
begin
  dc := CBoxGenre;
  dc.Clear;
  for j := 0 to FChannel.Items.Count-1 do begin
    d := FChannel.Items[j];
    i := dc.Items.IndexOf(d.GenreName);
    if i <> -1 then continue;
    dc.Items.AddObject(d.GenreName,d);
  end;
  dc.Items.InsertObject(0,'ׂĕ\',nil);
  dc.ItemIndex := 0;
end;

procedure TFrameConfigTvChCs110.ShowCh;
begin
  if FReadOnTvJapan and FReadSkyPerfectTv then begin
  //if FReadOnTvJapan then begin
    ShowGenre();
    ShowChGenre('');
    PCtrl.ActivePage := TabSheetCh;
    DataSave();
  end;
end;

procedure TFrameConfigTvChCs110.ShowChGenre(const Genre : string);
var
  i,j : Integer;
  d : TDataTvChannelItem;
  dc : TCheckListBox;
begin
  dc := ChkLBoxCh;
  dc.Clear;
  for j := 0 to FChannel.Items.Count-1 do begin
    d := FChannel.Items[j];
    if (Genre = '') or (d.GenreName = Genre) then begin
      dc.Items.AddObject(d.Name,d);
      i := FConfig.Items.IndexOfSkyPerfectTv110(d);
      if i = -1 then continue;
      dc.Checked[dc.Items.Count-1] := FConfig.Items[i].Visible;
    end;
  end;

end;

procedure TFrameConfigTvChCs110.OnChError(Sender: TObject);
begin

end;

procedure TFrameConfigTvChCs110.OnChReceive(Sender: TObject);
begin
  FReadSkyPerfectTv := True;
  FChannel.Items.AssignSkyPerfectTv110(FGetCh.Items);
  ShowCh();
end;

procedure TFrameConfigTvChCs110.OnChReceiveTv(Sender: TObject);
begin
  FReadOnTvJapan := True;
  FChannel.Items.AssignOnTvJapan(FGetChOnTv.Items);
  ShowCh();
end;

procedure TFrameConfigTvChCs110.OnChErrorTv(Sender: TObject);
begin

end;

procedure TFrameConfigTvChCs110.OnChProcessTv(Sender: TObject);
begin
  PBar.Position := FGetChOnTv.Page;
end;

procedure TFrameConfigTvChCs110.CBoxGenreChange(Sender: TObject);
var
  i : Integer;
  Genre : string;
  dc : TComboBox;
begin
  dc := CBoxGenre;
  i := dc.ItemIndex;
  if i = -1 then exit;
  Genre := '';
  if i > 0 then begin
    Genre := dc.Items[i];
  end;
  ShowChGenre(Genre);
end;

function TFrameConfigTvChCs110.GetFileName: string;
var
  s : string;
begin
  s := GetFilePathTemp();
  result := s + 'tmp_ChSkyPerfect110.ini';
end;

function TFrameConfigTvChCs110.DataLoad: Boolean;
var
  FileName : string;
  tk : TStringListKey;
begin
  result := False;
  FileName := GetFileName();
  if not FileExists(FileName) then exit;
  tk := TStringListKey.Create;
  try
    tk.LoadFromFile(FileName);
    FChannel.DataLoad(tk);
    result := True;
  finally
    tk.Free;
  end;

end;

function TFrameConfigTvChCs110.DataSave: Boolean;
var
  FileName : string;
  tk : TStringListKey;
begin
  FileName := GetFileName();
  tk := TStringListKey.Create;
  try
    result := False;
    FChannel.DataSave(tk);
    tk.SaveToFile(FileName);
    result := True;
  finally
    tk.Free;
  end;
end;

procedure TFrameConfigTvChCs110.BtnReLoadClick(Sender: TObject);
begin
  Get();
end;

procedure TFrameConfigTvChCs110.ChkLBoxChClickCheck(Sender: TObject);
var
  i,j : Integer;
  d,d2 : TDataTvChannelItem;
  dc : TCheckListBox;
  f : Boolean;
begin
  dc := ChkLBoxCh;
  j := dc.ItemIndex;
  f := dc.Checked[j];
  d := TDataTvChannelItem(dc.Items.Objects[j]);
  if d = nil then exit;

  i := FConfig.Items.IndexOfSkyPerfectTv110(d);

  if f then begin
    if i = -1 then begin
      d2 := FConfig.Items.Add();
      d2.Assign(d);
      d2.Visible := True;
    end
    else begin
      d2 := FConfig.Items[i];
      d2.Visible := True;
    end;
  end
  else begin
    if i = -1 then exit;
    FConfig.Items.Delete(i);
  end;
  DoChkChange();

end;

procedure TFrameConfigTvChCs110.DoChkChange;
begin
  if Assigned(FOnChkChange) then begin
    FOnChkChange(Self);
  end;
end;

end.
