unit FrameConfigTvChCATVUnit;

interface

uses Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, CheckLst,GetTvChOnTvJapanEx,DataTvChannel,GetTvChOnTvJapanBroadcast,
  ComCtrls, ExtCtrls,StringListKey,ProcPublicFileName;

type
  TFrameConfigTvChCATV = class(TFrame)
    PCtrl: TPageControl;
    TabSheetCh: TTabSheet;
    GroupBox2: TGroupBox;
    ChkLBoxCh: TCheckListBox;
    TabSheetWait: TTabSheet;
    Label1: TLabel;
    PBar: TProgressBar;
    TabSheetZip: TTabSheet;
    EditZip: TEdit;
    BtnZip: TButton;
    TabSheetBroadcast: TTabSheet;
    GroupBox3: TGroupBox;
    LBoxBroadcast: TListBox;
    Label2: TLabel;
    BtnResetZIP: TButton;
    BtnBroadcast: TButton;
    BtnBCastCancel: TButton;
    procedure BtnZipClick(Sender: TObject);
    procedure BtnBroadcastClick(Sender: TObject);
    procedure ChkLBoxChClickCheck(Sender: TObject);
    procedure BtnResetZIPClick(Sender: TObject);
    procedure BtnBCastCancelClick(Sender: TObject);
  private
    { Private 錾 }
    FConfig: TDataTvChannel;
    FGetBCast : TGetTvOnTvJapanBloadcast;
    FGetChOnTv : TGetTvOnTvJapanEx;
    FOnChkChange: TNotifyEvent;
    FChannel : TDataTvChannel;

    procedure DoChkChange();

    procedure ChAdd(dc : TDataTvChannelItem);
    procedure ChDel(dc : TDataTvChannelItem);

    procedure ShowBroadcast();
    procedure ShowCh();

    function GetFileName() : string;
    function DataLoad() : Boolean;
    function DataSave() : Boolean;

    procedure ProcBCastErr();

    procedure OnBCastReceive(Sender: TObject);
    procedure OnBCastError(Sender: TObject);
    procedure OnChReceive(Sender: TObject);
    procedure OnChError(Sender: TObject);
    procedure OnChProcessTv(Sender: TObject);
  public
    { Public 錾 }
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure Show();
    property Config : TDataTvChannel read FConfig write FConfig;
    property OnChkChange : TNotifyEvent read FOnChkChange write FOnChkChange;
  end;

implementation

{$R *.DFM}

{ TFrameConfigTvChCATV }

constructor TFrameConfigTvChCATV.Create(AOwner: TComponent);
begin
  inherited;
  FChannel := TDataTvChannel.Create;
  FGetBCast := TGetTvOnTvJapanBloadcast.Create;
  FGetBCast.OnReceive := OnBCastReceive;
  FGetBCast.OnError := OnBCastError;
  FGetChOnTv := TGetTvOnTvJapanEx.Create;
  FGetChOnTv.OnReceive := OnChReceive;
  FGetChOnTv.OnError := OnChError;
  FGetChOnTv.OnProcess := OnChProcessTv;
end;

destructor TFrameConfigTvChCATV.Destroy;
begin
  FGetChOnTv.Free;
  FGetBCast.Free;
  FChannel.Free;
  inherited;
end;

procedure TFrameConfigTvChCATV.Show;
begin
  if DataLoad() then begin     // t@CȌԂ擾łꍇ
    ShowCh();
    PCtrl.ActivePage := TabSheetCh;
  end
  else begin                   // t@C擾łȂꍇ
    PCtrl.ActivePage := TabSheetZip;
  end;
end;

procedure TFrameConfigTvChCATV.ShowBroadcast;
var
  dl : TListBox;
  i : Integer;
  //d : TDataRdRecReserveStringList;
begin
  dl := LBoxBroadcast;
  dl.Clear;
  for i := 0 to   FGetBCast.Broadcasts.Items.Count-1 do begin
    dl.Items.Add(FGetBCast.Broadcasts.Items[i].NameInfo);
  end;
  if dl.Items.Count > 0 then begin
    dl.ItemIndex := 0;
  end;
  PCtrl.ActivePage := TabSheetBroadcast;
end;

procedure TFrameConfigTvChCATV.BtnZipClick(Sender: TObject);
var
  s : string;
begin
  s := EditZip.Text;
  if Length(s) <> 7 then begin
    MessageDlg('X֔ԍ͂VKvłB',mtWarning	,[mbOk],0);
    exit;
  end;
  FGetBCast.Get(s);
  PCtrl.ActivePage := TabSheetWait;
end;

procedure TFrameConfigTvChCATV.OnBCastError(Sender: TObject);
begin
  ProcBCastErr();
end;

procedure TFrameConfigTvChCATV.OnBCastReceive(Sender: TObject);
begin
  FChannel.Items.AssignOnTvJapan(FGetChOnTv.Items);
  if FGetBCast.Broadcasts.Items.Count = 0 then begin
    ProcBCastErr();
  end
  else begin
    ShowBroadcast();
  end;
end;

procedure TFrameConfigTvChCATV.BtnBroadcastClick(Sender: TObject);
var
  i : Integer;
  s : string;
begin
  i := LBoxBroadcast.ItemIndex;
  if i = -1 then exit;
  s := FGetBCast.Broadcasts.Items[i].Value;
  FGetChOnTv.GetCATV(s);
  PCtrl.ActivePage := TabSheetWait;
end;

procedure TFrameConfigTvChCATV.OnChError(Sender: TObject);
begin
  MessageDlg('`l擾ɃG[܂B',mtWarning	,[mbOk],0);
  PCtrl.ActivePage := TabSheetBroadcast;
end;

procedure TFrameConfigTvChCATV.OnChReceive(Sender: TObject);
begin
  ShowCh();
end;

procedure TFrameConfigTvChCATV.ShowCh;
var
  i,j : Integer;
  d : TDataTvChannelItem;
  dc : TCheckListBox;
begin
  dc := ChkLBoxCh;
  dc.Clear;
  for j := 0 to FChannel.Items.Count-1 do begin
    d := FChannel.Items[j];
    dc.Items.AddObject(d.Name,d);
    i := FConfig.Items.IndexOfOnTvJapan(d,cmCATV);
    if i = -1 then continue;
    dc.Checked[dc.Items.Count-1] := FConfig.Items[i].Visible;
  end;
  PCtrl.ActivePage := TabSheetCh;
  DataSave();
end;

function TFrameConfigTvChCATV.DataLoad: Boolean;
var
  FileName : string;
  tk : TStringListKey;
begin
  result := False;
  FileName := GetFileName();
  if not FileExists(FileName) then exit;
  tk := TStringListKey.Create;
  try
    tk.LoadFromFile(FileName);
    FChannel.DataLoad(tk);
    result := True;
  finally
    tk.Free;
  end;
end;

function TFrameConfigTvChCATV.DataSave: Boolean;
var
  FileName : string;
  tk : TStringListKey;
begin
  FileName := GetFileName();
  tk := TStringListKey.Create;
  try
    result := False;
    FChannel.DataSave(tk);
    tk.SaveToFile(FileName);
    result := True;
  finally
    tk.Free;
  end;
end;

function TFrameConfigTvChCATV.GetFileName: string;
var
  s : string;
begin
  s := GetFilePathTemp();
  result := s + 'tmp_ChCATV.ini';
end;

procedure TFrameConfigTvChCATV.OnChProcessTv(Sender: TObject);
begin
  PBar.Position := FGetChOnTv.Page;
end;

procedure TFrameConfigTvChCATV.DoChkChange;
begin
  if Assigned(FOnChkChange) then begin
    FOnChkChange(Self);
  end;
end;

procedure TFrameConfigTvChCATV.ChkLBoxChClickCheck(Sender: TObject);
var
  d : TDataTvChannelItem;
  dc : TCheckListBox;
  i : Integer;
  f : Boolean;
begin
  dc := TCheckListBox(Sender);
  i := dc.ItemIndex;
  if i = -1 then exit;
  f := dc.Checked[i];
  d := TDataTvChannelItem(dc.Items.Objects[i]);
  if f then begin
    ChAdd(d);
  end
  else begin
    ChDel(d);
  end;
  DoChkChange();
end;

procedure TFrameConfigTvChCATV.ChAdd(dc: TDataTvChannelItem);
var
  i,j,Page : Integer;
  Adr : string;
  d1,d2 : TDataTvChannelItem;
begin
  Adr := dc.AdrNo;
  Page := dc.PageNo;
  i := FConfig.Items.IndexOfTvEx(dc);
  if i <> -1 then begin
    d1 := FConfig.Items[i];
    d1.Visible := True;
    exit;
  end;
  d1 := FConfig.Items.Add();
  d1.Assign(dc);
  d1.Visible := True;

  for j := 0 to FGetChOnTv.Items.Count-1 do begin
    d1 := FGetChOnTv.Items[j];
    if (d1.AdrNo <> Adr) or
       (d1.PageNo <> Page) then continue;
    i := FConfig.Items.IndexOfTvEx(d1);
    if i <> -1 then continue;
    d2 := FConfig.Items.Add();
    d2.Assign(d1);

  end;
end;

procedure TFrameConfigTvChCATV.ChDel(dc: TDataTvChannelItem);
var
  i,j,Page : Integer;
  Adr : string;
  d1 : TDataTvChannelItem;
  f : Boolean;
begin
  Adr := dc.AdrNo;
  Page := dc.PageNo;
  i := FConfig.Items.IndexOfTvEx(dc);
  if i = -1 then exit;

  d1 := FConfig.Items[i];
  d1.Visible := False;

  f := False;
  for j := 0 to FConfig.Items.Count-1 do begin
    d1 := FConfig.Items[j];
    if (d1.AdrNo = Adr) and
       (d1.PageNo = Page) and
       (d1.Visible) then begin
       f := True;
       break;
    end;
  end;
  if f then begin
    exit;
  end;
  for j := FConfig.Items.Count-1 downto 0 do begin
    d1 := FConfig.Items[j];
    if (d1.AdrNo = Adr) and
       (d1.PageNo = Page) then begin
      FConfig.Items.Delete(j);
    end;
  end;
end;

procedure TFrameConfigTvChCATV.BtnResetZIPClick(Sender: TObject);
begin
  PCtrl.ActivePage := TabSheetZip;
end;

procedure TFrameConfigTvChCATV.BtnBCastCancelClick(Sender: TObject);
begin
  PCtrl.ActivePage := TabSheetZip;
end;

procedure TFrameConfigTvChCATV.ProcBCastErr;
begin
  PCtrl.ActivePage := TabSheetZip;
  MessageDlg('Yb`suЂ܂łB',mtWarning	,[mbOk],0);
end;

end.
