unit FrameConfigTvChBsDUnit;

interface

uses Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, CheckLst,GetTvChCs,DataTvChannel,GetTvChOnTvJapanEx,
  ComCtrls, ExtCtrls,StringListKey,ProcPublicFileName;

type
  TFrameConfigTvChBsD = class(TFrame)
    PCtrl: TPageControl;
    TabSheetCh: TTabSheet;
    TabSheetWait: TTabSheet;
    GroupBox2: TGroupBox;
    ChkLBoxCh: TCheckListBox;
    PBar: TProgressBar;
    Label1: TLabel;
    PanelMenu: TPanel;
    BtnReLoad: TButton;
    procedure BtnReLoadClick(Sender: TObject);
    procedure ChkLBoxChClickCheck(Sender: TObject);
  private
    { Private 錾 }
    FConfig: TDataTvChannel;
    FChannel : TDataTvChannel;
    FGetChOnTv : TGetTvOnTvJapanEx;
    FReadOnTvJapan : Boolean;
    FReadSkyPerfectTv : Boolean;
    FOnChkChange: TNotifyEvent;

    procedure Get();
    procedure ShowCh();
    procedure ShowChGenre();

    function GetFileName() : string;
    function DataLoad() : Boolean;
    function DataSave() : Boolean;

    procedure ChAdd(dc : TDataTvChannelItem);
    procedure ChDel(dc : TDataTvChannelItem);

    procedure DoChkChange();

    procedure OnChReceiveTv(Sender: TObject);
    procedure OnChErrorTv(Sender: TObject);
    procedure OnChProcessTv(Sender: TObject);
  public
    { Public 錾 }
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure Show();
    property Config : TDataTvChannel read FConfig write FConfig;
    // gp`l`FbNnm^neeƂ̃Cxg
    property OnChkChange : TNotifyEvent read FOnChkChange write FOnChkChange;
  end;

implementation

{$R *.DFM}

{ TFrameConfigTvChCs110 }

constructor TFrameConfigTvChBsD.Create(AOwner: TComponent);
begin
  inherited;
  FChannel := TDataTvChannel.Create;

  FGetChOnTv := TGetTvOnTvJapanEx.Create;
  FGetChOnTv.OnReceive := OnChReceiveTv;
  FGetChOnTv.OnError := OnChErrorTv;
  FGetChOnTv.OnProcess := OnChProcessTv;
end;

destructor TFrameConfigTvChBsD.Destroy;
begin
  FGetChOnTv.Free;

  FChannel.Free;
  inherited;
end;

procedure TFrameConfigTvChBsD.Show;
begin
  if DataLoad() then begin     // t@CȌԂ擾łꍇ
    ShowChGenre();
    PCtrl.ActivePage := TabSheetCh;
  end
  else begin                   // t@C擾łȂꍇ
    Get();                     // z[y[W擾
  end;
end;

procedure TFrameConfigTvChBsD.Get;
begin
  FChannel.Items.Clear;
  FReadOnTvJapan := False;
  FReadSkyPerfectTv := False;
  PCtrl.ActivePage := TabSheetWait;
  FGetChOnTv.Get(cmBsDigital);
end;

procedure TFrameConfigTvChBsD.ShowCh;
begin
  ShowChGenre();
  PCtrl.ActivePage := TabSheetCh;
  DataSave();
end;

procedure TFrameConfigTvChBsD.ShowChGenre();
var
  i,j : Integer;
  d : TDataTvChannelItem;
  dc : TCheckListBox;
begin
  dc := ChkLBoxCh;
  dc.Clear;
  for j := 0 to FChannel.Items.Count-1 do begin
    d := FChannel.Items[j];
    dc.Items.AddObject(d.Name,d);
    i := FConfig.Items.IndexOfOnTvJapan(d,cmBsDigital);
    if i = -1 then continue;
    dc.Checked[dc.Items.Count-1] := FConfig.Items[i].Visible;
  end;

end;

procedure TFrameConfigTvChBsD.OnChReceiveTv(Sender: TObject);
begin
  FReadOnTvJapan := True;
  FChannel.Items.AssignOnTvJapan(FGetChOnTv.Items);
  ShowCh();
end;

procedure TFrameConfigTvChBsD.OnChErrorTv(Sender: TObject);
begin

end;

procedure TFrameConfigTvChBsD.OnChProcessTv(Sender: TObject);
begin
  PBar.Position := FGetChOnTv.Page;
end;

function TFrameConfigTvChBsD.GetFileName: string;
var
  s : string;
begin
  s := GetFilePathTemp();
  result := s + 'tmp_ChBsDigital.ini';
end;

function TFrameConfigTvChBsD.DataLoad: Boolean;
var
  FileName : string;
  tk : TStringListKey;
begin
  result := False;
  FileName := GetFileName();
  if not FileExists(FileName) then exit;
  tk := TStringListKey.Create;
  try
    tk.LoadFromFile(FileName);
    FChannel.DataLoad(tk);
    result := True;
  finally
    tk.Free;
  end;

end;

function TFrameConfigTvChBsD.DataSave: Boolean;
var
  FileName : string;
  tk : TStringListKey;
begin
  FileName := GetFileName();
  tk := TStringListKey.Create;
  try
    result := False;
    FChannel.DataSave(tk);
    tk.SaveToFile(FileName);
    result := True;
  finally
    tk.Free;
  end;
end;

procedure TFrameConfigTvChBsD.BtnReLoadClick(Sender: TObject);
begin
  Get();
end;

procedure TFrameConfigTvChBsD.ChkLBoxChClickCheck(Sender: TObject);
var
  d : TDataTvChannelItem;
  dc : TCheckListBox;
  i : Integer;
  f : Boolean;
begin
  dc := TCheckListBox(Sender);
  i := dc.ItemIndex;
  if i = -1 then exit;
  f := dc.Checked[i];
  d := TDataTvChannelItem(dc.Items.Objects[i]);
  if f then begin
    ChAdd(d);
  end
  else begin
    ChDel(d);
  end;
  DoChkChange();
end;

procedure TFrameConfigTvChBsD.ChAdd(dc: TDataTvChannelItem);
var
  i,j,Page : Integer;
  Adr : string;
  d1,d2 : TDataTvChannelItem;
begin
  Adr := dc.AdrNo;
  Page := dc.PageNo;
  i := FConfig.Items.IndexOfTvEx(dc);
  if i <> -1 then begin
    d1 := FConfig.Items[i];
    d1.Visible := True;
    exit;
  end;
  d1 := FConfig.Items.Add();
  d1.Assign(dc);
  d1.Visible := True;

  for j := 0 to FGetChOnTv.Items.Count-1 do begin
    d1 := FGetChOnTv.Items[j];
    if (d1.AdrNo <> Adr) or
       (d1.PageNo <> Page) then continue;
    i := FConfig.Items.IndexOfTvEx(d1);
    if i <> -1 then continue;
    d2 := FConfig.Items.Add();
    d2.Assign(d1);

  end;
end;

procedure TFrameConfigTvChBsD.ChDel(dc: TDataTvChannelItem);
var
  i,j,Page : Integer;
  Adr : string;
  d1 : TDataTvChannelItem;
  f : Boolean;
begin
  Adr := dc.AdrNo;
  Page := dc.PageNo;
  i := FConfig.Items.IndexOfTvEx(dc);
  if i = -1 then exit;

  d1 := FConfig.Items[i];
  d1.Visible := False;

  f := False;
  for j := 0 to FConfig.Items.Count-1 do begin
    d1 := FConfig.Items[j];
    if (d1.AdrNo = Adr) and
       (d1.PageNo = Page) and
       (d1.Visible) then begin
       f := True;
       break;
    end;
  end;
  if f then begin
    exit;
  end;
  for j := FConfig.Items.Count-1 downto 0 do begin
    d1 := FConfig.Items[j];
    if (d1.AdrNo = Adr) and
       (d1.PageNo = Page) then begin
      FConfig.Items.Delete(j);
    end;
  end;
end;

procedure TFrameConfigTvChBsD.DoChkChange;
begin
  if Assigned(FOnChkChange) then begin
    FOnChkChange(Self);
  end;
end;

end.
