unit FrameConfigRdUnit;

interface

uses Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, StdCtrls,FrameConfigRdSettingUnit,DataConfigRd,FrameConfigRdChUnit,
  DataConfig, ExtCtrls,GetRdStanderd,DataRd,DataRdRecReserve,DataRdRecReserveInfo,
  FrameConfigRdMailUnit,FrameConfigRdEncodeUnit;

type
  TFrameConfigRd = class(TFrame)
    GroupBox1: TGroupBox;
    LBoxRd: TListBox;
    PCtrl: TPageControl;
    TabSheetConfig: TTabSheet;
    BtnAdd: TButton;
    BtnDel: TButton;
    TabSheetCh: TTabSheet;
    PanelMenu: TPanel;
    BtnInfoGet: TButton;
    TabSheetMail: TTabSheet;
    TabSheetEncode: TTabSheet;
    procedure LBoxRdClick(Sender: TObject);
    procedure BtnAddClick(Sender: TObject);
    procedure BtnDelClick(Sender: TObject);
    procedure BtnInfoGetClick(Sender: TObject);
  private
    { Private 錾 }
    FFrameSetting : TFrameConfigRdSetting;
    FFrameCh : TFrameConfigRdCh;
    FFrameEncode : TFrameConfigRdEncode;
    FFrameMail : TFrameConfigRdMail;
    FConfig: TDataConfig;
    FGetRd : TGetRd;
    FRDIndex : Integer;
    FRec : TDataRdRecReserve;
    procedure ShowRdList();
    procedure ShowRd();
    procedure ShowRdItem(dr : TDataConfigRdItem;Index : Integer);
    procedure ViewRdList();
    procedure OnNameChange(Sender: TObject);
    procedure OnGetRdFinish(Sender: TObject);
  public
    { Public 錾 }
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure Show();
    property Config : TDataConfig read FConfig write FConfig;

  end;

implementation

uses DMUnit;

{$R *.DFM}

{ TFrameConfigRd }

constructor TFrameConfigRd.Create(AOwner: TComponent);
begin
  inherited;
  FFrameSetting := TFrameConfigRdSetting.Create(Self);
  FFrameSetting.Parent := TabSheetConfig;
  FFrameSetting.Align := alClient;
  FFrameSetting.OnNameChange := OnNameChange;

  FFrameCh := TFrameConfigRdCh.Create(Self);
  FFrameCh.Parent := TabSheetCh;
  FFrameCh.Align := alClient;

  FFrameEncode := TFrameConfigRdEncode.Create(Self);
  FFrameEncode.Parent := TabSheetEncode;
  FFrameEncode.Align := alClient;

  FFrameMail := TFrameConfigRdMail.Create(Self);
  FFrameMail.Parent := TabSheetMail;
  FFrameMail.Align := alClient;

  FGetRd := TGetRd.Create;
  FRec := TDataRdRecReserve.Create;
end;

destructor TFrameConfigRd.Destroy;
begin
  FRec.Free;
  FGetRd.Free;
  FFrameMail.Free;
  FFrameEncode.Free;
  FFrameCh.Free;
  FFrameSetting.Free;
  inherited;
end;

procedure TFrameConfigRd.Show;
begin
  ShowRdList();
  PCtrl.ActivePage := TabSheetConfig;
  //FFrameCh.Show();
end;

procedure TFrameConfigRd.ShowRdList;
var
  i,j : Integer;
  d : TDataConfigRdItem;
  dl : TListBox;
begin
  PCtrl.Enabled := False;
  dl := LBoxRd;
  j := dl.ItemIndex;
  dl.Clear;
  for i := 0 to FConfig.Rd.Items.Count-1 do begin
    d := FConfig.Rd.Items[i];
    dl.Items.AddObject(d.Name,d);
  end;
  if (j = -1) and
     (dl.Items.Count > 0) then begin
    dl.ItemIndex := 0;
    j := 0;
  end;
  if (j >= 0) and (j < dl.Items.Count) then begin
    d := FConfig.Rd.Items[j];
    ShowRdItem(d,j);
    dl.ItemIndex := j;
    PCtrl.Enabled := True;
  end;
end;

procedure TFrameConfigRd.ShowRdItem(dr: TDataConfigRdItem;Index : Integer);
begin

  //FConfig.Rd.Items[Index].
  FFrameSetting.Config := dr;
  FFrameSetting.Show();

  FFrameCh.Rd := dr;
  FFrameCh.TvChannel := FConfig.TvChannel;
  FFrameCh.RdInfo.Assign(FConfig.Rd.Items[Index].Info);
  FFrameCh.Show();

  FFrameEncode.Rd := dr;
  FFrameEncode.RdInfo.Assign(FConfig.Rd.Items[Index].Info);
  FFrameEncode.RdConfig := FConfig.Rd.Items[Index].Config;
  FFrameEncode.Show();

  FFrameMail.Config := dr;
  FFrameMail.Show();

  PCtrl.ActivePage := TabSheetConfig;
  TabSheetCh.TabVisible := (dr.Info.Channels.Items.Count > 0);
  TabSheetEncode.TabVisible := (dr.Info.Encode.Items.Count > 0);
  PCtrl.Enabled := True;
end;

procedure TFrameConfigRd.ShowRd;
var
  i : Integer;
  d : TDataConfigRdItem;
  dl : TListBox;
begin
  dl := LBoxRd;
  i := dl.ItemIndex;
  if i = -1 then exit;
  d := TDataConfigRdItem(dl.Items.Objects[i]);
  ShowRdItem(d,i);
end;

procedure TFrameConfigRd.LBoxRdClick(Sender: TObject);
begin
  ShowRd();
end;

procedure TFrameConfigRd.BtnAddClick(Sender: TObject);
var
  d : TDataConfigRdItem;
begin
  d := FConfig.Rd.Items.Add();
  d.Name := '@햼' + IntToStr(FConfig.Rd.Items.Count);
  ShowRdList();
end;

procedure TFrameConfigRd.BtnDelClick(Sender: TObject);
var
  i : Integer;
  dl : TListBox;
begin
  dl := LBoxRd;
  i := dl.ItemIndex;
  if i = -1 then exit;
  FConfig.Rd.Items.Delete(i);
  if i > 0 then dl.ItemIndex := i -1;
  ShowRdList();
end;

procedure TFrameConfigRd.OnNameChange(Sender: TObject);
begin
  ViewRdList();
end;

procedure TFrameConfigRd.ViewRdList;
var
  i : Integer;
  dl : TListBox;
  d : TDataConfigRdItem;
begin
  dl := LBoxRd;
  for i := 0 to dl.Items.Count-1 do begin
    d := TDataConfigRdItem(dl.Items.Objects[i]);
    dl.Items.Strings[i] := d.Name;
  end;

end;

procedure TFrameConfigRd.BtnInfoGetClick(Sender: TObject);
var
  d : TDataConfigRdItem;
begin
  FRDIndex := LBoxRd.ItemIndex;
  d := FConfig.Rd.Items[FRDIndex];
  FGetRd.Engine := DM.Define.Rd.Matines[d.MatineName].Engine;
  FGetRd.RdRec := FRec;
  FGetRd.RdInfo := FConfig.Rd.Items[FRDIndex].Info;
  FGetRd.Config.Assign(d);
  FGetRd.Define.Assign(DM.Define.Rd.Matines[d.MatineName]);
  FGetRd.OnProcFinish := OnGetRdFinish;
  FGetRd.MatineInfoGet();
end;

procedure TFrameConfigRd.OnGetRdFinish(Sender: TObject);
begin
  ShowRd();
end;


end.
