unit FrameConfigRdSettingUnit;

interface

uses Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,ComboBoxEx,DataConfigRd,DataDefineRd;

type
  TFrameConfigRdSetting = class(TFrame)
    CBoxMatine: TComboBox;
    Label1: TLabel;
    EditName: TEdit;
    EditAdr: TEdit;
    Label2: TLabel;
    Label3: TLabel;
    EditPort: TEdit;
    Label4: TLabel;
    ChkPass: TCheckBox;
    EditUser: TEdit;
    Label5: TLabel;
    EditPass: TEdit;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    EditMark: TEdit;
    ChkBoxDebugRead: TCheckBox;
    ChkBoxDebugWrite: TCheckBox;
    Label9: TLabel;
    procedure CBoxMatineChange(Sender: TObject);
    procedure EditNameExit(Sender: TObject);
    procedure EditAdrExit(Sender: TObject);
    procedure EditPortExit(Sender: TObject);
    procedure EditUserExit(Sender: TObject);
    procedure EditPassExit(Sender: TObject);
    procedure EditMarkExit(Sender: TObject);
    procedure ChkPassClick(Sender: TObject);
    procedure ChkBoxDebugReadClick(Sender: TObject);
    procedure ChkBoxDebugWriteClick(Sender: TObject);
    procedure CBoxMatineClick(Sender: TObject);
  private
    { Private 錾 }
    FCBoxColor : TComboboxColorText;
    FConfig: TDataConfigRdItem;
    FOnNameChange: TNotifyEvent;
    procedure ShowMatineName();
    procedure DoNameChange();
    procedure OnRecColorChange(Sender: TObject);
    procedure ViewChkPass();
    procedure View();
  public
    { Public 錾 }
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure Show();
    property Config : TDataConfigRdItem read FConfig write FConfig;
    property OnNameChange : TNotifyEvent read FOnNameChange write FOnNameChange;
  end;

implementation

uses DMUnit;

{$R *.DFM}

{ TFrameConfigRdSetting }

constructor TFrameConfigRdSetting.Create(AOwner: TComponent);
begin
  inherited;
  FCBoxColor := TComboboxColorText.Create(Self);
  FCBoxColor.Parent := Self;
  FCBoxColor.Left := 88;
  FCBoxColor.Top := 232;
  FCBoxColor.Width := 65;
  FCBoxColor.OnChange := OnRecColorChange;
end;

destructor TFrameConfigRdSetting.Destroy;
begin
  FCBoxColor.Free;
  inherited;
end;

procedure TFrameConfigRdSetting.Show;
begin
  FCBoxColor.View;
  EditName.Text := FConfig.Name;
  ShowMatineName();
  EditAdr.Text := FConfig.Host;
  EditPort.Text := IntToStr(FConfig.Port);
  ChkPass.Checked := FConfig.EnablePassword;
  EditUser.Text := FConfig.User;
  EditPass.Text := FConfig.Password;
  FCBoxColor.ValueColor := FConfig.RecMarkColor;
  EditMark.Text := FConfig.RecMarkText;
  ChkBoxDebugRead.Checked := FConfig.DebugRead;
  View();
end;

procedure TFrameConfigRdSetting.View;
var
  dc : TComboBox;
  d : TDataDefineRdItem;
  i : Integer;
begin
  FCBoxColor.View;
  EditName.Text := FConfig.Name;
  EditAdr.Text := FConfig.Host;
  EditPort.Text := IntToStr(FConfig.Port);
  ChkPass.Checked := FConfig.EnablePassword;
  EditUser.Text := FConfig.User;
  EditPass.Text := FConfig.Password;
  FCBoxColor.ValueColor := FConfig.RecMarkColor;
  EditMark.Text := FConfig.RecMarkText;
  EditMark.Font.Color := FConfig.RecMarkColor;
  ChkBoxDebugRead.Checked := FConfig.DebugRead;
  ChkBoxDebugWrite.Checked := FConfig.DebugWrite;
  dc := CBoxMatine;
  for i := 0 to dc.Items.Count-1 do begin
    d := TDataDefineRdItem(dc.Items.Objects[i]);
    if d.Name = FConfig.MatineName then begin
      if dc.ItemIndex <> i then dc.ItemIndex := i;
    end;
  end;
  ViewChkPass();
end;

procedure TFrameConfigRdSetting.ShowMatineName;
var
  dc : TComboBox;
  d : TDataDefineRdItem;
  i : Integer;
begin
  dc := CBoxMatine;
  dc.Clear;
  for i := 0 to DM.Define.Rd.Items.Count-1 do begin
    d := DM.Define.Rd.Items[i];
    dc.Items.AddObject(d.Name,d);
  end;
end;

procedure TFrameConfigRdSetting.CBoxMatineChange(Sender: TObject);
var
  dc : TComboBox;
  d : TDataDefineRdItem;
  i : Integer;
begin
  dc := TComboBox(Sender);
  i := dc.ItemIndex;
  if i = -1 then exit;
  d := TDataDefineRdItem(dc.Items.Objects[i]);
  FConfig.MatineName := d.Name;
  FConfig.Host := ''+d.Name;
  View();
end;

procedure TFrameConfigRdSetting.EditNameExit(Sender: TObject);
var
  de : TEdit;
begin
  de := TEdit(Sender);
  FConfig.Name := de.Text;
  DoNameChange();
end;

procedure TFrameConfigRdSetting.DoNameChange;
begin
  if Assigned(FOnNameChange) then begin
    FOnNameChange(Self);
  end;  
end;

procedure TFrameConfigRdSetting.EditAdrExit(Sender: TObject);
var
  de : TEdit;
begin
  de := TEdit(Sender);
  FConfig.Host := de.Text;
end;

procedure TFrameConfigRdSetting.EditPortExit(Sender: TObject);
var
  de : TEdit;
begin
  de := TEdit(Sender);
  FConfig.Port := StrToIntDef(de.Text,80);
end;

procedure TFrameConfigRdSetting.EditUserExit(Sender: TObject);
var
  de : TEdit;
begin
  de := TEdit(Sender);
  FConfig.User := de.Text;
end;

procedure TFrameConfigRdSetting.EditPassExit(Sender: TObject);
var
  de : TEdit;
begin
  de := TEdit(Sender);
  FConfig.Password := de.Text;
end;

procedure TFrameConfigRdSetting.EditMarkExit(Sender: TObject);
var
  de : TEdit;
begin
  de := TEdit(Sender);
  FConfig.RecMarkText := de.Text;
end;

procedure TFrameConfigRdSetting.OnRecColorChange(Sender: TObject);
var
  dc : TComboboxColorText;
begin
  dc := TComboboxColorText(Sender);
  FConfig.RecMarkColor := dc.ValueColor;
  View();
end;

procedure TFrameConfigRdSetting.ChkPassClick(Sender: TObject);
var
  dc : TCheckBox;
begin
  dc := TCheckBox(Sender);
  FConfig.EnablePassword := dc.Checked;
  ViewChkPass();
end;

procedure TFrameConfigRdSetting.ViewChkPass;
var
  f : Boolean;
begin
  f := ChkPass.Checked;
  EditUser.Enabled := f;
  EditPass.Enabled := f;
end;

procedure TFrameConfigRdSetting.ChkBoxDebugReadClick(Sender: TObject);
var
  f : Boolean;
begin
  f := TCheckBox(Sender).Checked;
  FConfig.DebugRead := f;
end;

procedure TFrameConfigRdSetting.ChkBoxDebugWriteClick(Sender: TObject);
var
  f : Boolean;
begin
  f := TCheckBox(Sender).Checked;
  FConfig.DebugWrite := f;
end;

procedure TFrameConfigRdSetting.CBoxMatineClick(Sender: TObject);
var
  dc : TComboBox;
  d : TDataDefineRdItem;
  i : Integer;
begin
  dc := TComboBox(Sender);
  i := dc.ItemIndex;
  if i = -1 then exit;
  d := TDataDefineRdItem(dc.Items.Objects[i]);
  FConfig.MatineName := d.Name;
  FConfig.Host := ''+d.Name;
  View();
end;

end.
