unit FrameConfigRdMailUnit;

interface

uses Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,ComboBoxEx,DataConfigRd,DataDefineRd, ExtCtrls;

type
  TFrameConfigRdMail = class(TFrame)
    PanelMenu: TPanel;
    ChkBoxMailUsed: TCheckBox;
    PanelClient: TPanel;
    Label1: TLabel;
    EditAddress: TEdit;
    Label2: TLabel;
    EditPassword: TEdit;
    Label3: TLabel;
    MemoMsg: TMemo;
    BtnDefault: TButton;
    procedure ChkBoxMailUsedClick(Sender: TObject);
    procedure EditAddressExit(Sender: TObject);
    procedure EditPasswordExit(Sender: TObject);
    procedure MemoMsgExit(Sender: TObject);
    procedure BtnDefaultClick(Sender: TObject);
  private
    { Private 錾 }
    FConfig: TDataConfigRdItem;
    procedure View();
  public
    { Public 錾 }
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure Show();
    property Config : TDataConfigRdItem read FConfig write FConfig;
  end;

implementation

{$R *.DFM}

{ TFrameConfigRdMail }

constructor TFrameConfigRdMail.Create(AOwner: TComponent);
begin
  inherited;

end;

destructor TFrameConfigRdMail.Destroy;
begin
  inherited;

end;

procedure TFrameConfigRdMail.Show;
begin
  View();
end;

procedure TFrameConfigRdMail.View;
begin
  ChkBoxMailUsed.Checked := FConfig.MailUsed;
  PanelClient.Visible := FConfig.MailUsed;
  EditAddress.Text := FConfig.MailAddress;
  EditPassword.Text := FConfig.MailPassword;
  MemoMsg.Text      := FConfig.MailMessage;
end;

procedure TFrameConfigRdMail.ChkBoxMailUsedClick(Sender: TObject);
begin
  FConfig.MailUsed := ChkBoxMailUsed.Checked;
  PanelClient.Visible := FConfig.MailUsed;
end;

procedure TFrameConfigRdMail.EditAddressExit(Sender: TObject);
begin
  FConfig.MailAddress := EditAddress.Text;
end;

procedure TFrameConfigRdMail.EditPasswordExit(Sender: TObject);
begin
  FConfig.MailPassword := EditPassword.Text;
end;

procedure TFrameConfigRdMail.MemoMsgExit(Sender: TObject);
begin
  FConfig.MailMessage := MemoMsg.Text;
end;

procedure TFrameConfigRdMail.BtnDefaultClick(Sender: TObject);
begin
  MemoMsg.Text := 'open %pass %date %time1 %time2 %ch %rate %audio ';
end;

end.
