unit FrameConfigRdEncodeUnit;

interface

uses Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls,DataConfigRd,DataRd,DataRdRecReserveChannel,
     DataTvChannel,DataConfigRdChannel,DataRdRecReserveInfo,
     DataRdRecReserveEncode,DataConfigRdConfig,DataConfigRdConfigEncode,
     FrameConfigRdEncodeModeUnit;

type
  TFrameConfigRdEncode = class(TFrame)
    PanelList: TPanel;
  private
    { Private 錾 }
    FFrameList : TList;
    FRd: TDataConfigRdItem;
    FRdInfo: TDataRdRecReserveInfo;
    FRdConfig: TDataConfigRdConfig;
    procedure ShowItem(i : Integer);
    procedure FrameClear();
  public
    { Public 錾 }
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure Show();
    property Rd : TDataConfigRdItem read FRd write FRd;
    property RdInfo : TDataRdRecReserveInfo read FRdInfo write FRdInfo;
    // qc̃GR[_ɑ΂ă[U[ݒ肷f[^
    property RdConfig : TDataConfigRdConfig read FRdConfig write FRdConfig;
  end;

implementation

{$R *.DFM}

{ TFrameConfigRdEncode }

constructor TFrameConfigRdEncode.Create(AOwner: TComponent);
begin
  inherited;
  FFrameList := TList.Create;
  FRdInfo := TDataRdRecReserveInfo.Create;
end;

destructor TFrameConfigRdEncode.Destroy;
begin
  inherited;
  FRdInfo.Free;
  FFrameList.Free;
end;

procedure TFrameConfigRdEncode.Show;
var
  i : Integer;
  s : string;
  d : TDataRdRecReserveEncodeItem;
  df : TFrameConfigRdEncodeMode;
begin
  FrameClear();
  for i := 0 to FRdInfo.Encode.Items.Count-1 do begin
    d := FRdInfo.Encode.Items[i];

    df := TFrameConfigRdEncodeMode.Create(Self);
    df.Parent := PanelList;
    df.Align := alTop;
    df.Name := 'Frame' + IntToStr(i);
    df.RdConfig := RdConfig;
    df.Encode := d;
    df.Show();
    FFrameList.Add(df);
  end;
end;

procedure TFrameConfigRdEncode.ShowItem(i: Integer);
begin
end;


procedure TFrameConfigRdEncode.FrameClear;
var
  df : TFrameConfigRdEncodeMode;
  i : Integer;
begin
  for i := 0 to FFrameList.Count-1 do begin
    df := TFrameConfigRdEncodeMode(FFrameList.Items[i]);
    df.Free;
  end;
  FFrameList.Clear;
end;

end.
