unit FrameConfigRdEncodeModeUnit;

interface

uses Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls,DataConfigRd,DataRd,DataRdRecReserveChannel,
     DataTvChannel,DataConfigRdChannel,DataRdRecReserveInfo,
     DataRdRecReserveEncode,DataConfigRdConfig,DataConfigRdConfigEncode,
     DrawRdRecReserve,DataRdRecReserve;

type
  TFrameConfigRdEncodeMode = class(TFrame)
    GBox: TGroupBox;
    PanelDraw: TPanel;
    BtnBack: TButton;
    PanelColorBack: TPanel;
    DlgColor: TColorDialog;
    ImageRd: TImage;
    PanelColorEdge: TPanel;
    BtnEdge: TButton;
    PanelColorFont: TPanel;
    BtnFont: TButton;
    procedure BtnBackClick(Sender: TObject);
    procedure BtnEdgeClick(Sender: TObject);
    procedure BtnFontClick(Sender: TObject);
  private
    function GetMode: TDataConfigRdConfigEncodeItem;
  private
    { Private 錾 }
    FEncode: TDataRdRecReserveEncodeItem;
    FRdConfig: TDataConfigRdConfig;
    property Mode : TDataConfigRdConfigEncodeItem read GetMode;
    procedure ProcDraw();
  public
    { Public 錾 }
    procedure Show();
    property Encode : TDataRdRecReserveEncodeItem read FEncode write FEncode;
    // qc̃GR[_ɑ΂ă[U[ݒ肷f[^
    property RdConfig : TDataConfigRdConfig read FRdConfig write FRdConfig;
  end;

implementation

{$R *.DFM}

{ TFrameConfigRdEncodeMode }

function TFrameConfigRdEncodeMode.GetMode: TDataConfigRdConfigEncodeItem;
begin
  result := FRdConfig.Encode.Modes[Encode.Mode];
end;

procedure TFrameConfigRdEncodeMode.Show;
var
  s : string;
  r : TRect;
begin
  //r := PanelColorBack.ClientRect;
  //ImageRd.SetBounds(r.Left,r.Top,r.Right - r.Left,r.Bottom - r.Top);
  s := Encode.ModeStr;
  GBox.Caption := s;
  PanelColorBack.Color := Mode.ColorBack;
  PanelColorEdge.Color := Mode.ColorEdge;
  PanelColorFont.Color := Mode.ColorFont;
  ProcDraw();
end;

procedure TFrameConfigRdEncodeMode.BtnBackClick(Sender: TObject);
begin
  DlgColor.Color := Mode.ColorBack;
  if not DlgColor.Execute then exit;
  Mode.ColorBack := DlgColor.Color;
  PanelColorBack.Color := Mode.ColorBack;
  ProcDraw();
end;

procedure TFrameConfigRdEncodeMode.BtnEdgeClick(Sender: TObject);
begin
  DlgColor.Color := Mode.ColorEdge;
  if not DlgColor.Execute then exit;
  Mode.ColorEdge := DlgColor.Color;
  PanelColorEdge.Color := Mode.ColorEdge;
  ProcDraw();
end;

procedure TFrameConfigRdEncodeMode.BtnFontClick(Sender: TObject);
begin
  DlgColor.Color := Mode.ColorFont;
  if not DlgColor.Execute then exit;
  Mode.ColorFont := DlgColor.Color;
  PanelColorFont.Color := Mode.ColorFont;
  ProcDraw();
end;

procedure TFrameConfigRdEncodeMode.ProcDraw;
var
  r : TRect;
  d : TDataRdRecReserveItem;
begin
  r := ImageRd.ClientRect;
  d := TDataRdRecReserveItem.Create;
  try
    //rdi := FEventCurRd.Cursor.Rd.RdIndex;
    d.Execution := True;
    d.Encoder := FEncode.Mode;
    DrawRdRecReserveDraw(ImageRd.Canvas,d,FRdConfig,r,False);
  finally
    d.Free;
  end;
end;

end.
