unit FrameConfigRdChUnit;

interface

uses Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
     StdCtrls,ListViewV, ExtCtrls,DataConfigRd,DataRd,DataRdRecReserveChannel,
     DataTvChannel,DataConfigRdChannel,DataRdRecReserveInfo;

type
  TFrameConfigRdCh = class(TFrame)
    PanelMenu: TPanel;
  private
    { Private 錾 }
    FListV : TListViewV;
    FCBoxCh : TComboBox;
    FRd: TDataConfigRdItem;
    FTvChannel : TDataTvChannel;
    FRdInfo: TDataRdRecReserveInfo;

    procedure TvChToRdCh(dc : TDataTvChannelItem; var drdch : TDataRdRecReserveChannelItem;
                         var dtvch : TDataConfigRdChannelLineItem);

    function ChinfoToStr(drdch : TDataRdRecReserveChannelItem) : string;

    procedure ShowChList();

    procedure ShowColumn();
    procedure ShowChComboBox();

    procedure OnDrawItem(Canvas : TCanvas;Column,Index: Integer;
                                         Rect: TRect; State: TOwnerDrawState);
    procedure OnListClick(Sender: TObject);
    procedure OnCBoxChClick(Sender: TObject);
  public
    { Public 錾 }
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure Show();
    property Rd : TDataConfigRdItem read FRd write FRd;
    property RdInfo : TDataRdRecReserveInfo read FRdInfo write FRdInfo;
    property TvChannel : TDataTvChannel read FTvChannel write FTvChannel;
  end;

implementation

uses DMUnit;

{$R *.DFM}

{ TFrameConfigRdCh }

constructor TFrameConfigRdCh.Create(AOwner: TComponent);
begin
  inherited;

  FRdInfo := TDataRdRecReserveInfo.Create;

  FListV := TListViewV.Create(Self);
  FListV.Parent := Self;
  FListV.Align := alClient;
  FListV.OnDrawItem  := OnDrawItem;
  FListV.Style := lvOwnerDrawFixed;
  FListV.OnListClick := OnListClick;
  FListV.ItemHeight := 20;

  FCBoxCh := TComboBox.Create(Self);
  FCBoxCh.Parent := FListV;
  FCBoxCh.Width := 200;
  FCBoxCh.Style := csDropDownList;
  FCBoxCh.OnChange := OnCBoxChClick;
  FCBoxCh.Visible := False;

end;

destructor TFrameConfigRdCh.Destroy;
begin
  FCBoxCh.Free;
  FListV.Free;
  FRdInfo.Free;
  inherited;

end;

procedure TFrameConfigRdCh.OnCBoxChClick(Sender: TObject);
var
  drdch : TDataRdRecReserveChannelItem;
  dc : TComboBox;
  dtvch : TDataTvChannelItem;
  dline : TDataConfigRdChannelLineItem;
  i,j,k : Integer;
begin
  i := FListV.ItemIndex;
  if i = -1 then exit;
  dtvch := TDataTvChannelItem(FListV.Items[i].Data);
  dc := TComboBox(Sender);
  j := dc.ItemIndex;
  drdch := TDataRdRecReserveChannelItem(dc.Items.Objects[j]);
  k := FRd.Channels.IndexOfTvEx(dtvch.ChannelTv,dtvch.ChannelEx);
  if k = -1 then begin
    dline := FRd.Channels.Items.Add();
  end
  else begin
    dline := FRd.Channels.Items[k];
  end;
  if drdch <> nil then begin
    dline.ChannelTv := dtvch.ChannelTv;
    dline.ChannelEx := dtvch.ChannelEx;
    dline.Line      := drdch.Value;
  end
  else begin
    dline.ChannelTv := dtvch.ChannelTv;
    dline.ChannelEx := dtvch.ChannelEx;
    dline.Line      := '';
  end;
end;

function TFrameConfigRdCh.ChinfoToStr(
  drdch: TDataRdRecReserveChannelItem): string;
var
  s : string;
  aMode : TDataRdRecReserveChannelMode;
begin
  aMode := drdch.Mode;
  s := TDataRdRecReserveChannelTbl[Ord(aMode)];
  s := Copy(s + '                  ',1,24);
  s := s + ' : ';
  s := s + drdch.NameInfo;
  result := s;
end;

procedure TFrameConfigRdCh.OnDrawItem(Canvas: TCanvas; Column,
  Index: Integer; Rect: TRect; State: TOwnerDrawState);
var
  drdch : TDataRdRecReserveChannelItem;
  dc : TDataTvChannelItem;
  di : TListViewVItem;
  dtvch : TDataConfigRdChannelLineItem;
  s : string;
begin
  di := FListV.Items[Index];
  dc := TDataTvChannelItem(di.Data);
  if dc = nil then exit;
  TvChToRdCh(dc,drdch,dtvch);

  case Column of
    0 : begin
          s := dc.Name;
          Canvas.TextRect(Rect,Rect.Left+1,Rect.Top+1,s);
        end;
    2 : begin
          s := '';
          if dtvch <> nil then begin
            s := dtvch.Line;
          end;
          Canvas.TextRect(Rect,Rect.Left+1,Rect.Top+1,s);
        end;
    1 : begin
          s := '';
          if drdch <> nil then begin
            s := ChinfoToStr(drdch);
          end;
          Canvas.TextRect(Rect,Rect.Left+1,Rect.Top+1,s);
        end;
  end;
end;

procedure TFrameConfigRdCh.OnListClick(Sender: TObject);
var
  drdch : TDataRdRecReserveChannelItem;
  dc : TDataTvChannelItem;
  dtvch : TDataConfigRdChannelLineItem;
  i : Integer;
begin
  i := FListV.ItemIndex;
  FCBoxCh.Left := FListV.Columns[0].Width;
  FCBoxCh.Top  := (i - FListV.TopIndex) * FListV.ItemHeight+22;
  dc := TDataTvChannelItem(FListV.Items[i].Data);
  TvChToRdCh(dc,drdch,dtvch);
  i := FCBoxCh.Items.IndexOfObject(drdch);
  FCBoxCh.ItemIndex := i;
  FCBoxCh.Visible := True;
end;

procedure TFrameConfigRdCh.Show;
begin
  ShowColumn();
  ShowChList();
  ShowChComboBox();
end;

procedure TFrameConfigRdCh.ShowChList;
var
  dv : TListViewV;
  di : TListViewVItem;
  dc : TDataTvChannelItem;
  i : Integer;
begin
  dv := FListV;
  dv.Items.Clear;

  for i := 0 to FTvChannel.Items.Count-1 do begin
    dc := FTvChannel.Items[i];
    if not dc.Visible then continue;
    di := dv.Items.Add();
    di.Data := dc;
  end;
end;

procedure TFrameConfigRdCh.TvChToRdCh(dc: TDataTvChannelItem;
  var drdch: TDataRdRecReserveChannelItem;
  var dtvch: TDataConfigRdChannelLineItem);
var
  i : Integer;
begin
  i := FRd.Channels.IndexOfTvEx(dc.ChannelTv,dc.ChannelEx);
  dtvch := nil;
  drdch := nil;
  if i >= 0 then dtvch := FRd.Channels.Items[i];
  if dtvch <> nil then begin
    i := FRdInfo.Channels.Items.IndexOfValue(dtvch.Line);
    if i >= 0 then begin
      drdch := FRdInfo.Channels.Items[i];
    end;
  end;

end;

procedure TFrameConfigRdCh.ShowChComboBox;
var
  i : Integer;
  d : TDataRdRecReserveChannelItem;
  s : string;
begin
  FCBoxCh.Clear;
  FCBoxCh.Items.AddObject('w薳',nil);
  for i := 0 to FRdInfo.Channels.Items.Count-1 do begin
    d := FRdInfo.Channels.Items[i];
    s := ChinfoToStr(d);
    FCBoxCh.Items.AddObject(s,d);
  end;

end;


procedure TFrameConfigRdCh.ShowColumn;
var
  c : TListViewVColumn;
  dv : TListViewVColumns;
begin
  dv := FListV.Columns;
  dv.Clear;
  c := dv.Add();
  c.Caption := 'ǖ';
  c.Width   := 120;
  c := dv.Add();
  c.Caption := '`l';
  c.Width   := 200;

  //Visible := True;
end;

end.
