unit FrameConfigNormalUnit;

interface

uses Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, StdCtrls,DataConfig;

type
  TFrameConfigNormal = class(TFrame)
    EditReadDay: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    UpDownReadDay: TUpDown;
    Label3: TLabel;
    EditOldDay: TEdit;
    Label4: TLabel;
    UpDownOldDay: TUpDown;
    procedure UpDownReadDayClick(Sender: TObject; Button: TUDBtnType);
    procedure UpDownOldDayClick(Sender: TObject; Button: TUDBtnType);
  private
    { Private 錾 }
    FConfig: TDataConfig;
    procedure View();
  public
    { Public 錾 }
    procedure Show();
    property Config : TDataConfig read FConfig write FConfig;
  end;

implementation

{$R *.DFM}

{ TFrameConfigNormal }

procedure TFrameConfigNormal.Show;
begin
  UpDownReadDay.Position := Config.Normal.ReadDay;
  UpDownOldDay.Position := Config.Normal.OldDay;
  View();
end;

procedure TFrameConfigNormal.View;
begin
  EditReadDay.Text := IntToStr(Config.Normal.ReadDay);
  EditOldDay.Text  := IntToStr(Config.Normal.OldDay);
end;

procedure TFrameConfigNormal.UpDownReadDayClick(Sender: TObject;
  Button: TUDBtnType);
begin
  Config.Normal.ReadDay := TUpDown(Sender).Position;
  View();
end;

procedure TFrameConfigNormal.UpDownOldDayClick(Sender: TObject;
  Button: TUDBtnType);
begin
  Config.Normal.OldDay := TUpDown(Sender).Position;
  View();
end;

end.
