unit FrameConfigMailUnit;

interface

uses Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls,DataConfig,DataConfigMail, Spin,WinSockVSmtpClient;

type
  TFrameConfigMail = class(TFrame)
    PanelClient: TPanel;
    Label1: TLabel;
    EditSmtpHost: TEdit;
    PanelMenu: TPanel;
    ChkBoxUsed: TCheckBox;
    CBoxAuth: TComboBox;
    Label2: TLabel;
    Label3: TLabel;
    EditUser: TEdit;
    EditPassword: TEdit;
    Label4: TLabel;
    Label5: TLabel;
    SpinEditPort: TSpinEdit;
    Label6: TLabel;
    Label7: TLabel;
    EditFromMail: TEdit;
    EditFromName: TEdit;
    procedure ChkBoxUsedClick(Sender: TObject);
    procedure EditSmtpHostExit(Sender: TObject);
    procedure SpinEditPortExit(Sender: TObject);
    procedure CBoxAuthExit(Sender: TObject);
    procedure EditUserExit(Sender: TObject);
    procedure EditPasswordExit(Sender: TObject);
    procedure EditFromMailExit(Sender: TObject);
    procedure EditFromNameExit(Sender: TObject);
  private
    { Private 錾 }
    FConfig: TDataConfig;
    procedure View();
  public
    { Public 錾 }
    procedure Show();
    property Config : TDataConfig read FConfig write FConfig;
  end;

implementation

{$R *.DFM}

{ TFrameConfigMail }

procedure TFrameConfigMail.Show;
begin
  View();
end;

procedure TFrameConfigMail.View;
var
  dcm : TDataConfigMail;
begin
  dcm := FConfig.Mail;
  ChkBoxUsed.Checked := dcm.Used;
  PanelClient.Visible := dcm.Used;
  EditSmtpHost.Text   := dcm.Host;
  SpinEditPort.Value := dcm.Port;
  CBoxAuth.ItemIndex := Ord(dcm.Auth);
  EditUser.Text := dcm.User;
  EditPassword.Text := dcm.Password;
  EditFromMail.Text := dcm.FromMail;
  EditFromName.Text := dcm.FromName;
end;

procedure TFrameConfigMail.ChkBoxUsedClick(Sender: TObject);
var
  dcm : TDataConfigMail;
begin
  dcm := FConfig.Mail;
  dcm.Used := ChkBoxUsed.Checked;
  PanelClient.Visible := dcm.Used;
end;

procedure TFrameConfigMail.EditSmtpHostExit(Sender: TObject);
var
  dcm : TDataConfigMail;
begin
  dcm := FConfig.Mail;
  dcm.Host := EditSmtpHost.Text;
end;

procedure TFrameConfigMail.SpinEditPortExit(Sender: TObject);
var
  dcm : TDataConfigMail;
begin
  dcm := FConfig.Mail;
  dcm.Port := SpinEditPort.Value;
end;

procedure TFrameConfigMail.CBoxAuthExit(Sender: TObject);
var
  dcm : TDataConfigMail;
  i : Integer;
begin
  dcm := FConfig.Mail;
  i := CBoxAuth.ItemIndex;
  dcm.Auth := TWinSockVSmtpClientAuth(i);
end;

procedure TFrameConfigMail.EditUserExit(Sender: TObject);
var
  dcm : TDataConfigMail;
begin
  dcm := FConfig.Mail;
  dcm.User := EditUser.Text;
end;

procedure TFrameConfigMail.EditPasswordExit(Sender: TObject);
var
  dcm : TDataConfigMail;
begin
  dcm := FConfig.Mail;
  dcm.Password := EditPassword.Text;
end;

procedure TFrameConfigMail.EditFromMailExit(Sender: TObject);
var
  dcm : TDataConfigMail;
begin
  dcm := FConfig.Mail;
  dcm.FromMail := EditFromMail.Text;
end;

procedure TFrameConfigMail.EditFromNameExit(Sender: TObject);
var
  dcm : TDataConfigMail;
begin
  dcm := FConfig.Mail;
  dcm.FromName := EditFromName.Text;
end;

end.
