unit FrameConfigGenreUnit;

interface

uses Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
     DataConfig, StdCtrls, ExtCtrls,DataConfigTvGenre,DataTvScheduleGenre;

type
  TFrameConfigGenre = class(TFrame)
    PanelMenu: TPanel;
    Label1: TLabel;
    EditGenre: TEdit;
    Label2: TLabel;
    CBoxGenre: TComboBox;
    DlgColor: TColorDialog;
    Panel1: TPanel;
    GroupBox1: TGroupBox;
    LBoxGenre: TListBox;
    BtnAdd: TButton;
    BtnDel: TButton;
    GroupBox2: TGroupBox;
    CBoxColor: TComboBox;
    PanelColor1: TPanel;
    BtnColor1: TButton;
    Label3: TLabel;
    PanelColor2: TPanel;
    BtnColor2: TButton;
    CboxStyle: TComboBox;
    LabelColorTitle: TLabel;
    BtnColorTitle: TButton;
    LabelColorComment: TLabel;
    BtnColorComment: TButton;
    procedure LBoxGenreDrawItem(Control: TWinControl; Index: Integer;
      Rect: TRect; State: TOwnerDrawState);
    procedure LBoxGenreClick(Sender: TObject);
    procedure CBoxColorDrawItem(Control: TWinControl; Index: Integer;
      Rect: TRect; State: TOwnerDrawState);
    procedure BtnColor1Click(Sender: TObject);
    procedure CBoxGenreChange(Sender: TObject);
    procedure EditGenreExit(Sender: TObject);
    procedure CBoxColorChange(Sender: TObject);
    procedure BtnAddClick(Sender: TObject);
    procedure BtnDelClick(Sender: TObject);
    procedure BtnColor2Click(Sender: TObject);
    procedure CboxStyleDrawItem(Control: TWinControl; Index: Integer;
      Rect: TRect; State: TOwnerDrawState);
    procedure CboxStyleChange(Sender: TObject);
    procedure BtnColorTitleClick(Sender: TObject);
    procedure BtnColorCommentClick(Sender: TObject);
  private
    { Private 錾 }
    FConfig: TDataConfig;
    FSelectGenre : TDataConfigTvGenreItem;

    procedure View();
    procedure ViewColor();
    procedure ViewItem();
    procedure ViewBlushStyle();
    function IndexOfColor(d : TDataConfigTvGenreItem) : Integer;
    function GenreDataToStr(d : TDataConfigTvGenreItem) : string;
  public
    { Public 錾 }
    procedure Show();
    property Config : TDataConfig read FConfig write FConfig;
  end;

implementation

{$R *.DFM}

{ TFrameConfigGenre }

procedure TFrameConfigGenre.Show;
var
  i : Integer;
  d : TDataConfigTvGenreItem;
  s : string;
begin
  PanelMenu.Visible := False;
  FSelectGenre := nil;
  LBoxGenre.Clear;
  for i := 0 to FConfig.Genre.Items.Count-1 do begin
    d := FConfig.Genre.Items[i];
    s := GenreDataToStr(d);
    LBoxGenre.Items.AddObject(s,d);
  end;
  CBoxGenre.Clear;
  for i := 0 to High(TDataTvScheduleGenreViewStr) do begin
    s := TDataTvScheduleGenreViewStr[i];
    CBoxGenre.Items.AddObject(s,TObject(i));
  end;
  ViewColor();
  ViewBlushStyle();

  if LBoxGenre.Items.Count > 0 then begin
    LBoxGenre.ItemIndex := 0;
    ViewItem();
  end;
end;

procedure TFrameConfigGenre.View;
var
  i,j : Integer;
  d : TDataConfigTvGenreItem;
  s : string;
begin
  j := LBoxGenre.ItemIndex;
  for i := 0 to LBoxGenre.Items.Count-1 do begin
    d := TDataConfigTvGenreItem(LBoxGenre.Items.Objects[i]);
    s := GenreDataToStr(d);
    LBoxGenre.Items.Strings[i] := s;
  end;
  LBoxGenre.ItemIndex := j;
end;

procedure TFrameConfigGenre.ViewColor;
var
  i : Integer;
  d : TDataConfigTvGenreItem;
begin
  CBoxColor.Clear;
  for i := 0 to FConfig.Genre.Items.Count-1 do begin
    d := FConfig.Genre.Items[i];
    if IndexOfColor(d) <> -1 then continue;
    CBoxColor.Items.AddObject('',d);
  end;

end;

procedure TFrameConfigGenre.ViewBlushStyle;
var
  i : Integer;
  d : TDataConfigTvGenreItem;
  bs : TBrushStyle;
begin
  CboxStyle.Clear;
  for i := 0 to 7 do begin
    CboxStyle.Items.AddObject('',TObject(i));
  end;
end;

procedure TFrameConfigGenre.LBoxGenreDrawItem(Control: TWinControl;
  Index: Integer; Rect: TRect; State: TOwnerDrawState);
var
  cv : TCanvas;
  d : TDataConfigTvGenreItem;
  dl : TListBox;
  s,s1,s2 : string;
begin
  dl := TListBox(Control);
  d := TDataConfigTvGenreItem(dl.Items.Objects[Index]);
  cv := dl.Canvas;
  cv.Pen.Color := clWhite;
  cv.Brush.Style := bsSolid;
  cv.Brush.Color := d.ColorBack;
  cv.FillRect(Rect);
  cv.Font.Color := d.ColorTitle;
  cv.Brush.Style := d.BrushStyle;
  cv.Brush.Color := d.ColorBack2;
  cv.Rectangle(Rect);
  s1 := d.Name;
  s2 := TvScheduleGenreToViewStr(d.Mode);
  s  := Format('%-30s %s',[s1,s2]);
  cv.TextOut(Rect.Left + 2, Rect.Top,s)
end;

procedure TFrameConfigGenre.LBoxGenreClick(Sender: TObject);
begin
  ViewItem();
end;

function TFrameConfigGenre.IndexOfColor(d : TDataConfigTvGenreItem): Integer;
var
  i : Integer;
  cl : TColor;
  d2 : TDataConfigTvGenreItem;
begin
  result := -1;
  for i := 0 to CBoxColor.Items.Count-1 do begin
    d2 := TDataConfigTvGenreItem(CBoxColor.Items.Objects[i]);
    if d.Compari(d2) then begin
      result := i;
      exit;
    end;
  end;
end;

procedure TFrameConfigGenre.CBoxColorDrawItem(Control: TWinControl;
  Index: Integer; Rect: TRect; State: TOwnerDrawState);
var
  cv : TCanvas;
  c : TColor;
  dc : TComboBox;
  d : TDataConfigTvGenreItem;
begin
  dc := TComboBox(Control);
  d := TDataConfigTvGenreItem(dc.Items.Objects[Index]);
  c := d.ColorBack;
  cv := dc.Canvas;
  cv.Pen.Color := clWhite;
  cv.Brush.Style := bsSolid;
  cv.Brush.Color := d.ColorBack;
  cv.FillRect(Rect);
  cv.Font.Color := clBlack;
  cv.Brush.Style := d.BrushStyle;
  cv.Brush.Color := d.ColorBack2;
  cv.Rectangle(Rect);
end;

procedure TFrameConfigGenre.CboxStyleDrawItem(Control: TWinControl;
  Index: Integer; Rect: TRect; State: TOwnerDrawState);
var
  cv : TCanvas;
  i : Integer;
  d : TDataConfigTvGenreItem;
  bs : TBrushStyle;
  dc : TComboBox;
begin
  dc := TComboBox(Control);
  cv := dc.Canvas;
  bs := TBrushStyle(dc.Items.Objects[Index]);

  cv.Brush.Style := bsSolid;
  cv.Brush.Color := clWhite;
  cv.FillRect(Rect);
  
  cv.Pen.Color := clWhite;
  cv.Brush.Color := clBlue;
  cv.Brush.Style := bs;
  cv.Rectangle(Rect);

end;

procedure TFrameConfigGenre.ViewItem;
var
  i : Integer;
  c : TColor;
  d : TDataConfigTvGenreItem;
begin
  i := LBoxGenre.ItemIndex;
  if i = -1 then exit;
  PanelMenu.Visible := True;
  FSelectGenre := TDataConfigTvGenreItem(LBoxGenre.Items.Objects[i]);
  EditGenre.Text := FSelectGenre.Name;
  PanelColor1.Color := FSelectGenre.ColorBack;
  PanelColor2.Color := FSelectGenre.ColorBack2;
  LabelColorTitle.Font.Color := FSelectGenre.ColorTitle;
  LabelColorComment.Font.Color := FSelectGenre.ColorComment;
  CBoxGenre.ItemIndex := Ord(FSelectGenre.Mode);
  for i := 0 to CBoxColor.Items.Count-1 do begin
    d := TDataConfigTvGenreItem(CBoxColor.Items.Objects[i]);
    if FSelectGenre.Compari(d) then begin
      CBoxColor.ItemIndex := i;
      break;
    end;
  end;
  CboxStyle.ItemIndex := Ord(FSelectGenre.BrushStyle);
end;

procedure TFrameConfigGenre.BtnColor1Click(Sender: TObject);
begin
  if FSelectGenre = nil then exit;
  DlgColor.Color := FSelectGenre.ColorBack;
  if not DlgColor.Execute then exit;
  FSelectGenre.ColorBack := DlgColor.Color;
  ViewColor();
  ViewItem();
  View();
end;

procedure TFrameConfigGenre.BtnColor2Click(Sender: TObject);
begin
  if FSelectGenre = nil then exit;
  DlgColor.Color := FSelectGenre.ColorBack2;
  if not DlgColor.Execute then exit;
  FSelectGenre.ColorBack2 := DlgColor.Color;
  ViewColor();
  ViewItem();
  View();
end;

procedure TFrameConfigGenre.BtnColorTitleClick(Sender: TObject);
begin
  if FSelectGenre = nil then exit;
  DlgColor.Color := FSelectGenre.ColorTitle;
  if not DlgColor.Execute then exit;
  FSelectGenre.ColorTitle := DlgColor.Color;
  ViewColor();
  ViewItem();
  View();
end;

procedure TFrameConfigGenre.BtnColorCommentClick(Sender: TObject);
begin
  if FSelectGenre = nil then exit;
  DlgColor.Color := FSelectGenre.ColorComment;
  if not DlgColor.Execute then exit;
  FSelectGenre.ColorComment := DlgColor.Color;
  ViewColor();
  ViewItem();
  View();
end;

procedure TFrameConfigGenre.CBoxGenreChange(Sender: TObject);
var
  i : Integer;
begin
  i := CBoxGenre.ItemIndex;
  if i = -1 then exit;
  if FSelectGenre = nil then exit;
  FSelectGenre.Mode := TDataTvScheduleGenre(i);
  View();
end;

function TFrameConfigGenre.GenreDataToStr(
  d: TDataConfigTvGenreItem): string;
var
  s,s1,s2 : string;
begin
  s1 := d.Name;
  s2 := TvScheduleGenreToViewStr(d.Mode);
  s  := Format('%-30s %s',[s1,s2]);
  result := s;
end;

procedure TFrameConfigGenre.EditGenreExit(Sender: TObject);
begin
  if FSelectGenre = nil then exit;
  FSelectGenre.Name := EditGenre.Text;
  View();
end;

procedure TFrameConfigGenre.CBoxColorChange(Sender: TObject);
var
  i : Integer;
  c : TColor;
  d : TDataConfigTvGenreItem;
begin
  i := CBoxColor.ItemIndex;
  if i = -1 then exit;
  if FSelectGenre = nil then exit;
  d := TDataConfigTvGenreItem(CBoxColor.Items.Objects[i]);
  //c := TColor(CBoxColor.Items.Objects[i]);
  FSelectGenre.AssignColor(d);
  ViewItem();
  View();
end;

procedure TFrameConfigGenre.CboxStyleChange(Sender: TObject);
var
  i : Integer;
  c : TColor;
  bs : TBrushStyle;
begin
  i := CboxStyle.ItemIndex;
  if i = -1 then exit;
  if FSelectGenre = nil then exit;
  bs := TBrushStyle(CboxStyle.Items.Objects[i]);
  //c := TColor(CBoxColor.Items.Objects[i]);
  FSelectGenre.BrushStyle := bs;
  View();
end;

procedure TFrameConfigGenre.BtnAddClick(Sender: TObject);
var
  d : TDataConfigTvGenreItem;
begin
  d := FConfig.Genre.Items.Add();
  d.ColorBack := clWhite;
  d.Name := 'o^';
  d.Mode := rgEtc;
  Show();
end;

procedure TFrameConfigGenre.BtnDelClick(Sender: TObject);
var
  i : Integer;
begin
  i := LBoxGenre.ItemIndex;
  if i = -1 then exit;
  FConfig.Genre.Items.Delete(i);
  Show();
end;

end.
