unit FormVersionUnit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls,ShellAPI;

type
  TFormVersion = class(TForm)
    BtnClose: TButton;
    ImageIcon: TImage;
    Label1: TLabel;
    LabelFileVersion: TLabel;
    Label2: TLabel;
    LabelUrl: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    LabelMail: TLabel;
    procedure FormShow(Sender: TObject);
    procedure LabelUrlClick(Sender: TObject);
  private
    { Private 錾 }
    procedure View();
    function GetVerInfo(FileName: string; KeyStr: string): string;

  public
    { Public 錾 }
    function Execute : Boolean;
  end;

implementation

{$R *.DFM}

{ TVersionForm }

function TFormVersion.Execute: Boolean;
begin
  ShowModal();
  result := True;
end;

//**************************************************************************//
//                                                                          //
//  ` o[W̎擾 `                                              //
//                                                                          //
// - input -    FileName  string  t@C                                //
//              KeyStr    string  擾o[W񕶎            //
//                                                                          //
//                        'CompanyName'       : Ж                      //
//                        'FileDescription'   :                         //
//                        'FileVersion'       : t@CEo[W        //
//                        'InternalName'      :                       //
//                        'LegalCopyright'    : 쌠                      //
//                        'LegalTrademarks'   : W                        //
//                        'OriginalFilename'  : t@C              //
//                        'ProductName'       : i                      //
//                        'ProductVersion'    : io[W              //
//                        'Comments'          : Rg                    //
//                                                                          //
// - output -   string    擾                                      //
//                                                                          //
//**************************************************************************//
function TFormVersion.GetVerInfo(FileName, KeyStr: string): string;
var
  InfoSize  : DWORD;
  Len       : DWORD;
  Buf       : PChar;
  Table     : Pointer;
  Value     : PChar;
  Str       : string;
begin
  Result := '';
  // o[W̃TCY擾
  InfoSize := GetFileVersionInfoSize(PChar(FileName), InfoSize);
  if InfoSize > 0 then begin
    Buf := AllocMem(InfoSize);
    try
      // o[W̎擾
      if GetFileVersionInfo(PChar(FileName), 0, InfoSize, Buf) then begin
        // ꎯʎqƕZbgʎq̎擾
        if VerQueryValue(Buf, PChar('\VarFileInfo\Translation'),
          Table, Len) then begin
          // o[W񕶎ƘA

          Str := Format('\StringFileInfo\%4.4x%4.4x\',
                 [LOWORD(DWORD(Table^)), HIWORD(DWORD(Table^))]) + KeyStr;

          // o[W񃊃\[XA
          // o[W񕶎Ŏꂽ擾
          if VerQueryValue(Buf, PChar(Str), Pointer(Value), Len) then begin
            Result := Value;
          end;
        end;
      end;
    finally
      FreeMem(Buf, InfoSize);
    end;
  end;
end;

procedure TFormVersion.View;
var
  s : string;
begin
  s := Application.ExeName;
  LabelFileVersion.Caption := GetVerInfo(s, 'FileVersion');
end;

procedure TFormVersion.FormShow(Sender: TObject);
begin
  View();
end;

procedure TFormVersion.LabelUrlClick(Sender: TObject);
begin
  ShellExecute(0, nil, PChar(TLabel(Sender).Caption),nil,nil, 0);
end;

end.
