unit FormRdRateUnit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  FrameRdRateX5Unit, StdCtrls, ExtCtrls,DataRdRecReserve,DataRdRecReserveInfo,
  DataTvSchedule,FrameRdRateXD91Unit,DataConfigRd,DataDefineRd;

type
  TFormRdRate = class(TForm)
    PanelMenu: TPanel;
    BtnOk: TButton;
    BtnCancel: TButton;
    PanelClient: TPanel;
    GBoxRdList: TGroupBox;
    ScrBox: TScrollBox;
    LBoxRdList: TListBox;
    BtnMail: TButton;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure LBoxRdListClick(Sender: TObject);
    procedure BtnMailClick(Sender: TObject);
  private
    { Private 錾 }
    FRd : TDataRdRecReserveItem;
    FFrameX5 : TFrameRdRateX5;
    FFrameXD91 : TFrameRdRateXD91;
    FRdInfo: TDataRdRecReserveInfo;
    FTv: TDataTvScheduleItem;
    FTvReced: Boolean;
    FRdIndex: Integer;
    FFrameList : TList;
    procedure ShowRdList();
    procedure ShowRdItem(Index : Integer);
    procedure ShowRdFrame(rd : TDataConfigRdItem);
  public
    { Public 錾 }
    property Rd : TDataRdRecReserveItem read FRd;
    property RdInfo : TDataRdRecReserveInfo read FRdInfo;
    property Tv : TDataTvScheduleItem read FTv;
    property TvReced : Boolean read FTvReced write FTvReced;
    property RdIndex : Integer read FRdIndex write FRdIndex;
  end;

implementation

uses DMUnit,FormMailRdUnit;

{$R *.DFM}

procedure TFormRdRate.FormCreate(Sender: TObject);
begin
  FFrameList := TList.Create;
  FRdInfo := TDataRdRecReserveInfo.Create;
  FRd := TDataRdRecReserveItem.Create;
  FTv := TDataTvScheduleItem.Create;

  //FRd.Info := FRdInfo;
  FFrameX5 := TFrameRdRateX5.Create(Self);
  FFrameX5.Parent := ScrBox;
  FFrameX5.Rd := FRd;
  FFrameX5.RdInfo := FRdInfo;

  FFrameXD91 := TFrameRdRateXD91.Create(Self);
  FFrameXD91.Parent := ScrBox;
  FFrameXD91.Rd := FRd;
  FFrameXD91.RdInfo := FRdInfo;

  FFrameList.Add(FFrameX5);
  FFrameList.Add(FFrameXD91);
end;

procedure TFormRdRate.FormDestroy(Sender: TObject);
begin
  FFrameXD91.Free;
  FFrameX5.Free;
  FTv.Free;
  FRdInfo.Free;
  FRd.Free;
  FFrameList.Free;
end;

procedure TFormRdRate.FormShow(Sender: TObject);
begin
  if FTvReced then begin
    ShowRdList();
  end
  else begin
    GBoxRdList.Visible := False;
    ShowRdFrame(DM.Config.Rd.Items[RdIndex]);
  end;
end;

procedure TFormRdRate.ShowRdItem(Index: Integer);
begin
  DM.TvToRd(FRd,FTv,Index);
  ShowRdFrame(DM.Config.Rd.Items[Index]);
end;

procedure TFormRdRate.ShowRdFrame(rd : TDataConfigRdItem);
var
  s : string;
  rddef : TDataDefineRdItem;
  i : Integer;
  df : TFrame;
begin
  for i := 0 to FFrameList.Count-1 do begin
    df := TFrame(FFrameList.Items[i]);
    df.Visible := False;
  end;

  s := rd.MatineName;
  rddef := DM.Define.Rd.Matines[s];
  if rddef.Name = 'RD-XD91' then begin
    FFrameXD91.RDDefine := rddef;
    FFrameXD91.Show();
    FFrameXD91.Visible := True;
  end
  else begin
    FFrameX5.RDDefine := rddef;
    FFrameX5.Show();
    FFrameX5.Visible := True;
  end;
end;

procedure TFormRdRate.ShowRdList;
var
  i : Integer;
  s : string;
begin
  LBoxRdList.Items.Clear;
  for i := 0 to DM.Rd.Items.Count-1 do begin
    s := DM.Rd.Items[i].GetRd.Config.Name;
    LBoxRdList.Items.Add(s);
    if i = FRdIndex then begin
      LBoxRdList.ItemIndex := i;
      ShowRdItem(i);
    end;
  end;
end;

procedure TFormRdRate.LBoxRdListClick(Sender: TObject);
var
  i : Integer;
begin
  i := LBoxRdList.ItemIndex;
  ShowRdItem(i);
end;

procedure TFormRdRate.BtnMailClick(Sender: TObject);
var
  dt : TDataTvScheduleItem;
  RDIndex : Integer;
  df : TFormRdRate;
  df2 : TFormMailRd;
begin
  df2 := TFormMailRd.Create(Self);                         // ^ݒʂ𐶐
  try
    df2.ConfigRd.Assign(DM.Config.Rd.Items[FRDIndex]);
    df2.RdInfo.Assign(DM.Rd.Items[FRDIndex].GetRd.RdInfo);  // qc擾\pɑ
    //df2.Tv.Assign(dt);                                     // ԑg
    //df2.RdIndex := RDIndex;
    
    df2.Msg := DM.Rd.Items[FRDIndex].GetRd.ConvertMsgToMail(FRd);
    df2.ShowModal;
  finally
    df2.Free;
  end;

end;

end.
