unit FormMainUnit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls,DataTvSchedule,
  DateTimeCtrl,DataTvSchedulePaperRect, Menus, ComCtrls,PanelRdList,
  DataRdRecReserve,FrameTvPaperUnit, FrameRdRecListUnit,FrameWebCMUnit,
  PanelTvProgramColumn,FrameMainUnit;

type
  TFormMain = class(TForm)
    MenuMain: TMainMenu;
    MenuFile: TMenuItem;
    N1: TMenuItem;
    MenuTvDelete: TMenuItem;
    MenuRd: TMenuItem;
    MenuFileClose: TMenuItem;
    MenuTvClear: TMenuItem;
    MenuRdConfigSave: TMenuItem;
    MenuRdRecSave: TMenuItem;
    MenuRdRecLoad: TMenuItem;
    MenuFileConfigTvCh: TMenuItem;
    N2: TMenuItem;
    N3: TMenuItem;
    PanelWebCM: TPanel;
    MenuFileDefine: TMenuItem;
    MenuHelp: TMenuItem;
    MenuHelpVersion: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure MenuFileCloseClick(Sender: TObject);
    procedure MenuFileDefineClick(Sender: TObject);
    procedure MenuFileConfigTvChClick(Sender: TObject);
    procedure MenuTvClearClick(Sender: TObject);
    procedure MenuTvDeleteClick(Sender: TObject);
    procedure MenuRdConfigSaveClick(Sender: TObject);
    procedure MenuRdRecSaveClick(Sender: TObject);
    procedure MenuRdRecLoadClick(Sender: TObject);
    procedure MenuHelpVersionClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Private 錾 }
    FFrameCM : TFrameWebCM;
    FFrameMain : TFrameMain;
  public
    { Public 錾 }
  end;

var
  FormMain: TFormMain;

implementation

uses DMUnit,StringListKey,DataRd,FormRdRateUnit,GetRdStanderd,
     FormConfigUnit,FormDefineUnit,FormVersionUnit;

{$R *.DFM}

procedure TFormMain.FormCreate(Sender: TObject);
begin
  DM := TDM.Create(Self);
  DM.DataLoad();
  DM.ProcStart();

  FFrameMain := TFrameMain.Create(Self);
  FFrameMain.Parent := Self;
  FFrameMain.Align := alClient;

  FFrameCM := TFrameWebCM.Create(Self);
  FFrameCM.Parent := PanelWebCM;
  FFrameCM.Align := alClient;
end;

procedure TFormMain.FormDestroy(Sender: TObject);
begin
  FFrameCM.Free;
  FFrameMain.Free;
  DM.Free;
end;

procedure TFormMain.FormShow(Sender: TObject);
begin
  Height := Screen.Height;
  Width := Screen.Width;
  FFrameMain.Show();
  FFrameCM.Show();
end;

procedure TFormMain.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Visible := False;
end;

procedure TFormMain.MenuFileCloseClick(Sender: TObject);
begin
  Close;
end;

procedure TFormMain.MenuFileDefineClick(Sender: TObject);
var
  df : TFormDefine;
begin
  df := TFormDefine.Create(Self);
  try
    df.Define.Assign(DM.Define);
    if df.ShowModal = mrOk then begin
      DM.Define.Assign(df.Define);
      DM.Define.DataSave();
    end;
  finally
    df.Free;
  end;
end;

procedure TFormMain.MenuFileConfigTvChClick(Sender: TObject);
var
  df : TFormConfig;
begin
  df := TFormConfig.Create(Self);
  try
    df.Config.Assign(DM.Config);
    if df.ShowModal = mrOk then begin
      Visible := False;
      //DM.GetTv.AssignConfig(DM.Config.TvChannel);   // suԑgǂݍޕǂw
      FFrameMain.Clear;
      DM.Config.Assign(df.Config);
      DM.RD.Config := DM.Config.Rd;
      DM.DataSave();                  // RDInfoۑȂH
      DM.Rd.DataInfoSave();           // ǂݍ񂾂qc̏ۑ
      FFrameMain.Update;
      FFrameMain.ColumnReLoad();   // ԑg\ɑS`l\
      FFrameMain.Show();
      //FFrameTvPaper.Show;
      //FFrameRdRecList.Show();
      Visible := True;
      //ShowFrame();
    end;
  finally
    df.Free;
  end;

  //
end;

procedure TFormMain.MenuTvClearClick(Sender: TObject);
begin
  DM.TvSchedule.Items.Clear;
end;

procedure TFormMain.MenuTvDeleteClick(Sender: TObject);
var
  dt : TDataTvScheduleItem;
begin
  dt := DM.CursorTv.Tv;
  if dt = nil then exit;
  DM.TvSchedule.Items.Delete(dt);
end;

procedure TFormMain.MenuRdConfigSaveClick(Sender: TObject);
var
  tt : TStringListKey;
  s : string;
begin
  DM.DataSave();
  tt := TStringListKey.Create;
  DM.Rd.DataConfigSave(tt);
  s := ExtractFilePath(Application.ExeName) + 'test.ini';
  tt.SaveToFile(s);
  tt.Free;
end;

procedure TFormMain.MenuRdRecSaveClick(Sender: TObject);
var
  tk : TStringListKey;
  s : string;
begin
  tk := TStringListKey.Create;
  try
    DM.Rd.DataRecSave(tk);
    s := ExtractFilePath(Application.ExeName) + 'rdrec.ini';
    tk.SaveToFile(s);

  finally
    tk.Free;
  end;
end;

procedure TFormMain.MenuRdRecLoadClick(Sender: TObject);
var
  tk : TStringListKey;
  s : string;
begin
  tk := TStringListKey.Create;
  try
    s := ExtractFilePath(Application.ExeName) + 'rdrec.ini';
    tk.LoadFromFile(s);
    DM.Rd.DataRecLoad(tk);

  finally
    tk.Free;
  end;
end;

procedure TFormMain.MenuHelpVersionClick(Sender: TObject);
var
  df : TFormVersion;
begin
  df := TFormVersion.Create(Self);
  try
    df.ShowModal();
  finally
    df.Free;
  end;
end;

end.
