unit FormMailRdUnit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  FrameRdRateX5Unit, StdCtrls, ExtCtrls,DataRdRecReserve,DataRdRecReserveInfo,
  DataTvSchedule,FrameRdRateXD91Unit,DataConfigRd,DataDefineRd,WinsockVSmtpClient,
  DateTimeCtrl,DataRdRecReserveRate,DataRdRecReserveAudio;

type
  TFormMailRd = class(TForm)
    EditAddress: TEdit;
    MemoMsg: TMemo;
    BtnSend: TButton;
    BtnCancel: TButton;
    Label1: TLabel;
    Label2: TLabel;
    EditTitle: TEdit;
    Label3: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure BtnSendClick(Sender: TObject);
    procedure BtnCancelClick(Sender: TObject);
  private
    { Private 錾 }
    FRdInfo: TDataRdRecReserveInfo;
    FRd: TDataRdRecReserveItem;
    FTv: TDataTvScheduleItem;
    FConfigRd: TDataConfigRdItem;
    FSmtp : TWinSockVSmtpClient;
    FRdIndex: Integer;

    function ConvertMsgToMail(str : string) : string;

    procedure OnFinish(Sender : TObject);
    procedure OnError(Sender : TObject;Code : TWinSockVSmtpClientProcMode);
    function GetMsg: string;
    procedure SetMsg(const Value: string);
  public
    { Public 錾 }
    property Rd : TDataRdRecReserveItem read FRd;
    property RdInfo : TDataRdRecReserveInfo read FRdInfo;
    property RdIndex : Integer read FRdIndex write FRdIndex;
    property Tv : TDataTvScheduleItem read FTv;
    property ConfigRd : TDataConfigRdItem read FConfigRd;
    property Msg : string read GetMsg write SetMsg;
  end;

var
  FormMailRd: TFormMailRd;

implementation

uses DMUnit;

{$R *.DFM}

procedure TFormMailRd.FormCreate(Sender: TObject);
begin
  FRdInfo := TDataRdRecReserveInfo.Create;
  FRd := TDataRdRecReserveItem.Create;
  FTv := TDataTvScheduleItem.Create;
  FConfigRd := TDataConfigRdItem.Create;
  FSmtp := TWinSockVSmtpClient.Create;
  FSmtp.OnFinish := OnFinish;

  FSmtp.Host := DM.Config.Mail.Host;
  FSmtp.Port := DM.Config.Mail.Port;
  FSmtp.Auth := DM.Config.Mail.Auth;
  FSmtp.User := DM.Config.Mail.User;
  FSmtp.Password := DM.Config.Mail.Password;
  FSmtp.From.Mail := DM.Config.Mail.FromMail;
  FSmtp.From.Name := DM.Config.Mail.FromName;
end;

procedure TFormMailRd.FormDestroy(Sender: TObject);
begin
  FSmtp.Free;
  FConfigRd.Free;
  FTv.Free;
  FRdInfo.Free;
  FRd.Free;
end;

procedure TFormMailRd.FormShow(Sender: TObject);
begin
  EditTitle.Text := 'RDւ̗\';
  EditAddress.Text := FConfigRd.MailAddress;
//  MemoMsg.Text := ConvertMsgToMail(FConfigRd.MailMessage);
end;

procedure TFormMailRd.BtnSendClick(Sender: TObject);
begin
  FSmtp.SendAdr.Clear;
  FSmtp.SendAdr.Add(EditAddress.Text,'RD',aimTo);
  FSmtp.Title := EditTitle.Text;
  FSmtp.Text := MemoMsg.Text;
  FSmtp.SendMail;
end;

procedure TFormMailRd.OnFinish(Sender: TObject);
begin
  MessageDlg('ɑM܂',mtInformation,[mbOk], 0);
end;

procedure TFormMailRd.OnError(Sender: TObject;
  Code: TWinSockVSmtpClientProcMode);
begin
  MessageDlg('MɃG[܂',mtWarning,[mbOk], 0);
end;

procedure TFormMailRd.BtnCancelClick(Sender: TObject);
begin
  Close;
end;

function TFormMailRd.ConvertMsgToMail(str: string): string;
  function MarkToData(var str: string;const mark,data : string) : string;
  var
    i : Integer;
    s1,s2 : string;
  begin
    i := pos(mark,str);
    if i = 0 then exit;
    s1 := Copy(str,1,i-1);
    s2 := Copy(str,i+length(mark),length(str));
    str := s1 + data + s2;
  end;
var
  dd : TDateTimeCtrl;
  s : string;
begin

  MarkToData(str,'%pass',DM.Rd.Config.Items[RDIndex].MailPassword);

  dd := rd.DateTime.Start;
  s := Format('%4.4d%2.2d%2.2d',[dd.Yer,dd.Mon,dd.Day]);
  MarkToData(str,'%date',s);
  s := Format('%2.2d%2.2d',[dd.Hou,dd.Min]);
  MarkToData(str,'%time1',s);

  dd := rd.DateTime.Stop;
  s := Format('%2.2d%2.2d',[dd.Hou,dd.Min]);
  MarkToData(str,'%time2',s);

  s := rd.Channel;
  MarkToData(str,'%ch',s);

  s := TDataRdRecReserveRateItemModeStrMail[Ord(rd.RecRate)];
  MarkToData(str,'%rate',s);

  s := TDataRdRecReserveAudioItemModeStrMail[Ord(rd.RecAudio)];
  MarkToData(str,'%audio',s);

  result := str;
end;

function TFormMailRd.GetMsg: string;
begin
  result := MemoMsg.Text;
end;

procedure TFormMailRd.SetMsg(const Value: string);
begin
  MemoMsg.Text := Value;
end;

end.
