unit FormConfigUnit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, StdCtrls, ExtCtrls,DataTvChannel, CheckLst,FrameConfigTvChUvUnit,
  FrameConfigTvChCs110Unit,FrameConfigTvChUnit,FrameConfigTvColumnUnit,DataConfig,
  FrameConfigRdUnit,PanelTvProgramColumnConfig, FrameConfigNormalUnit,
  FrameConfigMailUnit,FrameConfigGenreUnit;


type
  TFormConfig = class(TForm)
    PanelMenu: TPanel;
    BtnOk: TButton;
    BtnCancel: TButton;
    PCtrl: TPageControl;
    TabSheetTvCh: TTabSheet;
    TabSheetRd: TTabSheet;
    TabSheetNormal: TTabSheet;
    TabSheetMail: TTabSheet;
    TabSheetGenre: TTabSheet;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    { Private 錾 }
    FConfig: TDataConfig;
    FFrameCh : TFrameConfigTvCh;
    FFrameRd : TFrameConfigRd;
    FFrameNormal : TFrameConfigNormal;
    FFrameMail : TFrameConfigMail;
    FFrameGenre : TFrameConfigGenre;
  public
    { Public 錾 }
    property Config : TDataConfig read FConfig;
  end;

var
  FormConfig: TFormConfig;

implementation


{$R *.DFM}

procedure TFormConfig.FormCreate(Sender: TObject);
begin
  //
  FConfig := TDataConfig.Create;
  FFrameCh := TFrameConfigTvCh.Create(Self);
  FFrameCh.Parent := TabSheetTvCh;
  FFrameCh.Align := alClient;

  FFrameRd := TFrameConfigRd.Create(Self);
  FFrameRd.Parent := TabSheetRd;
  FFrameRd.Align := alClient;

  FFrameNormal := TFrameConfigNormal.Create(Self);
  FFrameNormal.Parent := TabSheetNormal;
  FFrameNormal.Align := alClient;

  FFrameMail := TFrameConfigMail.Create(Self);
  FFrameMail.Parent := TabSheetMail;
  FFrameMail.Align := alClient;

  FFrameGenre := TFrameConfigGenre.Create(Self);
  FFrameGenre.Parent := TabSheetGenre;
  FFrameGenre.Align := alClient;

end;

procedure TFormConfig.FormDestroy(Sender: TObject);
begin
  FFrameGenre.Free;
  FFrameMail.Free;
  FFrameNormal.Free;
  FFrameRd.Free;
  FFrameCh.Free;
  FConfig.Free;
end;

procedure TFormConfig.FormShow(Sender: TObject);
begin
  FFrameCh.Config := FConfig.TvChannel;
  FFrameCh.Show;
  FFrameRd.Config := FConfig;
  FFrameRd.Show();
  FFrameNormal.Config := FConfig;
  FFrameNormal.Show();
  FFrameMail.Config := FConfig;
  FFrameMail.Show();
  FFrameGenre.Config := FConfig;
  FFrameGenre.Show();
  PCtrl.ActivePage := TabSheetNormal;
end;


end.
