unit EventTvSchedule;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls,DateTimeCtrl,MultiEvent,DMUnit,
  StringListEx,StringListKey,DataTvChannel,DataTvSChedule,StringKanji;

type TEventTvScheduleEvent = procedure(Sender: TObject;ts : TDataTvScheduleItemsEx) of Object;

//--------------------------------------------------------------------------//
//  suԑgǉE폜̃CxgǗNX                            //
//--------------------------------------------------------------------------//
type
  TEventTvSchedule = class(TPersistent)
  private
    { Private 錾 }
    FTvSchedule : TDataTvSchedule;

    FOnAdds: TEventTvScheduleEvent;
    FOnDels: TEventTvScheduleEvent;
    FOnClr: TNotifyEvent;

    FOnDataAdds : TMultiEventReceive;
    FOnDataDels : TMultiEventReceive;
    FOnDataClr : TMultiEventReceive;

    procedure OnDataAdds(Sender, Arg: TObject);
    procedure OnDataDels(Sender, Arg: TObject);
    procedure OnDataClr(Sender, Arg: TObject);
    procedure SetTvSchedule(const Value: TDataTvSchedule);
  public
    { Public 錾 }
    constructor Create();
    destructor Destroy;override;

    // f[^ǉCxgif[^ǉɔj
    property OnAdds : TEventTvScheduleEvent read FOnAdds write FOnAdds;

    // f[^폜Cxgif[^폜Oɔj
    property OnDels : TEventTvScheduleEvent read FOnDels write FOnDels;

    // f[^Cxgif[^Oɔj
    property OnClr : TNotifyEvent read FOnClr write FOnClr;

    property TvSchedule : TDataTvSchedule read FTvSchedule write SetTvSchedule;
  end;

implementation

{ TEventTvSchedule }

constructor TEventTvSchedule.Create();
begin

end;

destructor TEventTvSchedule.Destroy;
begin
  if FTvSchedule <> nil then begin
    FTvSchedule.OnDataClr.Delete(FOnDataClr);
    FOnDataClr.Free;
    FTvSchedule.OnDataDels.Delete(FOnDataDels);
    FOnDataDels.Free;
    FTvSchedule.OnDataAdds.Delete(FOnDataAdds);
    FOnDataAdds.Free;
  end;
  inherited;
end;

procedure TEventTvSchedule.OnDataAdds(Sender, Arg: TObject);
var
  ts : TDataTvScheduleItemsEx;
begin
  ts := TDataTvScheduleItemsEx(Arg);
  if Assigned(FOnAdds) then begin
    FOnAdds(Self,ts);
  end;
end;

procedure TEventTvSchedule.OnDataDels(Sender, Arg: TObject);
var
  ts : TDataTvScheduleItemsEx;
begin
  ts := TDataTvScheduleItemsEx(Arg);
  if Assigned(FOnDels) then begin
    FOnDels(Self,ts);
  end;
end;

procedure TEventTvSchedule.OnDataClr(Sender, Arg: TObject);
begin
  if Assigned(FOnClr) then begin
    FOnClr(Self);
  end;
end;

procedure TEventTvSchedule.SetTvSchedule(const Value: TDataTvSchedule);
begin
  FTvSchedule := Value;
  // suԑgf[^ɒǉƂ̃Cxg󂯎
  FOnDataAdds := TMultiEventReceive.Create(nil);
  FOnDataAdds.OnUpdate := OnDataAdds;
  FTvSchedule.OnDataAdds.Add(FOnDataAdds);

  // suԑgf[^ɍ폜Ƃ̃Cxg󂯎
  FOnDataDels := TMultiEventReceive.Create(nil);
  FOnDataDels.OnUpdate := OnDataDels;
  FTvSchedule.OnDataDels.Add(FOnDataDels);

  // suԑgf[^ɏƂ̃Cxg󂯎
  FOnDataClr := TMultiEventReceive.Create(nil);
  FOnDataClr.OnUpdate := OnDataClr;
  FTvSchedule.OnDataClr.Add(FOnDataClr);
end;

end.
