unit EventRdRec;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls,DateTimeCtrl,MultiEvent,DMUnit,
  StringListEx,StringListKey,DataRd,DataRdRecReserve;

type TEventRdRecEvent = procedure(Sender: TObject;ts : TDataRdRecReserveItemsEx) of Object;

//--------------------------------------------------------------------------//
//  qc̘^\ǉE폜̃CxgǗNX                      //
//--------------------------------------------------------------------------//
type
  TEventRdRec = class(TPersistent)
  private
    { Private 錾 }

    FOnAdds: TEventRdRecEvent;
    FOnDels: TEventRdRecEvent;
    FOnClr: TNotifyEvent;

    FOnRecAdds : TMultiEventReceive;
    FOnRecDels : TMultiEventReceive;
    FOnRecClr : TMultiEventReceive;
    FRd: TDataRd;

    procedure OnRecAdds(Sender, Arg: TObject);
    procedure OnRecDels(Sender, Arg: TObject);
    procedure OnRecClr(Sender, Arg: TObject);
    procedure SetRd(const Value: TDataRd);
  public
    { Public 錾 }
    constructor Create();
    destructor Destroy;override;

    // f[^ǉCxgif[^ǉɔj
    property OnAdds : TEventRdRecEvent read FOnAdds write FOnAdds;

    // f[^폜Cxgif[^폜Oɔj
    property OnDels : TEventRdRecEvent read FOnDels write FOnDels;

    // f[^Cxgif[^Oɔj
    property OnClr : TNotifyEvent read FOnClr write FOnClr;

    property Rd : TDataRd read FRd write SetRd;
  end;

implementation

{ TEventRdRec }

constructor TEventRdRec.Create;
begin

end;

destructor TEventRdRec.Destroy;
begin
  if FRd <> nil then begin
    FRd.OnRecClr.Delete(FOnRecClr);
    FOnRecClr.Free;
    FRd.OnRecDels.Delete(FOnRecDels);
    FOnRecDels.Free;
    FRd.OnRecAdds.Delete(FOnRecAdds);
    FOnRecAdds.Free;
  end;
  inherited;

end;

procedure TEventRdRec.OnRecAdds(Sender, Arg: TObject);
var
  ts : TDataRdRecReserveItemsEx;
begin
  ts := TDataRdRecReserveItemsEx(Arg);
  if Assigned(FOnAdds) then begin
    FOnAdds(Self,ts);
  end;
end;

procedure TEventRdRec.OnRecDels(Sender, Arg: TObject);
var
  ts : TDataRdRecReserveItemsEx;
begin
  ts := TDataRdRecReserveItemsEx(Arg);
  if Assigned(FOnDels) then begin
    FOnDels(Self,ts);
  end;
end;

procedure TEventRdRec.OnRecClr(Sender, Arg: TObject);
begin
  DM.CursorRd.Rd := nil;
  if Assigned(FOnClr) then begin
    FOnClr(Self);
  end;
end;

procedure TEventRdRec.SetRd(const Value: TDataRd);
begin
  FRd := Value;
  // qc^\ɒǉƂ̃Cxg󂯎
  FOnRecAdds := TMultiEventReceive.Create(nil);
  FOnRecAdds.OnUpdate := OnRecAdds;
  FRd.OnRecAdds.Add(FOnRecAdds);

  // qc^\ɍ폜Ƃ̃Cxg󂯎
  FOnRecDels := TMultiEventReceive.Create(nil);
  FOnRecDels.OnUpdate := OnRecDels;
  FRd.OnRecDels.Add(FOnRecDels);

  // qc^\ɏƂ̃Cxg󂯎
  FOnRecClr := TMultiEventReceive.Create(nil);
  FOnRecClr.OnUpdate := OnRecClr;
  FRd.OnRecClr.Add(FOnRecClr);
end;

end.
