unit EventCursorTv;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls,DateTimeCtrl,MultiEvent,
  StringListEx,StringListKey,DataTvChannel,DataTvSChedule,DataCursorTv;

//--------------------------------------------------------------------------//
//  suԑgĨCxgǗNX                                  //
//--------------------------------------------------------------------------//
type
  TEventCursorTv = class(TPersistent)
  private
    { Private 錾 }
    FOnChange: TNotifyEvent;
    FOnChangeTv : TMultiEventReceive;
    FCursor: TDataCursorTv;

    procedure OnTvChange(Sender, Arg: TObject);
    procedure SetCursor(const Value: TDataCursorTv);
  public
    { Public 錾 }
    constructor Create();
    destructor Destroy;override;

    property Cursor : TDataCursorTv read FCursor write SetCursor;
    // J[\wԑgf[^ύXCxgiύXɔj
    property OnChange : TNotifyEvent read FOnChange write FOnChange;

  end;
implementation

uses DMUnit;

{ TEventCursorTv }

constructor TEventCursorTv.Create;
begin
  // J[\ɕύXƂ̃Cxg󂯎
  FOnChangeTv := TMultiEventReceive.Create(nil);
  FOnChangeTv.OnUpdate := OnTvChange;
end;

destructor TEventCursorTv.Destroy;
begin
  if FCursor <> nil then begin
    FCursor.OnChange.Delete(FOnChangeTv);
  end;
  FOnChangeTv.Free;
  inherited;

end;

procedure TEventCursorTv.OnTvChange(Sender, Arg: TObject);
begin
  if Assigned(FOnChange) then begin
    FOnChange(Self);
  end;
end;


procedure TEventCursorTv.SetCursor(const Value: TDataCursorTv);
begin
  FCursor := Value;
  FCursor.OnChange.Add(FOnChangeTv);
end;

end.
