unit EventCursorRd;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls,DateTimeCtrl,MultiEvent,
  StringListEx,StringListKey,DataTvChannel,DataTvSChedule,DataCursorRd;

//--------------------------------------------------------------------------//
//  ^\ĨCxgǗNX                                  //
//--------------------------------------------------------------------------//
type
  TEventCursorRd = class(TPersistent)
  private
    { Private 錾 }
    FOnChange: TNotifyEvent;
    FOnChangeRd : TMultiEventReceive;
    FCursor: TDataCursorRd;

    procedure OnRdChange(Sender, Arg: TObject);
    procedure SetCursor(const Value: TDataCursorRd);
  public
    { Public 錾 }
    constructor Create();
    destructor Destroy;override;

    property Cursor : TDataCursorRd read FCursor write SetCursor;
    // J[\w^\f[^ύXCxgiύXɔj
    property OnChange : TNotifyEvent read FOnChange write FOnChange;

  end;

implementation

{ TEventCursorRd }

constructor TEventCursorRd.Create;
begin
  // J[\ɕύXƂ̃Cxg󂯎
  FOnChangeRd := TMultiEventReceive.Create(nil);
  FOnChangeRd.OnUpdate := OnRdChange;
end;

destructor TEventCursorRd.Destroy;
begin
  if FCursor <> nil then begin
    FCursor.OnChange.Delete(FOnChangeRd);
  end;
  FOnChangeRd.Free;
  inherited;
end;

procedure TEventCursorRd.OnRdChange(Sender, Arg: TObject);
begin
  if Assigned(FOnChange) then begin
    FOnChange(Self);
  end;
end;

procedure TEventCursorRd.SetCursor(const Value: TDataCursorRd);
begin
  FCursor := Value;
  FCursor.OnChange.Add(FOnChangeRd);
end;

end.
