unit DrawRdRecReserve;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls,PanelTvProgramColumnData,DataRdRecReserve,
  DataTvSchedule,EventTvSchedule,DataRdRecReserveEncode,DataConfigRdConfig,
  DataConfigRdConfigEncode;

procedure DrawRdRecReserveDraw(cv:TCanvas;d : TDataRdRecReserveItem;
                               dc : TDataConfigRdConfig;r : TRect;Selected : Boolean);

implementation

procedure DrawRdRecReserveDraw(cv:TCanvas;d : TDataRdRecReserveItem;
                               dc : TDataConfigRdConfig;r : TRect;Selected : Boolean);
var
  x1,x2,x3,y1,y2,y3,y4,yy,aEnc,i : Integer;
  s,m : string;
  ec : TDataConfigRdConfigEncodeItem;
begin
  x2 := (r.Right - r.Left) div 2 + r.Left;
  yy := (r.Bottom - r.Top) div 2 + r.Top;
  x1 := x2 - 8;
  x3 := x2 + 7;
  y1 := r.Top;
  y4 := r.Bottom;
  y2 := y1 + 8;
  y3 := y4 - 7;

  ec := dc.Encode.Modes[d.Encoder];

  cv.Pen.Color := ec.ColorEdge;
  cv.Pen.Width := 1;
  if r.Bottom - r.Top < 16 then begin
    cv.Brush.Style := bsSolid;
    cv.Brush.Color := clRed;
    cv.Rectangle(Rect(x1,y1,x3,y4));
  end
  else begin
    cv.Brush.Style := bsSolid;
    if Selected then begin          // IꂽԂ̎
      cv.Brush.Color := clBlue;
    end
    else begin
      if d.Execution then begin     // łȂꍇ
        cv.Brush.Color := ec.ColorBack; // ݒwiF擾
      end
      else begin
        cv.Brush.Color := clDkGray;
      end;
    end;
    cv.Polygon([Point(x2,y1), Point(x3,y2),Point(x3,y3),Point(x2,y4),
                Point(x1,y3), Point(x1,y2),Point(x2,y1)]);

  end;
  aEnc := Ord(d.Encoder);
  s := TDataRdRecReserveEncodeItemModeStr[aEnc];   // GR[_擾
  cv.Font.Color := ec.ColorFont;
  cv.Font.Style := [];
  cv.Font.Height := -12;
  cv.Brush.Style := bsClear;
  for i := 0 to Length(s)-1 do begin               // cpɂP
    m := Copy(s,i+1,1);
    cv.TextRect(r,x2-3,yy - 16+i*12,m);
  end;
end;

end.
