//**************************************************************************//
//                                                                          //
//  vOŎgpt^NX                                        //
//                                                                          //
//**************************************************************************//
unit DateTimeCtrl;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,StringListEx;

//--------------------------------------------------------------------------//
//  TVԑgŎgptǗNX                                          //
//--------------------------------------------------------------------------//
type
  TDateTimeCtrl = class(TPersistent)
  private
    { Private 錾 }
    FYer: Integer;                          // N
    FMon: Integer;                          // 
    FDay: Integer;                          // 
    FHou: Integer;                          // 
    FMin: Integer;                          // 
    FSec: Integer;                          // b
    function GetDateTime: TDateTime;
    procedure SetDateTime(const Value: TDateTime);
    function GetTime: TDateTime;
    function GetDate: TDateTime;
    procedure SetDate(const Value: TDateTime);
    function GetWeekShortStr: string;
    function GetMonShortStr: string;
  public
    { Public 錾 }
    procedure Assign(Source : TPersistent) ; override;
    procedure IncDay(Value : Integer = 1);
    procedure DecDay(Value : Integer = 1);
    procedure IncHou(Value : Integer = 1);
    procedure DecHou(Value : Integer = 1);
    procedure IncMin(Value : Integer = 1);
    procedure DecMin(Value : Integer = 1);
    procedure IncSec(Value : Integer = 1);
    procedure DecSec(Value : Integer = 1);
    procedure SetData(aYer,aMon,aDay,aHou,aMin : Integer);
    function DataToDateTime() : TDateTime;
    function DataToTime() : TDateTime;
    function GetWeek() : Integer;
    function TimeAbs(d : TDateTimeCtrl;aMin : Integer) : Boolean;
    function Compari(d : TDateTimeCtrl) : Integer;
    function GetDayMax() : Integer;
    function DataLoad(const Name : string;t : TStringListEx) : Boolean;
    function DataSave(const Name : string;t : TStringListEx) : Boolean;

    property Yer : Integer read FYer write FYer;
    property Mon : Integer read FMon write FMon;
    property MonShortStr : string read GetMonShortStr;
    property Day : Integer read FDay write FDay;
    property Hou : Integer read FHou write FHou;
    property Min : Integer read FMin write FMin;
    property Sec : Integer read FSec write FSec;
    property Week : Integer read GetWeek;
    property WeekShortStr : string read GetWeekShortStr;
    property DateTime : TDateTime read GetDateTime write SetDateTime;
    property Date : TDateTime read GetDate write SetDate;
    property Time : TDateTime read GetTime;
  end;

implementation

{ TDateTimeCtrl }

//**************************************************************************//
//                                                                          //
//  `@NX@`                                                      //
//                                                                          //
//   - Input -  Source : Rs[                                           //
//                                                                          //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
procedure TDateTimeCtrl.Assign(Source: TPersistent);
var
  a : TDateTimeCtrl;
begin
  if Source is TDateTimeCtrl then begin
    a := TDateTimeCtrl(Source);
    FYer := a.FYer;
    FMon := a.FMon;
    FDay := a.FDay;
    FHou := a.FHou;
    FMin := a.FMin;
    FSec := a.FSec;
  end
  else begin
    inherited;
  end;
end;

//**************************************************************************//
//                                                                          //
//  `@nꂽƔr@`                                          //
//                                                                          //
//   - Input -  d : r                                            //
//                                                                          //
//   - Output -  1 : g > rf[^                                      //
//               0 : g = rf[^                                      //
//              -1 : g < rf[^                                      //
//                                                                          //
//**************************************************************************//
function TDateTimeCtrl.Compari(d: TDateTimeCtrl): Integer;
begin
  result := 0;
  if FYer > d.FYer then begin
    result := 1;
    exit;
  end;
  if FYer < d.FYer then begin
    result := -1;
    exit;
  end;
  if FMon > d.FMon then begin
    result := 1;
    exit;
  end;
  if FMon < d.FMon then begin
    result := -1;
    exit;
  end;
  if FDay > d.FDay then begin
    result := 1;
    exit;
  end;
  if FDay < d.FDay then begin
    result := -1;
    exit;
  end;
  if FHou > d.FHou then begin
    result := 1;
    exit;
  end;
  if FHou < d.FHou then begin
    result := -1;
    exit;
  end;
  if FMin > d.FMin then begin
    result := 1;
    exit;
  end;
  if FMin < d.FMin then begin
    result := -1;
    exit;
  end;
  if FSec > d.FSec then begin
    result := 1;
    exit;
  end;
  if FSec < d.FSec then begin
    result := -1;
    exit;
  end;
end;

//**************************************************************************//
//                                                                          //
//  `@t^TDateTimeɕϊl擾@`                               //
//                                                                          //
//   - Input -  Ȃ                                                        //
//                                                                          //
//   - Output -                                                         //
//                                                                          //
//**************************************************************************//
function TDateTimeCtrl.DataLoad(const Name: string;
  t: TStringListEx): Boolean;
var
  t2 : TStringListEx;
  s : string;
begin
  t2 := TStringListEx.Create;
  try
    result := False;
    s := t.GetStrs(Name,'');
    t2.CommaTextEx := s;
    Yer := t2.GetInts('Yer',Yer);
    Mon := t2.GetInts('Mon',Mon);
    Day := t2.GetInts('Day',Day);
    Hou := t2.GetInts('Hou',Hou);
    Min := t2.GetInts('Min',Min);
    result := True;
  finally
    t2.Free;
  end;
end;

function TDateTimeCtrl.DataSave(const Name: string;
  t: TStringListEx): Boolean;
var
  t2 : TStringListEx;
begin
  t2 := TStringListEx.Create;
  try
    result := False;
    t2.SetInts('Yer',Yer);
    t2.SetInts('Mon',Mon);
    t2.SetInts('Day',Day);
    t2.SetInts('Hou',Hou);
    t2.SetInts('Min',Min);
    t.SetStrs(Name,t2.CommaTextEx);
    result := True;
  finally
    t2.Free;
  end;
end;

function TDateTimeCtrl.DataToDateTime: TDateTime;
var
  aYer,aMon,aDay,aHou,aMin,aSec,aMSec : Word;
begin
  aYer := FYer;
  aMon := FMon;
  aDay := FDay;
  aHou := FHou;
  aMin := FMin;
  aSec := 0;
  aMSec := 0;
  result := EncodeDate(aYer,aMon,aDay) + EncodeTime(aHou,aMin,aSec,aMSec);
end;

//**************************************************************************//
//                                                                          //
//  `@t^TDateTimeɕϊl擾@`                               //
//                                                                          //
//   - Input -  Ȃ                                                        //
//                                                                          //
//   - Output -                                                         //
//                                                                          //
//**************************************************************************//
function TDateTimeCtrl.DataToTime: TDateTime;
begin
  result := EncodeTime(FHou,FMin,0,0);
end;

//**************************************************************************//
//                                                                          //
//  `@O̓ց@`                                                        //
//                                                                          //
//   - Input -  Value : ړ                                            //
//                                                                          //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
procedure TDateTimeCtrl.DecDay(Value : Integer = 1);
const
  DayTbl : array[0..11] of Integer = (31,0,31,30,31,30,31,31,30,31,30,31);
begin
  while Value > 0 do begin
    Dec(FDay);
    if FDay < 1 then begin
      Dec(FMon);
      if FMon < 1 then begin
        FMon := 12;
        Dec(FYer);
      end;
      FDay := DayTbl[FMon-1];
      if FDay = 0 then FDay := 28 + Integer(IsLeapYear(FYer));
    end;
    Dec(Value);
  end;
end;

//**************************************************************************//
//                                                                          //
//  `@O̎Ԃց@`                                                      //
//                                                                          //
//   - Input -  Value : ړԐiPHouj                               //
//                                                                          //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
procedure TDateTimeCtrl.DecHou(Value: Integer);
begin
  while Value > 0 do begin
    if Hou = 0 then begin
      Hou := 23;
      DecDay();
    end
    else begin
      Dec(FHou);
    end;
    Dec(Value);
  end;
end;

//**************************************************************************//
//                                                                          //
//  `@O̎Ԃց@`                                                      //
//                                                                          //
//   - Input -  Value : ړԐiPMinj                               //
//                                                                          //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
procedure TDateTimeCtrl.DecMin(Value: Integer);
begin
  while Value > 0 do begin
    if Min = 0 then begin
      Min := 59;
      DecHou();
    end
    else begin
      Dec(FMin);
    end;
    Dec(Value);
  end;
end;

procedure TDateTimeCtrl.DecSec(Value: Integer);
begin
  while Value > 0 do begin
    if Sec = 0 then begin
      Sec := 59;
      DecMin();
    end
    else begin
      Dec(FSec);
    end;
    Dec(Value);
  end;
end;

function TDateTimeCtrl.GetDate: TDateTime;
begin
  result := EncodeDate(Yer,Mon,Day);
end;

function TDateTimeCtrl.GetDateTime: TDateTime;
begin
  result := EncodeDate(Yer,Mon,Day) + EncodeTime(Hou,Min,Sec,0);
end;

//**************************************************************************//
//                                                                          //
//  `@݂̔Nɑ΂ő擾@`                                //
//                                                                          //
//   - Input -  Ȃ                                                        //
//                                                                          //
//   - Output - ő                                                    //
//                                                                          //
//**************************************************************************//
function TDateTimeCtrl.GetDayMax: Integer;
const
  DayTbl : array[0..11] of Integer = (31,0,31,30,31,30,31,31,30,31,30,31);
var
  d : Integer;
begin
  d := DayTbl[FMon-1];
  if d = 0 then d := 28 + Integer(IsLeapYear(FYer));
  result := d;
end;

function TDateTimeCtrl.GetMonShortStr: string;
const
  Tbl : array[1..12] of string= ('Jan','Feb','Mar','Apr',
                                 'May','Jun','Jul','Aug',
                                 'Sep','Oct','Nov','Dec');
begin
  result := Tbl[FMon];
end;

function TDateTimeCtrl.GetTime: TDateTime;
begin
  result := EncodeTime(Hou,Min,Sec,0);
end;

function TDateTimeCtrl.GetWeek: Integer;
begin
  result := DayOfWeek(DataToDateTime);
end;

function TDateTimeCtrl.GetWeekShortStr: string;
const
  Tbl : array[1..12] of string= ('Jan','Feb','Mar','Apr',
                                 'May','Jun','Jul','Aug',
                                 'Sep','Oct','Nov','Dec');
begin
  result := Tbl[FMon];
end;

//**************************************************************************//
//                                                                          //
//  `@̓ց@`                                                        //
//                                                                          //
//   - Input -  Value : ړ                                            //
//                                                                          //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
procedure TDateTimeCtrl.IncDay(Value : Integer = 1);
const
  DayTbl : array[0..11] of Integer = (31,0,31,30,31,30,31,31,30,31,30,31);
var
  d : Integer;
begin
  while Value > 0 do begin
    Inc(FDay);
    d := DayTbl[FMon-1];
    if d = 0 then d := 28 + Integer(IsLeapYear(FYer));
    if FDay > d then begin
      FDay := 1;
      Inc(FMon);
      if FMon > 12 then begin
        FMon := 1;
        Inc(FYer);
      end;
    end;
    Dec(Value);
  end;
end;

procedure TDateTimeCtrl.IncHou(Value: Integer);
begin
  while Value > 0 do begin
    if Hou = 23 then begin
      Hou := 0;
      IncDay();
    end
    else begin
      Inc(FHou);
    end;
    Dec(Value);
  end;

end;

procedure TDateTimeCtrl.IncMin(Value: Integer);
begin
  while Value > 0 do begin
    if Min = 59 then begin
      Min := 0;
      IncHou();
    end
    else begin
      Inc(FMin);
    end;
    Dec(Value);
  end;
end;

procedure TDateTimeCtrl.IncSec(Value: Integer);
begin
  while Value > 0 do begin
    if FSec = 59 then begin
      FSec := 0;
      IncMin();
    end
    else begin
      Inc(FSec);
    end;
    Dec(Value);
  end;
end;

procedure TDateTimeCtrl.SetData(aYer, aMon, aDay, aHou, aMin: Integer);
begin
  FYer := aYer;
  FMon := aMon;
  FDay := aDay;
  FHou := aHou;
  FMin := aMin;
end;

procedure TDateTimeCtrl.SetDate(const Value: TDateTime);
var
  aYer,aMon,aDay : Word;
begin
  DecodeDate(Value,aYer,aMon,aDay);
  FYer := aYer;
  FMon := aMon;
  FDay := aDay;
end;

procedure TDateTimeCtrl.SetDateTime(const Value: TDateTime);
var
  aYer,aMon,aDay,aHou,aMin,aSec,aMSec : Word;
begin
  DecodeDate(Value,aYer,aMon,aDay);
  DecodeTime(Value,aHou,aMin,aSec,aMSec);
  FYer := aYer;
  FMon := aMon;
  FDay := aDay;
  FHou := aHou;
  FMin := aMin;
  FSec := aSec;

end;

//**************************************************************************//
//                                                                          //
//  `@nꂽ͈͓Ɏ܂邩@`                              //
//                                                                          //
//   - Input -  d : r                                            //
//              aMin : e                                             //
//                                                                          //
//   - Output - True : ͈͓Ɏ܂                                       //
//                                                                          //
//**************************************************************************//
function TDateTimeCtrl.TimeAbs(d: TDateTimeCtrl; aMin: Integer): Boolean;
var
  dd : TDateTimeCtrl;
begin
  dd := TDateTimeCtrl.Create;
  try
    result := True;
    dd.Assign(d);
    dd.DecMin(aMin);
    if Compari(dd) < 0 then begin
      result := False;
      exit;
    end;
    dd.Assign(d);
    dd.IncMin(aMin);
    if Compari(dd) > 0 then begin
      result := False;
      exit;
    end;
  finally
    dd.Free;
  end;


end;

end.
