//**********************************************************************//
//                                                                      //
//  suԑg̑f[^NX                                    //
//                                                                      //
//**********************************************************************//
unit DataTvStatus;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,StringListEx,ExtCtrls,DefaultData,
  DateTimeCtrl;

const
  TTvScheduleStatusTbl : array[0..12] of string
                        = ('Extended','TalkFirst','TalkLast','TalkRe','TalkStereo',
                           'TalkBilingual','TalkTajyu','TalkMoji','TalkHiVision',
                           'TalkNews','TalkFukikae','TalkWeather','TalkNoMoney');

  TTvScheduleStatusTextTbl : array[0..12] of string
                        = ('','V','ŏI','ĕ','XeI',
                           'J','d','','nCrW',
                           'j[X','ւ','VC\','');
  TTvScheduleStatusMarkTbl : array[0..12] of string
                        = ('','V','I','','r','p','','','Hv','m','','V','');

  TTvScheduleStatusColorTbl : array[0..12] of TColor
                        = (clBlack,clRed,clBlue,clAqua,clPurple,clPurple,clGreen,
                                clGreen,clDkGray,clAqua,clBlue,clGreen,clMaroon);

  TTvScheduleStatusHtmlTbl : array[0..12] of string
                        = ('','new.gif','end.gif','/re.gif','stereo.gif','/2e.gif',
                           'tajyu.gif','/moji.gif','/hv.gif','/n.gif','fukikae.gif','/w.gif','');


type
  TTvScheduleStatusMode = (tsmExtended,tsmTalkFirst,tsmTalkLast,tsmTalkRe,tsmTalkStereo,
                           tsmTalkBilingual,tsmTalkTajyu,tsmTalkMoji,tsmTalkHiVision,
                           tsmTalkNews,tsmTalkFukikae,tsmTalkWeather,tsmTalkNoMoney);

//--------------------------------------------------------------------------//
//  TVԑgf[^NX                                                  //
//--------------------------------------------------------------------------//
type
  TTvScheduleStatuseItem = class(TPersistent)
  private
    { Private 錾 }
    FValue: Boolean;
    FName: string;
  public
    { Public 錾 }
    property Name : string read FName;
    property Value : Boolean read FValue write FValue;
    procedure Assign(Source : TPersistent) ; override;
  end;

//--------------------------------------------------------------------------//
//  TVԑgf[^NX                                                  //
//--------------------------------------------------------------------------//
type
  TTvScheduleStatus = class(TList)
  private
    { Private 錾 }

    function GetItems(Index: Integer): TTvScheduleStatuseItem;
    function GetStatus(Mode: TTvScheduleStatusMode): TTvScheduleStatuseItem;
  public
    { Public 錾 }
    constructor Create;
    destructor Destroy;override;

    function Add() : TTvScheduleStatuseItem;
    procedure Delete(i : Integer);
    procedure Clear();override;
    property Items[Index: Integer] : TTvScheduleStatuseItem read GetItems;
    property Status[Mode : TTvScheduleStatusMode] : TTvScheduleStatuseItem read GetStatus;default;

    procedure Assign(a : TTvScheduleStatus) ;
    procedure AssignEx(a : TTvScheduleStatus;aMode : TTvChannelStatusMode);
    function Compari(d : TTvScheduleStatus) : Boolean;
    function CheckEqual(a : TTvScheduleStatus) : Boolean;

    function DataLoad(t : TStringListEx) : Boolean;
    function DataSave(t : TStringListEx) : Boolean;

    procedure OutMark(c : TCanvas;r : TRect;X: Integer; const Y: Integer;
                      aState : TOwnerDrawState);

    procedure StringToScheduleStatus(const str : string);
  end;

implementation

{ TTvScheduleStatusItem }

constructor TTvScheduleStatus.Create;
var
  i : Integer;
  d : TTvScheduleStatuseItem;
begin
  for i := 0 to High(TTvScheduleStatusTbl) do begin
    d := Add();
    d.FName := TTvScheduleStatusTbl[i];
  end;

end;

destructor TTvScheduleStatus.Destroy;
begin
  Clear();
  inherited;
end;

procedure TTvScheduleStatus.Assign(a: TTvScheduleStatus);
var
  i : Integer;
  d : TTvScheduleStatuseItem;
begin
  //Clear();
  for i := 0 to a.Count-1 do begin
    d := Items[i];
    //d := Add();
    d.Assign(a.Items[i]);
  end;

end;

procedure TTvScheduleStatus.AssignEx(a: TTvScheduleStatus;
  aMode: TTvChannelStatusMode);
var
  i : Integer;
  d : TTvScheduleStatuseItem;
begin
  //Clear();
  for i := 0 to a.Count-1 do begin
    if i >= Count then break;
    d := Items[i];
    d.Value := d.Value or a.Items[i].Value;
  end;

end;

function TTvScheduleStatus.Compari(d: TTvScheduleStatus): Boolean;
var
  i : Integer;
begin
  result := False;
  for i := 0 to Count-1 do begin
    if d.Items[i].Value then begin
      if Items[i].Value then begin
        result := True;
        break;
      end;
    end;
  end;

end;

function TTvScheduleStatus.DataLoad(t: TStringListEx): Boolean;
var
  i : Integer;
  s : string;
begin
  for i := 0 to Count-1 do begin
    s := TTvScheduleStatusTbl[i];
    Items[i].Value := t.GetBools(s,Items[i].Value);
  end;
  result := True;
end;

function TTvScheduleStatus.DataSave(t: TStringListEx): Boolean;
var
  i : Integer;
  s : string;
begin
  for i := 0 to Count-1 do begin
    s := TTvScheduleStatusTbl[i];
    t.SetBools(s,Items[i].Value);
  end;
  result := True;
end;

procedure TTvScheduleStatus.OutMark(c: TCanvas; r: TRect; X: Integer;
  const Y: Integer; aState: TOwnerDrawState);
var
  i,xx,xh : Integer;
  s : string;
begin
  xx := x;
  for i := 0 to High(TTvScheduleStatusTbl) do begin
    s := TTvScheduleStatusMarkTbl[i];
    if Items[i].FValue then begin
      if not (odSelected in aState)	then begin
        c.Brush.Color := TTvScheduleStatusColorTbl[i];
        c.Brush.Style := bsSolid;
        xh := c.TextWidth(s);
        c.FillRect(rect(r.Left + xx,r.Top + y,r.Left + xx + xh,r.Bottom + y -1));
        c.Font.Color := clWhite;
        c.Brush.Style := bsClear;
      end
      else begin
        c.Font.Color := clWhite;
        c.Brush.Color := clHighlight;
      end;
      c.TextOut(r.Left + xx,r.Top + y,s);
      xx := xx + c.TextWidth(s);

    end;
  end;


end;


function TTvScheduleStatus.Add: TTvScheduleStatuseItem;
var
  d : TTvScheduleStatuseItem;
begin
  d := TTvScheduleStatuseItem.Create;
  inherited Add(d);
  result := d;
end;

procedure TTvScheduleStatus.Clear;
var
  i : Integer;
begin
  for i := 0 to Count-1 do begin
    Items[i].Free;
  end;
  inherited;
end;

procedure TTvScheduleStatus.Delete(i: Integer);
begin
  Items[i].Free;
  inherited;
end;

function TTvScheduleStatus.GetItems(
  Index: Integer): TTvScheduleStatuseItem;
begin
  result := inherited Items[Index];
end;

function TTvScheduleStatus.GetStatus(
  Mode: TTvScheduleStatusMode): TTvScheduleStatuseItem;
var
  i : Integer;
begin
  i := Ord(Mode);
  result := Items[i];
end;

procedure TTvScheduleStatus.StringToScheduleStatus(const str: string);
var
  i : Integer;
  s : string;
begin

  for i := 0 to High(TTvScheduleStatusHtmlTbl) do begin
    s := TTvScheduleStatusHtmlTbl[i];
    if s <> '' then begin
      Items[i].Value := Pos(s,str) <> 0;
    end;
  end;
  //ds.TalkBilingual := Pos('[]',d.Comment)<>0;    // J𔻒f

end;

function TTvScheduleStatus.CheckEqual(a: TTvScheduleStatus): Boolean;
var
  i : Integer;
begin
  result := False;
  for i := 0 to Count-1 do begin
    if Items[i].Value <> a.Items[i].Value then exit;
  end;
  result := True;
end;

{ TTvScheduleStatuseItem }

procedure TTvScheduleStatuseItem.Assign(Source: TPersistent);
var
  a : TTvScheduleStatuseItem;
begin
  if Source is TTvScheduleStatuseItem then begin
    a := TTvScheduleStatuseItem(Source);
    FValue := a.FValue;
  end
  else begin
    inherited;
  end;
end;

end.
