unit DataTvSchedulePaperRect;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls,DateTimeCtrl,MultiEvent,DataTvSchedule,
  StringListEx,StringListKey;

const
  BmpTransparentColor : TColor = clLtGray;

type
  TDataTvSchedulePaperlCashDrawMode = (tvcdBack,tvcdFront);

  TDataTvSchedulePaperRectMode = (tvprSpace,tvprTv,tvprRd);
//--------------------------------------------------------------------------//
//  ԑg\gf[^                                                        //
//--------------------------------------------------------------------------//
type
  TDataTvSchedulePaperRectItem = class(TPersistent)
  private
    { Private 錾 }
    FData: Pointer;                              // ̘gǗlXȃNX
    FRect: TRect;                                // Ǘ͈
    FOutsided: Boolean;                          // True : ʂ班͂ݏoĂvf
    FMode: TDataTvSchedulePaperRectMode;         // Ǘf[^suԑgqc̗\f[^
  public
    { Public 錾 }
    procedure Assign(Source : TPersistent) ; override;
    function CheckRectEnable() : Boolean;
    function CheckRange(const x,y : Integer) : Boolean;
    property Rect : TRect read FRect write FRect;
    property Data : Pointer read FData write FData;
    property Outsided : Boolean read FOutsided;
    property Mode : TDataTvSchedulePaperRectMode read FMode write FMode;
  end;

//--------------------------------------------------------------------------//
//  ԑg\gꗗǗNX                                                //
//--------------------------------------------------------------------------//
type
  TDataTvSchedulePaperRectItems = class(TList)
  private
    { Private 錾 }
    FListTop : TList;
    FListBottom : TList;
    function GetItems(Index: Integer): TDataTvSchedulePaperRectItem;
  public
    { Public 錾 }
    constructor Create;
    destructor Destroy;override;

    function Add() : TDataTvSchedulePaperRectItem;
    procedure Assign(a : TDataTvSchedulePaperRectItems);
    procedure Delete(i : Integer);
    procedure Clear();override;
    property Items[Index: Integer] : TDataTvSchedulePaperRectItem read GetItems;default;

    function IndexOf(d : TDataTvSchedulePaperRectItem): Integer;
    function IndexOfTv(dt : TDataTvScheduleItem) : Integer;

    function PointToData(x,y : Integer) : TDataTvSchedulePaperRectItem;
    function PointToRect(x,y : Integer) : TRect;
    function DataToRect(d : TDataTvSchedulePaperRectItem) : TRect;

    procedure DeleteEq(a : TDataTvSchedulePaperRectItems);
    procedure DeleteEqY(a : TDataTvSchedulePaperRectItems);

    procedure ColSet(const aCol : Integer);

  end;

//--------------------------------------------------------------------------//
//  ԑg\gf[^                                                        //
//--------------------------------------------------------------------------//
type
  TDataTvSchedulePaperRect = class(TPersistent)
  private
    { Private 錾 }
    FRects : TDataTvSchedulePaperRectItems;      // ʏɎ݂gǗ
    FViewRects: TDataTvSchedulePaperRectItems;   // \̘gf[^
    FViewOlds : TDataTvSchedulePaperRectItems;   // O̘gf[^Ҕp
    FTops : TDataTvSchedulePaperRectItems;       // XN[ɏGA
    FBottoms : TDataTvSchedulePaperRectItems;    // XN[ɏGA
    FTop: Integer;                               // ʏ[̍W
    FBottom: Integer;                            // ʉ[̍W
    procedure SpaceSet(r : TRect;ch : Integer);
  public
    { Public 錾 }
    constructor Create;
    destructor Destroy;override;

    procedure Add(Rect : TRect;d : Pointer;aMode : TDataTvSchedulePaperRectMode;ch : Integer);
    procedure Delete(dt : TDataTvScheduleItem);
    procedure Clear();

    procedure Backup();
    procedure ViewAll();
    procedure DeleteEQ();
    procedure DeleteEQY();
    procedure ColSet(const aCol,Xh,MaxY : Integer);

    property Rects : TDataTvSchedulePaperRectItems read FRects;
    property ViewRects : TDataTvSchedulePaperRectItems read FViewRects;
    property Bottoms : TDataTvSchedulePaperRectItems read FBottoms;
    property Tops : TDataTvSchedulePaperRectItems read FTops;
    property Top : Integer read FTop write FTop;
    property Bottom : Integer read FBottom write FBottom;
  end;

//--------------------------------------------------------------------------//
//  ԑg\̈ꎞҔNX                                                  //
//--------------------------------------------------------------------------//
type
  TDataTvSchedulePaperlCashItem = class(TPersistent)
  private
    { Private 錾 }
    //FRect : TRect;
    FBmpBack : TBitmap;
    FBmpFront : TBitmap;
    FEnabledBack : Boolean;             // True : ̃LbV͗L
    FEnabledFront : Boolean;             // True : ̃LbV͗L
  public
    { Public 錾 }
    constructor Create;
    destructor Destroy;override;
  end;

//--------------------------------------------------------------------------//
//  ԑg\̈ꎞҔNX                                                  //
//--------------------------------------------------------------------------//
type
  TDataTvSchedulePaperlCash = class(TPersistent)
  private
    { Private 錾 }
    FList : TList;                 // ԑgf[^ǗXg
    FItems : TList;                // LbVf[^Xg
  public
    { Public 錾 }
    constructor Create;
    destructor Destroy;override;

    procedure Add(d : TDataTvScheduleItem);
    procedure Delete(d : TDataTvScheduleItem);
    procedure Clear();
    procedure AllDisable();

    function CheckCash(d : TDataTvScheduleItem;m : TDataTvSchedulePaperlCashDrawMode) : Boolean;
    function CheckBmp(d : TDataTvScheduleItem) : Boolean;
    function DataSet(d : TDataTvScheduleItem;r : TRect;var r2 : TRect;
                      Bmp : TBitmap;m : TDataTvSchedulePaperlCashDrawMode):TBitmap;
    procedure DataGet(d : TDataTvScheduleItem;r: TRect;Bmp : TBitmap;m : TDataTvSchedulePaperlCashDrawMode);

  end;

implementation

{ DataTvSchedulePaperRectItems }

//**************************************************************************//
//                                                                          //
//  `@NX@`                                                      //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
constructor TDataTvSchedulePaperRectItems.Create;
begin
  FListTop := TList.Create;
  FListBottom := TList.Create;
end;

//**************************************************************************//
//                                                                          //
//  `@NXj@`                                                      //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
destructor TDataTvSchedulePaperRectItems.Destroy;
begin
  Clear();
  FListBottom.Free;
  FListTop.Free;
  inherited;
end;

function TDataTvSchedulePaperRectItems.Add() : TDataTvSchedulePaperRectItem;
var
  d : TDataTvSchedulePaperRectItem;
begin
  d := TDataTvSchedulePaperRectItem.Create;
  inherited Add(d);
  result := d;
end;

procedure TDataTvSchedulePaperRectItems.Clear;
var
  i : Integer;
begin
  for i := 0 to Count-1 do begin
    Items[i].Free;
  end;
  inherited;
end;

function TDataTvSchedulePaperRectItems.DataToRect(d: TDataTvSchedulePaperRectItem): TRect;
var
  i : Integer;
begin
  result := Rect(0,0,0,0);
  i := IndexOf(d);
  if i < 0 then exit;
  result := Items[i].Rect;
end;

procedure TDataTvSchedulePaperRectItems.Delete(i: Integer);
begin
  Items[i].Free;
  inherited;
end;

function TDataTvSchedulePaperRectItems.GetItems(
  Index: Integer): TDataTvSchedulePaperRectItem;
begin
  result := inherited Items[Index];
end;

//**************************************************************************//
//                                                                          //
//  `@Xg̒vf[^̃Xgԍ擾@`                  //
//                                                                          //
//   - Input -  d : ׂf[^                                            //
//                                                                          //
//   - Output - XgԍivȂꍇ-1j                            //
//                                                                          //
//**************************************************************************//
function TDataTvSchedulePaperRectItems.IndexOf(d: TDataTvSchedulePaperRectItem): Integer;
var
  i : Integer;
begin
  result := -1;
  if d = nil then exit;
  for i := 0 to Count-1 do begin
    if Items[i].Data = d.Data then begin       // Xg̃f[^͖XV̂DataŃ`FbN
      result := i;
      exit;
    end;
  end;
end;

function TDataTvSchedulePaperRectItems.IndexOfTv(
  dt: TDataTvScheduleItem): Integer;
var
  i : Integer;
begin
  result := -1;
  if dt = nil then exit;
  for i := 0 to Count-1 do begin
    if Items[i].Data = dt then begin
      result := i;
      exit;
    end;
  end;
end;

procedure TDataTvSchedulePaperRectItems.ColSet(const aCol: Integer);
var
  i : Integer;
begin
  for i := 0 to aCol-1 do begin
    //Add(
    //FListTop.
  end;

end;

//**************************************************************************//
//                                                                          //
//  `@WɈvԑgf[^擾@`                                  //
//                                                                          //
//   - Input -  x,y : }EXW                                            //
//                                                                          //
//   - Output - ԑgf[^ivȂꍇnilj                           //
//                                                                          //
//**************************************************************************//
function TDataTvSchedulePaperRectItems.PointToData(x, y: Integer): TDataTvSchedulePaperRectItem;
var
  i : Integer;
  d : TDataTvSchedulePaperRectItem;
begin
  result := nil;
  for i := 0 to Count-1 do begin
    d := Items[i];
    if d.CheckRange(x,y) then begin
      result := d;
      exit;
    end;
  end;
end;

//**************************************************************************//
//                                                                          //
//  `@WɈv͈̓f[^擾@`                                  //
//                                                                          //
//   - Input -  x,y : }EXW                                            //
//                                                                          //
//   - Output - ͈̓f[^ivȂꍇRect(0,0,0,0)j                 //
//                                                                          //
//**************************************************************************//
function TDataTvSchedulePaperRectItems.PointToRect(x, y: Integer): TRect;
var
  i : Integer;
  d : TDataTvSchedulePaperRectItem;
begin
  result := Rect(0,0,0,0);
  for i := 0 to Count-1 do begin
    d := Items[i];
    if d.CheckRange(x,y) then begin
      result := d.Rect;
      exit;
    end;
  end;
end;

{ TDataTvSchedulePaperlCash }

constructor TDataTvSchedulePaperlCash.Create;
begin
  FList := TList.Create;
  FItems := TList.Create;
end;

destructor TDataTvSchedulePaperlCash.Destroy;
begin
  Clear;
  FItems.Free;
  FList.Free;
  inherited;
end;

procedure TDataTvSchedulePaperRectItems.Assign(a: TDataTvSchedulePaperRectItems);
var
  i : Integer;
  d : TDataTvSchedulePaperRectItem;
begin
  Clear();
  for i := 0 to a.Count-1 do begin
    d := Add();
    d.Assign(a.Items[i]);

    //Add(d.FRect,d.FData,d.FMode,d.Outsided);
  end;

end;

//**************************************************************************//
//                                                                          //
//  `@Q̍WꗗǗXg獷݂̂c                          //
//                                                                          //
//   - Input -  a : rWXgie͕ωȂj                  //
//                                                                          //
//   - Output - Ȃ                                                        //
//                                                                          //
//   ɈړۂɎgp鍷NX                               //
//                                                                          //
//**************************************************************************//
procedure TDataTvSchedulePaperRectItems.DeleteEq(a: TDataTvSchedulePaperRectItems);
var
  i : Integer;
  d : Pointer;
begin
  i := 0;
  while i < Count-1 do begin
    d := Items[i].FData;
    if a.IndexOf(d) <> -1 then begin
      Delete(i);
    end
    else begin
      Inc(i);
    end;
  end;
end;

//**************************************************************************//
//                                                                          //
//  `@Q̍WꗗǗXg獷݂̂c                          //
//                                                                          //
//   - Input -  a : rWXgie͕ωȂj                  //
//                                                                          //
//   - Output - Ȃ                                                        //
//                                                                          //
//   cɈړۂɎgp鍷NX                               //
//     ʂ͂ݏoĂg͍ĕ`s                               //
//                                                                          //
//**************************************************************************//
procedure TDataTvSchedulePaperRectItems.DeleteEqY(a: TDataTvSchedulePaperRectItems);
var
  i,j : Integer;
  d : TDataTvSchedulePaperRectItem;
  f : Boolean;
begin
  i := 0;
  while i < Count-1 do begin
    f := False;
    //dv := Items[i].FData;
    if Items[i].Outsided then begin
      //Inc(i);
    end
    else  begin
      j := a.IndexOf(Items[i]);
      if j <> -1 then begin
        d := a[j];
        if not d.FOutsided then begin
          f := True;
        end;
      end
    end;
    if f then begin
      Delete(i);
    end
    else begin
      Inc(i);
    end;
  end;
end;

procedure TDataTvSchedulePaperlCash.Add(d: TDataTvScheduleItem);
var
  t : TDataTvSchedulePaperlCashItem;
begin
  t := TDataTvSchedulePaperlCashItem.Create;
  FItems.Add(t);
  FList.Add(d);
end;

procedure TDataTvSchedulePaperlCash.Delete(d: TDataTvScheduleItem);
var
  t : TDataTvSchedulePaperlCashItem;
  i : Integer;
begin
  i := FList.IndexOf(d);
  if i = -1 then exit;
  FList.Delete(i);
  t := FItems.Items[i];
  t.Free;
  FItems.Delete(i);
end;

procedure TDataTvSchedulePaperlCash.Clear;
var
  t : TDataTvSchedulePaperlCashItem;
  i : Integer;
begin
  for i := 0 to FItems.Count-1 do begin
    t := FItems.Items[i];
    t.Free;
  end;
  FItems.Clear;
  FList.Clear;
end;

function TDataTvSchedulePaperlCash.DataSet(d: TDataTvScheduleItem;
  r: TRect;var r2 : TRect; Bmp: TBitmap;m : TDataTvSchedulePaperlCashDrawMode): TBitmap;
var
  t : TDataTvSchedulePaperlCashItem;
  i : Integer;
  b : TBitmap;
begin
  result := nil;
  i := FList.IndexOf(d);
  if i < 0 then exit;
  t := FItems.Items[i];
  if m = tvcdBack then begin
    b := t.FBmpBack;
  end
  else begin
    b := t.FBmpFront;
  end;

  b.Width := r.Right - r.Left;
  if r.Bottom > r.Top then begin
    b.Height := r.Bottom - r.Top;
  end
  else begin
    b.Height := 0;
  end;
  b.Canvas.Brush.Style := bsSolid;
  b.Canvas.Brush.Color := BmpTransparentColor;
  b.Canvas.FillRect(Rect(0,0,b.Width,b.Height));
  r2 := Rect(0,0,b.Width,b.Height);
  if m = tvcdBack then begin
    t.FEnabledBack := True;              // LbVLƂ
  end
  else begin
    t.FEnabledFront := True;             // LbVLƂ
  end;
  result := b;
end;

procedure TDataTvSchedulePaperlCash.DataGet(d: TDataTvScheduleItem;r: TRect;
  Bmp: TBitmap;m : TDataTvSchedulePaperlCashDrawMode);
var
  t : TDataTvSchedulePaperlCashItem;
  i : Integer;
  b : TBitmap;
begin
  i := FList.IndexOf(d);
  if i < 0 then exit;
  t := FItems.Items[i];

  if m = tvcdBack then begin
    b := t.FBmpBack;
    b.Canvas.CopyMode := cmSrcCopy;
  end
  else begin
    b := t.FBmpFront;
  end;
  Bmp.Canvas.Draw(r.Left,r.Top,b);            // ʂɔf
end;

procedure TDataTvSchedulePaperlCash.AllDisable;
var
  t : TDataTvSchedulePaperlCashItem;
  i : Integer;
begin
  for i := 0 to FItems.Count-1 do begin
    t := FItems.Items[i];
    t.FEnabledFront := False;
    t.FEnabledBack := False;
  end;
  Clear();
end;

function TDataTvSchedulePaperlCash.CheckCash(d: TDataTvScheduleItem;m : TDataTvSchedulePaperlCashDrawMode): Boolean;
var
  t : TDataTvSchedulePaperlCashItem;
  i : Integer;
begin
  result := False;
  i := FList.IndexOf(d);
  if i < 0 then exit;
  t := FItems.Items[i];

  if m = tvcdBack then begin
    result := t.FEnabledBack;
  end
  else begin
    result := t.FEnabledFront;
  end;

end;

function TDataTvSchedulePaperlCash.CheckBmp(d: TDataTvScheduleItem): Boolean;
var
  i : Integer;
begin
  result := False;
  i := FList.IndexOf(d);
  if i < 0 then exit;
  result := True;
end;

{ TDataTvSchedulePaperlCashItem }

constructor TDataTvSchedulePaperlCashItem.Create;
begin
  FBmpBack := TBitmap.Create;
  FBmpBack.PixelFormat := pf8bit;
  FBmpFront := TBitmap.Create;
  FBmpFront.PixelFormat := pf8bit;
  FBmpFront.TransparentColor := BmpTransparentColor;
  FBmpFront.Transparent := True;
end;

destructor TDataTvSchedulePaperlCashItem.Destroy;
begin
  FBmpFront.Free;
  FBmpBack.Free;
  inherited;
end;

{ TDataTvSchedulePaperRectItem }

//**************************************************************************//
//                                                                          //
//  `@\͈͂PsNZf@`                                  //
//                                                                          //
//   - Input -  Ȃ                                                        //
//                                                                          //
//   - Output - True : PsNZȏ                                       //
//                                                                          //
//**************************************************************************//
procedure TDataTvSchedulePaperRectItem.Assign(Source: TPersistent);
var
  a : TDataTvSchedulePaperRectItem;
begin
  if Source is TDataTvSchedulePaperRectItem then begin
    a := TDataTvSchedulePaperRectItem(Source);
    FData := a.FData;
    FRect := a.FRect;
    FOutsided := a.FOutsided;
    FMode  := a.FMode;
  end
  else begin
    inherited;
  end;
end;

//**************************************************************************//
//                                                                          //
//  `@w肵W͈͓Ɋ܂܂Ă邩f@`                        //
//                                                                          //
//   - Input -  Ȃ                                                        //
//                                                                          //
//   - Output - True : ܂܂Ă                                         //
//                                                                          //
//**************************************************************************//
function TDataTvSchedulePaperRectItem.CheckRange(const x,
  y: Integer): Boolean;
begin
  result := False;
  if (x >= FRect.Left) and (x <= FRect.Right) and
     (y >= FRect.Top) and (y <= FRect.Bottom) then begin
    result := True;
    exit;
  end;

end;

function TDataTvSchedulePaperRectItem.CheckRectEnable: Boolean;
begin
  result := False;
  if FRect.Top = FRect.Bottom then exit;
  if FRect.Left = FRect.Right then exit;
  result := True;
end;

{ TDataTvSchedulePaperRect }

procedure TDataTvSchedulePaperRect.Add(Rect: TRect; d : Pointer;
  aMode: TDataTvSchedulePaperRectMode;ch : Integer);
var
  aOutSide : Boolean;
  dd : TDataTvSchedulePaperRectItem;
begin
  aOutSide := False;
  if Rect.Top < 0 then aOutSide := True;
  if Rect.Bottom > FBottom then aOutSide := True;
  dd := FRects.Add();
  dd.FRect := Rect;
  dd.FData := d;
  dd.FMode := aMode;
  dd.FOutsided := aOutSide;
  //FRects.Add(Rect,d,aMode,aOutSide);
  //if not aOutSide then SpaceSet(Rect,ch);
  if aMode = tvprTv then begin
    SpaceSet(Rect,ch);
  end;  
end;

procedure TDataTvSchedulePaperRect.Delete(dt: TDataTvScheduleItem);
var
  i : Integer;
begin
  i := FRects.IndexOfTv(dt);
  FRects.Delete(i);
end;

procedure TDataTvSchedulePaperRect.Backup;
begin
  FViewOlds.Assign(FRects);
end;

procedure TDataTvSchedulePaperRect.Clear;
begin
  FRects.Clear;
  FViewRects.Clear;
  FViewOlds.Clear;
end;

//**************************************************************************//
//                                                                          //
//  `@cֈړۂɏKvȘgXg@`                //
//                                                                          //
//   - Input -  aCol : ̕ǐ                                     //
//              Xh   : Pǂ̉                                       //
//              MaxY : c                                                 //
//                                                                          //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
procedure TDataTvSchedulePaperRect.ColSet(const aCol,Xh,MaxY: Integer);
var
  i : Integer;
  r : TRect;
  d : TDataTvSchedulePaperRectItem;
begin
  FTops.Clear;
  FBottoms.Clear;
  for i := 0 to aCol-1 do begin
    r := Rect(i * Xh,                  // \͈͂ݒ
              0,
              (i + 1) * Xh,
              MaxY);
    d := FTops.Add();
    d.FRect := r;
    d.FMode := tvprSpace;
    d.FOutsided := False;

    d := FBottoms.Add();
    d.FRect := r;
    d.FMode := tvprSpace;
    d.FOutsided := False;

  end;

end;

constructor TDataTvSchedulePaperRect.Create;
begin
  FRects := TDataTvSchedulePaperRectItems.Create;
  FViewRects := TDataTvSchedulePaperRectItems.Create;
  FViewOlds := TDataTvSchedulePaperRectItems.Create;
  FTops := TDataTvSchedulePaperRectItems.Create;
  FBottoms := TDataTvSchedulePaperRectItems.Create;
end;

destructor TDataTvSchedulePaperRect.Destroy;
begin
  FTops.Free;
  FBottoms.Free;
  FViewOlds.Free;
  FViewRects.Free;
  FRects.Free;
  inherited;
end;

procedure TDataTvSchedulePaperRect.DeleteEQ;
begin
  FViewRects.Assign(FRects);
  FViewRects.DeleteEq(FViewOlds);
end;

procedure TDataTvSchedulePaperRect.DeleteEQY;
begin
  FViewRects.Assign(FRects);
  FViewRects.DeleteEqY(FViewOlds);
end;

procedure TDataTvSchedulePaperRect.SpaceSet(r : TRect;ch : Integer);
begin
  if (FTops[ch].Rect.Bottom > r.Top) then begin
    FTops[ch].Rect := Rect(FTops[ch].Rect.Left,0,FTops[ch].Rect.Right,r.Top);
  end;
  if FBottoms[ch].Rect.Top < r.Bottom then begin
    FBottoms[ch].Rect := Rect(FBottoms[ch].Rect.Left,r.Bottom,FBottoms[ch].Rect.Right,FBottoms[ch].Rect.Bottom);
  end;

end;

procedure TDataTvSchedulePaperRect.ViewAll;
begin
  FViewRects.Assign(FRects);
end;

end.
