unit DataTvSchedulePaperColumn;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,ExtCtrls,DefaultData,StringListEx,StringListKey,MultiEvent,
  DataTvChannel;

//--------------------------------------------------------------------------//
//  ԑg\̕Ǖ\Ǘf[^NX                                    //
//--------------------------------------------------------------------------//
type
  TDataTvSchedulePaperColumnItem = class(TPersistent)
  private
    FChannelIndex: Integer;
    FChannelEx: Integer;
    FChannelTv: Integer;                 //
    function DataLoad(t : TStringListEx) : Boolean;
    function DataSave(t : TStringListEx) : Boolean;
  public
    { Public 錾 }
    procedure Assign(Source : TPersistent) ; override;
    property ChannelIndex : Integer read FChannelIndex write FChannelIndex;
    property ChannelTv : Integer read FChannelTv write FChannelTv;
    property ChannelEx : Integer read FChannelEx write FChannelEx;
  end;

//--------------------------------------------------------------------------//
//  ԑg\̕Ǖ\ǗXgNX                                    //
//--------------------------------------------------------------------------//
type
  TDataTvSchedulePaperColumnItems = class(TList)
  private
    function GetItems(Index: Integer): TDataTvSchedulePaperColumnItem;
    { Private 錾 }
  public
    { Public 錾 }
    constructor Create;
    destructor Destroy;override;
    procedure Assign(Source : TDataTvSchedulePaperColumnItems);
    function Add() : TDataTvSchedulePaperColumnItem;
    procedure Delete(i : Integer);
    procedure Clear();override;
    property Items[Index: Integer] : TDataTvSchedulePaperColumnItem read GetItems;default;

    function ChToIndex(aCh : Integer) : Integer;

    function DataLoad(t : TStringListEx) : Boolean;
    function DataSave(tt : TStringListEx) : Boolean;
  end;

//--------------------------------------------------------------------------//
//  ԑg\̕\ڂǗf[^NX                                  //
//--------------------------------------------------------------------------//
type
  TDataTvSchedulePaperConfig = class(TPersistent)
  private
    { Private 錾 }
    FOnChanges: TMultiEventSend;
    FColumns : TDataTvSchedulePaperColumnItems;
    FRowCount: Integer;
    FColCount: Integer;
    procedure DoChange();

  public
    { Public 錾 }
    constructor Create;
    destructor Destroy;override;
    procedure Assign(Source : TPersistent) ; override;
    function DataLoadDef(dc : TDataTvChannel) : Boolean;
    function DataLoad(tt : TStringListKey;dc : TDataTvChannel) : Boolean;
    function DataSave(tt : TStringListKey) : Boolean;

    property RowCount : Integer read FRowCount write FRowCount;
    property ColCount : Integer read FColCount write FColCount;
    property Columns : TDataTvSchedulePaperColumnItems read FColumns;

    property OnChanges    : TMultiEventSend read FOnChanges;
  end;

implementation

{ TDataTvSchedulePaperColumnItems }

uses DMUnit;

constructor TDataTvSchedulePaperColumnItems.Create;
begin

end;

destructor TDataTvSchedulePaperColumnItems.Destroy;
begin
  Clear();
  inherited;
end;

procedure TDataTvSchedulePaperColumnItems.Assign(
  Source: TDataTvSchedulePaperColumnItems);
var
  i : Integer;
  d : TDataTvSchedulePaperColumnItem;
begin
  Clear();
  for i := 0 to Source.Count-1 do begin
    d := Add();
    d.Assign(Source[i]);
  end;
end;

function TDataTvSchedulePaperColumnItems.Add: TDataTvSchedulePaperColumnItem;
var
  d : TDataTvSchedulePaperColumnItem;
begin
  d := TDataTvSchedulePaperColumnItem.Create;
  inherited Add(d);
  result := d;
end;

procedure TDataTvSchedulePaperColumnItems.Clear;
var
  i : Integer;
begin
  for i := 0 to Count-1 do begin
    Items[i].Free;
  end;
  inherited;
end;

procedure TDataTvSchedulePaperColumnItems.Delete(i: Integer);
begin
  Items[i].Free;
  inherited;
end;

function TDataTvSchedulePaperColumnItems.GetItems(
  Index: Integer): TDataTvSchedulePaperColumnItem;
begin
  result := inherited Items[Index];
end;

function TDataTvSchedulePaperColumnItems.DataLoad(
  t : TStringListEx): Boolean;
var
  i : Integer;
  d : TDataTvSchedulePaperColumnItem;
  t2 : TStringListEx;
begin
  result := False;
  if t.Count = 0 then exit;
  t2 := TStringListEx.Create;
  try
    Clear;
    for i := 0 to t.Count-1 do begin
      d := Add();
      t2.CommaTextEx := t[i];
      d.DataLoad(t2);
    end;
    result := True;
  finally
    t2.Free;
  end;

end;

function TDataTvSchedulePaperColumnItems.DataSave(
  tt: TStringListEx): Boolean;
var
  i : Integer;
  d : TDataTvSchedulePaperColumnItem;
  t2 : TStringListEx;
begin
  t2 := TStringListEx.Create;
  try
    result := False;
    for i := 0 to Count-1 do begin
      t2.Clear;
      d := Items[i];
      d.DataSave(t2);

      tt.Add(t2.CommaTextEx);
    end;
    result := True;
  finally
    t2.Free;
  end;
end;

function TDataTvSchedulePaperColumnItems.ChToIndex(aCh: Integer): Integer;
var
  i : Integer;
begin
  result := -1;
  for i := 0 to Count-1 do begin
    if Items[i].ChannelIndex = aCh then begin
      result := i;
      exit;
    end;
  end;

end;

{ TDataTvSchedulePaperColumnItem }

procedure TDataTvSchedulePaperColumnItem.Assign(Source: TPersistent);
var
  a : TDataTvSchedulePaperColumnItem;
begin
  if Source is TDataTvSchedulePaperColumnItem then begin
    a := TDataTvSchedulePaperColumnItem(Source);
    FChannelIndex := a.FChannelIndex;
    FChannelTv    := a.FChannelTv;
    FChannelEx    := a.FChannelEx;
  end
  else begin
    inherited;
  end;
end;

function TDataTvSchedulePaperColumnItem.DataLoad(
  t: TStringListEx): Boolean;
begin
  FChannelIndex := t.GetInts('ChannelIndex',FChannelIndex);
  FChannelTv    := t.GetInts('ChannelTv',FChannelTv);
  FChannelEx    := t.GetInts('ChannelEx',FChannelEx);
  result := True;
end;

function TDataTvSchedulePaperColumnItem.DataSave(
  t: TStringListEx): Boolean;
begin
  result := True;
  t.SetInts('ChannelIndex',FChannelIndex);
  t.SetInts('ChannelTv',FChannelTv);
  t.SetInts('ChannelEx',FChannelEx);
end;

{ TDataTvSchedulePaperConfig }

constructor TDataTvSchedulePaperConfig.Create;
begin
  FColumns := TDataTvSchedulePaperColumnItems.Create;
  FColCount := 6;
  FRowCount := 6;
  FOnChanges := TMultiEventSend.Create(nil);
end;

destructor TDataTvSchedulePaperConfig.Destroy;
begin
  FOnChanges.Free;
  FColumns.Free;
  inherited;
end;

procedure TDataTvSchedulePaperConfig.Assign(Source: TPersistent);
var
  a : TDataTvSchedulePaperConfig;
begin
  if Source is TDataTvSchedulePaperConfig then begin
    a := TDataTvSchedulePaperConfig(Source);
    FColCount := a.FColCount;
    FRowCount := a.FRowCount;
    FColumns.Assign(a.FColumns);
    DoChange();
  end
  else begin
    inherited;
  end;
end;

function TDataTvSchedulePaperConfig.DataLoad(tt: TStringListKey;dc : TDataTvChannel): Boolean;
  function DataLoadSub(tk : TStringListKey) : Boolean;
  var
    t : TStringListEx;
  begin
    result := False;
    t := tk.Values['TvPaperColumn'];
    if t = nil then exit;
    FRowCount := t.GetInts('RowCount',6);
    FColCount := t.GetInts('RowCount',6);
    t := tk.Values['TvPaperColumnChannel'];
    if t = nil then exit;
    FColumns.DataLoad(t);
    result := True;
  end;
begin
  result := False;
  if not DataLoadSub(tt) then begin
    DataLoadDef(dc);
    result := True;
  end;
  DoChange();
end;

function TDataTvSchedulePaperConfig.DataSave(tt: TStringListKey): Boolean;
var
  t,t2 : TStringListEx;
begin
  t := TStringListEx.Create;
  t2 := TStringListEx.Create;
  try
    result := False;
    t.SetInts('RowCount',FRowCount);
    t.SetInts('ColCount',FColCount);
    tt.Add('TvPaperColumn',t);
    FColumns.DataSave(t2);
    tt.Add('TvPaperColumnChannel',t2);
    //t.SetStrs('Column',t2.CommaTextEx);
    //tt.Add('TvPaperColumn',t);
    result := True;
  finally
    t2.Free;
    t.Free;
  end;
end;


function TDataTvSchedulePaperConfig.DataLoadDef(dc : TDataTvChannel): Boolean;
var
  i : Integer;
  d : TDataTvChannelItem;
  d2 : TDataTvSchedulePaperColumnItem;
  //FDM : TDM;
begin
  //FDM := TDM(aDM);
  FRowCount := 6;
  FColCount := 6;

  FColumns.Clear;
  for i := 0 to dc.Items.Count-1 do begin
    d := dc.Items[i];
    if d.Visible then begin
      d2 := FColumns.Add();
      d2.ChannelIndex := i;
      d2.ChannelTv := d.ChannelTv;
      d2.ChannelEx := d.ChannelEx;
    end;
  end;
  result := True;
end;

procedure TDataTvSchedulePaperConfig.DoChange;
begin
  FOnChanges.Notify(Self);
end;

end.
