//**************************************************************************//
//                                                                          //
//  suԑgf[^ǗNX                                          //
//                                                                          //
//  `lNX̎QƂs߂DM𒼐ڎQƂĂ            //
//                                                                          //
//**************************************************************************//
unit DataTvSchedule;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,StringListEx,ExtCtrls,DefaultData,DateTimeCtrl,
  DataTvStatus,MultiEvent,DateTimeCtrlRdTool,DataTvChannel,
  DataTvScheduleGenre;

const
  TvGuideSaveDataVersion = 5;             // TVԑgۑ̃o[Wԍ

//--------------------------------------------------------------------------//
//  TVԑgf[^NX                                                      //
//--------------------------------------------------------------------------//
type
  TDataTvScheduleItem = class(TPersistent)
  private
    { Private 錾 }
    FOwner : TObject;                 // TDataTvScheduleItems w
    FTitle: string;                   // ԑg
    FGenre: TDataTvScheduleGenre;     // W
    FGenreName : string;                // Ẃiǃf[^Ŏgpj
    //FGenruStr : string;
    //FChannel: Integer;                // `l
    FStart: TDateTimeCtrlRd;          // Jn
    FStop: TDateTimeCtrlRd;           // I
    FRecOverlap: TRdTvRecStatusMode;  // ^\Ƃ̏dȂ
    FRecRdNo: Integer;                // ^\񂵂RD
    FComment: string;                 // ڍדe
    FExtensionIndex: Integer;         // ̉eԑgi邽ߖgpj
    FSubTitle: string;                // ԑgڍ
    FTalkNo: Integer;                 // ݘb
    FTalkMax: Integer;                // bő

    FStatus : TTvScheduleStatus;      // ԑgNX

    FReadTvGuide: Boolean;            // True : On TV Japanǂݍݍς
    FNo: Integer;                     // Ǘp̔ԍBԍ݂͑Ȃ
    FChTv: Integer;                   // ǃf[^Ɗ֘AliOnTvJapanpj
    FChTvEx: Integer;                 // ǃf[^Ɗ֘Alȋj
    function GetTimeLength: Integer;
    procedure ChListAdd();
    procedure ChListDel();
    function GetChannelObj: TDataTvChannelItem;
    function GetGenreStr: string;
    procedure SetGenreStr(const Value: string);
  public
    { Public 錾 }
    constructor Create;
    destructor Destroy;override;
    procedure Assign(Source : TPersistent) ; override;

    function Compari(dt : TDataTvScheduleItem) : Boolean;

    function DataLoad(t : TStringListEx) : Boolean;
    function DataSave(t : TStringListEx) : Boolean;

    property Start : TDateTimeCtrlRd read FStart;
    property Stop  : TDateTimeCtrlRd read FStop;
    property Status : TTvScheduleStatus read FStatus;
    property No : Integer read FNo;
    property Title : string  read FTitle write FTitle;
    property GenreStr  : string read GetGenreStr write SetGenreStr;
    property Genre : TDataTvScheduleGenre read FGenre write FGenre;
    property GenreName : string read FGenreName write FGenreName;
    //property Channel : Integer read FChannel write SetChannel;
    property ChTv : Integer read FChTv write FChTv;
    property ChTvEx : Integer read FChTvEx write FChTvEx;
    property ChannelObj : TDataTvChannelItem read GetChannelObj;
    property TimeLength : Integer read GetTimeLength;
    property RecOverlap : TRdTvRecStatusMode read FRecOverlap write FRecOverlap;
    property RecRdNo : Integer read FRecRdNo write FRecRdNo;
    property Comment   : string read FComment write FComment;
    property ExtensionIndex : Integer read FExtensionIndex write FExtensionIndex;
    property SubTitle : string  read FSubTitle write FSubTitle;
    property TalkNo : Integer read FTalkNo write FTalkNo;
    property TalkMax : Integer read FTalkMax write FTalkMax;
    property ReadTvGuide : Boolean read FReadTvGuide write FReadTvGuide;
  end;

//--------------------------------------------------------------------------//
//  TVԑgXgǗNXiQƂ̂݁j                                      //
//--------------------------------------------------------------------------//
type
  TDataTvScheduleItemsEx = class(TList)
  private
    { Private 錾 }
    function GetItems(Index: Integer): TDataTvScheduleItem;
  public
    { Public 錾 }

    procedure Add(d : TDataTvScheduleItem);
    procedure Extract(d : TDataTvScheduleItem);

    property Items[Index: Integer] : TDataTvScheduleItem read GetItems;default;

  end;

//--------------------------------------------------------------------------//
//  TVԑgXgǗNXîj                                    //
//--------------------------------------------------------------------------//
type
  TDataTvScheduleItems = class(TList)
  private
    { Private 錾 }
    function GetItems(Index: Integer): TDataTvScheduleItem;
  public
    { Public 錾 }
    destructor Destroy;override;

    procedure Add(d : TDataTvScheduleItem);
    procedure Adds(ts : TDataTvScheduleItems);
    procedure Delete(i : Integer);overload;
    procedure Delete(d : TDataTvScheduleItem);overload;

    property Items[Index: Integer] : TDataTvScheduleItem read GetItems;default;

    procedure Clear();override;
  end;

//--------------------------------------------------------------------------//
//  TVԑgXgǗNX                                                  //
//  TDataTvScheduleȊO̐͋֎~                                   //
//--------------------------------------------------------------------------//
type
  TDataTvScheduleItemsPlus = class(TList)
  private
    { Private 錾 }
    FOwner : TObject;                           // TDataTvScheduleQ
    FReadStringList : TStringListEx;            // ǂݍ݃f[^t@Cꎟۑp
    FReadBusy : Boolean;                        // True : œǂݍݏ
    FDataChanged : Boolean;                     // True : f[^ɕύXL
    function GetItems(Index: Integer): TDataTvScheduleItem;

    function AddSub(d : TDataTvScheduleItem) : TDataTvScheduleItem;
    procedure DelSub(d : TDataTvScheduleItem);

    function IndexOfCompari(dt : TDataTvScheduleItem) : Integer;

  public
    { Public 錾 }
    constructor Create;
    destructor Destroy;override;

    //procedure Assign(a : TDataTvScheduleItems);
    procedure Add(d : TDataTvScheduleItem;Test : Integer);
    procedure Adds(ts : TDataTvScheduleItems;Test : Integer);
    procedure Delete(i : Integer);overload;
    procedure Delete(d : TDataTvScheduleItem);overload;
    procedure Deletes(ts : TDataTvScheduleItemsEx);overload;

    procedure Clear();override;

    property Items[Index: Integer] : TDataTvScheduleItem read GetItems;default;


    property ReadBusy : Boolean read FReadBusy;
    property DataChanged : Boolean read FDataChanged;

  end;

(*  
//--------------------------------------------------------------------------//
//  TVԑg`lʂɊǗNX                                    //
//--------------------------------------------------------------------------//
type
  TDataTvScheduleChannel = class(TPersistent)
  private
    { Private 錾 }
  public
    { Public 錾 }
    
  end;
*)
//--------------------------------------------------------------------------//
//  TVԑgǗNX                                                        //
//--------------------------------------------------------------------------//
type
  TDataTvSchedule = class(TPersistent)
  private
    { Private 錾 }
    FChannel : TDataTvChannel;          // ǈꗗǗNX̎Q
    FItems : TDataTvScheduleItemsPlus;

    FTimer : TTimer;                            // xǂݍݗp^C}[
    FReadStringList : TStringListEx;            // ǂݍ݃f[^t@Cꎟۑp
    FReadCount : Integer;                       // ݓǂݍ݈ʒuisj
    FReadBusy : Boolean;                        // True : œǂݍݏ
    FDataChanged : Boolean;                     // True : f[^ɕύXL
    FListAdd : TList;                           // ǉvfXg
    FListDel : TList;                           // 폜vfXg
    FListChg : TList;                           // ύXvfXg
    FOnChangeAdds: TMultiEventSend;             // vfǉɔCxgNX
    FOnChangeDels: TMultiEventSend;             // vf폜OɔCxgNX
    FOnChangeDelAfter: TMultiEventSend;         // vf폜ɔCxgNX
    FOnChangeClrs: TMultiEventSend;
    FOnChanges: TMultiEventSend;
    FOnDataDels: TMultiEventSend;
    FOnDataClr: TMultiEventSend;
    FOnDataAdds: TMultiEventSend;                // vfSɔCxgNX

    procedure OnTimer(Sender : TObject);
    function DataLoadTimerProc() : Boolean;
    procedure DeleteOldData(const OldDayCnt : Integer);

    procedure DoDataAdds(ts : TDataTvScheduleItemsEx);
    procedure DoDataDels(ts : TDataTvScheduleItemsEx);
    procedure DoDataClr();

  public
    { Public 錾 }
    constructor Create();
    destructor Destroy;override;

    // SĂ̔ԑgf[^íjǗXg
    property Items : TDataTvScheduleItemsPlus read FItems;


    function DataLoad(t : TStringListEx) : Boolean;
    function DataSave(t : TStringListEx) : Boolean;

    // obNOEhǂݍݏ̒~
    procedure BgLoadStop();

    // obNOEhǂݍݏ̍ĊJ
    procedure BgLoadReStart();

    // True : f[^obNOEhœǂݍݒ
    property ReadBusy : Boolean read FReadBusy;

    // True : f[^ɒǉ^폜ȂǂAۑKvꍇ
    property DataChanged : Boolean read FDataChanged;

    // suԑgǕʂɕނ邽߂̃NX
    property Channel : TDataTvChannel read FChannel write FChannel;

    // f[^ǉCxg
    property OnDataAdds : TMultiEventSend read FOnDataAdds;

    // f[^폜Cxg
    property OnDataDels : TMultiEventSend read FOnDataDels;

    // f[^NACxg
    property OnDataClr  : TMultiEventSend read FOnDataClr;
  end;

implementation

uses DMUnit;

{ TDataTvScheduleItem }

//**************************************************************************//
//                                                                          //
//  `@NX@`                                                      //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
constructor TDataTvScheduleItem.Create;
begin
  FStart := TDateTimeCtrlRd.Create;
  FStop  := TDateTimeCtrlRd.Create;
  FStatus := TTvScheduleStatus.Create;
end;

//**************************************************************************//
//                                                                          //
//  `@NXj@`                                                      //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
destructor TDataTvScheduleItem.Destroy;
begin
  FStatus.Free;
  FStop.Free;
  FStart.Free;
  ChListDel();
  //FChannelObj := nil;
  inherited;
end;

//**************************************************************************//
//                                                                          //
//  `@NX@`                                                      //
//                                                                          //
//   - Input -  Source : Rs[                                           //
//                                                                          //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
procedure TDataTvScheduleItem.Assign(Source: TPersistent);
var
  a : TDataTvScheduleItem;
begin
  if Source is TDataTvScheduleItem then begin
    a := TDataTvScheduleItem(Source);
    FStart.Assign(a.FStart);
    FStop.Assign(a.FStop);
    FGenre          := a.FGenre;
    FGenreName      := a.FGenreName;
    //FChannel        := a.FChannel;
    FChTv           := a.FChTv;
    FChTvEx         := a.FChTvEx;
    FTitle          := a.FTitle;
    FComment        := a.FComment;
    FRecOverlap     := a.FRecOverlap;
    FRecRdNo        := a.FRecRdNo;
    FExtensionIndex := a.FExtensionIndex;
    FSubTitle       := a.FSubTitle;
    FTalkNo         := a.FTalkNo;
    FTalkMax        := a.FTalkMax;

    FStatus.Assign(a.FStatus);

    FReadTvGuide    := a.FReadTvGuide;
    //FChannelObj := a.FChannelObj;
  end
  else begin
    inherited;
  end;
end;

//**************************************************************************//
//                                                                          //
//  `@f[^ǂݍށ@`                                                //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - True :                                                  //
//                                                                          //
//**************************************************************************//
function TDataTvScheduleItem.DataLoad(t: TStringListEx): Boolean;
var
  t2 : TStringListEx;
begin
  t2 := TStringListEx.Create;
  try
    result    := False;
    FTitle    := t.GetStrs('Title',FTitle);
    GenreStr := t.GetStrs('GenreStr','');
    FGenreName := t.GetStrs('GenreName',FGenreName);
    //Channel   := t.GetInts('Channel',FChannel);
    FChTv     := t.GetInts('ChTv',FChTv);
    FChTvEx   := t.GetInts('ChTvEx',FChTvEx);
    FStart.DataLoad('DateTimeStart',t);
    FStop.DataLoad('DateTimeStop',t);

    FComment        := t.GetStrs('Comment',FComment);
    FExtensionIndex := t.GetInts('ExtensionIndex',FExtensionIndex);
    FSubTitle       := t.GetStrs('SubTitle',FSubTitle);
    FTalkNo         := t.GetInts('TalkNo',FTalkNo);
    FTalkMax        := t.GetInts('TalkMax',FTalkMax);
    FReadTvGuide    := t.GetBools('ReadTvGuide',FReadTvGuide);

    FStatus.DataLoad(t);

    result := True;
  finally
    t2.Free;
  end;
end;

//**************************************************************************//
//                                                                          //
//  `@f[^ށ@`                                                //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - True : I                                             //
//                                                                          //
//**************************************************************************//
function TDataTvScheduleItem.DataSave(t: TStringListEx): Boolean;
var
  t2 : TStringListEx;
begin
  t2 := TStringListEx.Create;
  try
    result := False;
    t.SetStrs('Title',FTitle);
    t.SetStrs('GenreStr',GenreStr);
    t.SetStrs('GenreName',FGenreName);
    //t.SetInts('Channel',FChannel);
    t.SetInts('ChTv',FChTv);
    t.SetInts('ChTvEx',FChTvEx);
    FStart.DataSave('DateTimeStart',t);
    FStop.DataSave('DateTimeStop',t);
    t.SetStrs('Comment',FComment);
    t.SetInts('ExtensionIndex',FExtensionIndex);
    t.SetStrs('SubTitle',FSubTitle);
    t.SetInts('TalkNo',FTalkNo);
    t.SetInts('TalkMax',FTalkMax);
    t.SetBools('ReadTvGuide',FReadTvGuide);

    FStatus.DataSave(t);

    result := True;
  finally
    t2.Free;
  end;
end;

function TDataTvScheduleItem.GetChannelObj: TDataTvChannelItem;
var
  dc : TDataTvChannel;
begin
  result := nil;
  if FOwner = nil then exit;
  dc := TDataTvSchedule(FOwner).Channel;
  if dc = nil then exit;
  result := dc.Items.TvExs[FChTv,FChTvEx];
end;

function TDataTvScheduleItem.GetTimeLength: Integer;
var
  //aHou,aMin,aSec,aMSec : Word;
  d : TDateTimeCtrlRd;
  cnt,aMin : Integer;
begin
  d := TDateTimeCtrlRd.Create;
  aMin := 0;
  try
    result := 0;
    d.Assign(FStart);
    cnt := 24*60;
    while Cnt > 0 do begin                     // ʕ\͈͓Ń[v
      if d.Min <> FStop.Min then begin       // قȂꍇ
        d.IncMin();                       // ܂Ń[v
        Inc(aMin);                             // i߂Z
        Dec(Cnt);
      end
      else if d.Hou <> FStop.Hou then begin  // قȂꍇ
        d.IncHou();                       // ܂Ń[v
        Inc(aMin,60);                          // i߂Z
        Dec(Cnt,60);
      end
      else begin
        break;
      end;
    end;
    result := aMin;
  finally
    d.Free;
  end;
  {
  d := FStop.DataToDateTime - FStart.DataToDateTime;
  DecodeTime(d,aHou,aMin,aSec,aMSec);
  result := aHou * 60 + aMin;
  }
end;

{ TDataTvScheduleItemsEx }

procedure TDataTvScheduleItemsEx.Add(d: TDataTvScheduleItem);
begin
  inherited Add(d);
end;

procedure TDataTvScheduleItemsEx.Extract(d: TDataTvScheduleItem);
begin
  inherited Extract(d);
end;

function TDataTvScheduleItemsEx.GetItems(
  Index: Integer): TDataTvScheduleItem;
begin
  result := inherited Items[Index];
end;


{ TDataTvScheduleItems }

constructor TDataTvScheduleItemsPlus.Create;
begin

  FReadStringList := TStringListEx.Create;

end;

destructor TDataTvScheduleItemsPlus.Destroy;
begin
  Clear();

  FReadStringList.Free;

  inherited;                          // ʂClear邾Ȃ̂ŕsv
end;
{
procedure TDataTvScheduleItems.Assign(a: TDataTvScheduleItems);
var
  i : Integer;
  d : TDataTvScheduleItem;
begin
  Clear;
  for i := 0 to a.Count-1 do begin
    d := TDataTvScheduleItem.Create;
    d.Assign(a.Items[i]);
    d.FOwner := Self;
    Add(d);
  end;

end;
}

//--------------------------------------------------------------------------//
//                                                                          //
//  `@Xgɂsuԑgf[^ǉ@`                                    //
//                                                                          //
//   - Input -  d : ԑgf[^NX                                        //
//                                                                          //
//   - Output - ɎgpNX                                        //
//                                                                          //
//  ԑgf[^łɑ݂ꍇ̂ŕԒl̕Kg            //
//                                                                          //
//--------------------------------------------------------------------------//
function TDataTvScheduleItemsPlus.AddSub(d : TDataTvScheduleItem) : TDataTvScheduleItem;
var
  dt : TDataTvScheduleItem;
  i : Integer;
begin

  i := IndexOfCompari(d);              // łɑ݂f[^`FbN
  if i = -1 then begin                 // ݂Ȃf[^̏ꍇ
    dt := TDataTvScheduleItem.Create;  // ԑgf[^NX𐶐
    dt.Assign(d);                      // NX̑s
    inherited Add(dt);                 // Xgɒǉ
    dt.FOwner := FOwner;
  end
  else begin
    dt := Items[i];
  end;

  result := dt;
  {
  dc := TDataTvSchedule(FOwner).Channel;
  if dc = nil then exit;
  if dt.FChannel < 0 then exit;
  if dt.FChannel >= dc.Items.Count then exit;
  dt.FChannelObj := dc.Items[dt.FChannel];
  }
  dt.ChListAdd();                        // `lf[^NXɗvfƂĒǉ

end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@Xgsuԑgf[^폜@`                                  //
//                                                                          //
//   - Input -  Ȃ                                                        //
//                                                                          //
//   - Output - ɎgpNX                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TDataTvScheduleItemsPlus.DelSub(d: TDataTvScheduleItem);
var
  dc : TDataTvChannel;
begin

  dc := TDataTvSchedule(FOwner).Channel;
  if dc = nil then exit;
  //if d.FChannel < 0 then exit;
  //if d.FChannel >= dc.Items.Count then exit;
  d.ChListDel();                       // `lf[^NX폜
  //d.FChannelObj := nil;
end;

//**************************************************************************//
//                                                                          //
//  `@Xgɂsuԑgf[^ǉ@`                                    //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - ɎgpNX                                        //
//                                                                          //
//   ̊֐ĂԂтɑNX֒ʒmCxg               //
//   xɗvfǉ̂łAdds()gp                         //
//   ǉԑgf[^͕K`lԍZbgĂǉ邱   //
//                                                                          //
//**************************************************************************//
procedure TDataTvScheduleItemsPlus.Add(d : TDataTvScheduleItem;Test : Integer);
var
  ts : TDataTvScheduleItemsEx;
  dt : TDataTvScheduleItem;
  dv : TDataTvSchedule;
begin
  dv := TDataTvSchedule(FOwner);
  dt := AddSub(d);
  ts := TDataTvScheduleItemsEx.Create;
  try
    ts.Add(dt);
    dv.DoDataAdds(ts);
  finally
    ts.Free;
  end;

end;

procedure TDataTvScheduleItemsPlus.Adds(ts : TDataTvScheduleItems;Test : Integer);
var
  i : Integer;
  d,dt : TDataTvScheduleItem;
  dv : TDataTvSchedule;
  ts2 : TDataTvScheduleItemsEx;
begin
  ts2 := TDataTvScheduleItemsEx.Create;
  try
    dv := TDataTvSchedule(FOwner);
    for i := 0 to ts.Count-1 do begin
      d := ts[i];
      dt := AddSub(d);
      ts2.Add(dt);
    end;
    dv.DoDataAdds(ts2);
  finally
    ts2.Free;
  end;

end;


//**************************************************************************//
//                                                                          //
//  `@Xgsuԑgf[^폜@`                              //
//                                                                          //
//   - Input -  i : 폜郊Xgԍ                                      //
//   - Output - Ȃ                                                        //
//                                                                          //
//   ̊֐ĂԂтɑNX֒ʒmCxg               //
//   xɗvfǉ̂łDeletes()DeletesFinish()gp     //
//                                                                          //
//**************************************************************************//
procedure TDataTvScheduleItemsPlus.Delete(i: Integer);
var
  ts : TDataTvScheduleItemsEx;
  d: TDataTvScheduleItem;
  dv : TDataTvSchedule;
begin
  dv := TDataTvSchedule(FOwner);
  ts := TDataTvScheduleItemsEx.Create;
  try
    d := Items[i];
    DelSub(d);
    ts.Add(d);
    dv.DoDataDels(ts);
  finally
    ts.Free;
  end;

  Items[i].Free;                                    //
  inherited;                                        // Xg͍폜
end;

//**************************************************************************//
//                                                                          //
//  `@Xgsuԑgf[^폜@`                              //
//                                                                          //
//   - Input -  d : 폜vf                                            //
//   - Output - Ȃ                                                        //
//                                                                          //
//   ̊֐ĂԂтɑNX֒ʒmCxg               //
//   xɗvfǉ̂łDeletes()DeletesFinish()gp     //
//                                                                          //
//**************************************************************************//
procedure TDataTvScheduleItemsPlus.Delete(d: TDataTvScheduleItem);
var
  i : Integer;
begin
  i := IndexOf(d);
  Delete(i);
end;

//**************************************************************************//
//                                                                          //
//  `@Xgsuԑgf[^폜@`                              //
//                                                                          //
//   - Input -  d : 폜vf                                            //
//   - Output - Ȃ                                                        //
//                                                                          //
//  ̊֐ŗvfǉẴNXɒʒmȂ̂                  //
//  ŌɕKDeletesFinish()ĂԂ                                     //
//                                                                          //
//**************************************************************************//
procedure TDataTvScheduleItemsPlus.Deletes(ts : TDataTvScheduleItemsEx);
var
  i,j : Integer;
  d: TDataTvScheduleItem;
  dv : TDataTvSchedule;
begin
  dv := TDataTvSchedule(FOwner);
  dv.DoDataDels(ts);
  for j := 0 to ts.Count-1 do begin
    d := ts[j];
    d.Free;
    i := IndexOf(d);
    inherited Delete(i);
  end;

end;


//**************************************************************************//
//                                                                          //
//  `@Xgsuԑgf[^Sč폜@`                          //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
procedure TDataTvScheduleItemsPlus.Clear;
var
  i : Integer;
  dv : TDataTvSchedule;
begin
  dv := TDataTvSchedule(FOwner);
  if dv <> nil then begin
    dv.DoDataClr();
  end;
  for i := Count-1 downto 0 do begin           // ݃Xgɂvf[v
    Items[i].Free;                             // suԑgf[^
  end;                                               // FListAdd͑NXւ̒ʒmpȂ̂Ŗ֌W
  inherited;
end;

function TDataTvScheduleItemsPlus.IndexOfCompari(dt: TDataTvScheduleItem): Integer;
var
  i : Integer;
begin
  result := -1;
  for i := 0 to Count-1 do begin
    if Items[i].Compari(dt) then begin
      result := i;
      exit;
    end;
  end;

end;



function TDataTvScheduleItemsPlus.GetItems(Index: Integer): TDataTvScheduleItem;
begin
  result := inherited Items[Index];
end;


procedure TDataTvScheduleItem.ChListAdd;
begin
  if ChannelObj <> nil then begin
    ChannelObj.TvSchedules.Add(Self);
  end;
end;

procedure TDataTvScheduleItem.ChListDel;
var
  i : Integer;
begin
  if ChannelObj <> nil then begin
    i := ChannelObj.TvSchedules.IndexOf(Self);
    if i <> -1 then begin
      ChannelObj.TvSchedules.Delete(i);
    end;
  end;
end;



{ TDataTvSchedule }

//**************************************************************************//
//                                                                          //
//  `@NX@`                                                      //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//  ChannelvpeBɕǂƂėp`lNXQƂ   //
//                                                                          //
//**************************************************************************//
constructor TDataTvSchedule.Create;
begin
  FItems := TDataTvScheduleItemsPlus.Create;
  FItems.FOwner := Self;
  FTimer := TTimer.Create(nil);

  FTimer.OnTimer := OnTimer;
  FTimer.Interval := 500;
  FTimer.Enabled := False;

  FReadStringList := TStringListEx.Create;

  FListAdd := TList.Create;
  FListDel := TList.Create;
  FListChg := TList.Create;

  FOnChangeAdds := TMultiEventSend.Create(nil);
  FOnChangeDels := TMultiEventSend.Create(nil);
  FOnChangeDelAfter := TMultiEventSend.Create(nil);
  FOnChangeClrs := TMultiEventSend.Create(nil);
  FOnChanges := TMultiEventSend.Create(nil);

  FOnDataAdds := TMultiEventSend.Create(nil);
  FOnDataDels := TMultiEventSend.Create(nil);
  FOnDataClr  := TMultiEventSend.Create(nil);
end;

destructor TDataTvSchedule.Destroy;
begin
  FTimer.Enabled := False;
  {
  if not FReadBusy then begin          // ǂݍݒł͂Ȃꍇ
    if FDataChanged then begin         // f[^ɕύXꍇ
      //DataSave();                      // f[^ۑ
    end;
  end;
  }
  FItems.Clear();
  FItems.FOwner := nil;

  FTimer.Free;
  FReadStringList.Free;

  FOnDataClr.Free;
  FOnDataDels.Free;
  FOnDataAdds.Free;

  FOnChanges.Free;
  FOnChangeClrs.Free;
  FOnChangeDelAfter.Free;
  FOnChangeDels.Free;
  FOnChangeAdds.Free;

  FListChg.Clear();
  FListChg.Free;
  FListDel.Clear();
  FListDel.Free;
  FListAdd.Clear();
  FListAdd.Free;
  FItems.Free;
  inherited;
end;

//**************************************************************************//
//                                                                          //
//  `@ł̓ǂݍݏĊJ@`                                    //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
procedure TDataTvSchedule.BgLoadReStart;
begin
  FTimer.Enabled := FReadBusy;
end;

//**************************************************************************//
//                                                                          //
//  `@ł̓ǂݍݏꎞ~@`                                //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
procedure TDataTvSchedule.BgLoadStop;
begin
  FTimer.Enabled := False;
end;

function TDataTvSchedule.DataLoad(t: TStringListEx): Boolean;
var
  v : Integer;
  f : Boolean;
begin
  result := False;
  if t =nil then exit;
  
  FReadStringList.Assign(t);
  v := t.GetInt();                            // f[^t@C̃o[W擾
  if v <> TvGuideSaveDataVersion then begin   // ݂̃o[WƈقȂꍇ
    exit;                                     // Ȃ
  end;
  FReadCount := 1;                            // QsڂǂݍނƂw
  FReadBusy := True;                          // ǂݍݒtOZbg
  f := DataLoadTimerProc();
  if not f then begin
    FTimer.Enabled := True;
  end;
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@xǂݍݗp^C}[Cxg@`                                  //
//                                                                          //
//   - Input -  Sender : suԑgf[^NX                               //
//              Arg    : 폜\̂suԑgf[^Xg                     //
//                                                                          //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
function TDataTvSchedule.DataLoadTimerProc: Boolean;
var
  t : TStringListEx;
  ts : TDataTvScheduleItems;
  i : Integer;
  d : TDataTvScheduleItem;
begin
  result := False;
  t := TStringListEx.Create;
  ts := TDataTvScheduleItems.Create;
  //FListAdd.Clear;
  try
    for i := FReadCount to FReadCount+100 do begin    // w肳ꂽ
      if i >= FReadStringList.Count then begin        // Ō܂œǂݍ񂾏ꍇ
        FReadBusy := False;                           // ǂݍݒtOZbg
        FReadStringList.Clear();                      // Ɨp̃obt@
        result := True;
        break;
      end;
      t.CommaTextEx := FReadStringList[i];            // Po
      d := TDataTvScheduleItem.Create;
      d.DataLoad(t);                                  // t@C̓e
      ts.Add(d);                                      // vfǉił܂Ƃ߂Ēʒmj
    end;
    FReadCount := i;                                  // ǂݍ݈ʒuXV
    FItems.Adds(ts,0);
  finally
    ts.Free;
    t.Free;
  end;
end;

function TDataTvSchedule.DataSave(t: TStringListEx): Boolean;
var
  t2 : TStringListEx;
  i : Integer;
begin
  //Sort();
  DeleteOldData(DM.Config.Normal.OldDay);         // Âf[^
  t2 := TStringListEx.Create;
  try
    result := False;
    t.Clear;
    t.SetInt(TvGuideSaveDataVersion);
    //t.SetInt(FLastNo);
    for i := 0 to FItems.Count-1 do begin
      t2.Clear;
      Items[i].DataSave(t2);
      t.Add(t2.CommaTextEx);
    end;
    //t.SaveToFile(GetFileName);
    result := True;
  finally
    t2.Free;
  end;
end;


//--------------------------------------------------------------------------//
//                                                                          //
//  `@ÂĕKv̂Ȃf[^폜  `                                //
//                                                                          //
//   - Input -  OldDayCnt : ߋ܂ŕۑ̂w              //
//   - Output - Ȃ                                                        //
//                                                                          //
//--------------------------------------------------------------------------//
procedure TDataTvSchedule.DeleteOldData(const OldDayCnt : Integer);
var
  dd : TDateTimeCtrl;
  dt : TDataTvScheduleItem;
  i : Integer;
begin
  dd := TDateTimeCtrl.Create;
  try
    dd.DateTime := Now;
    dd.DecDay(OldDayCnt);        // ߋ܂ŕۑ̂H
    for i := FItems.Count-1 downto 0 do begin
      dt := FItems[i];
      if dt.Start.Compari(dd) < 0 then begin
        FItems.Delete(i);
      end;
    end;


  finally
    dd.Free;
  end;

end;

procedure TDataTvSchedule.OnTimer(Sender: TObject);
var
  f : Boolean;
begin
  FTimer.Enabled := False;
  f := DataLoadTimerProc();
  if not f then begin
    FTimer.Enabled := True;
  end;
end;

procedure TDataTvSchedule.DoDataAdds(ts: TDataTvScheduleItemsEx);
begin
  FOnDataAdds.Notify(ts);
end;

procedure TDataTvSchedule.DoDataClr;
begin
  FOnDataClr.Notify(nil);
end;

procedure TDataTvSchedule.DoDataDels(ts: TDataTvScheduleItemsEx);
begin
  FOnDataDels.Notify(ts);
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@ǁAԂꂩׂ@`                                      //
//                                                                          //
//   - Input -  d : ԑgf[^NX                                        //
//                                                                          //
//   - Output - True : ǂ̓ꎞԑ                               //
//                                                                          //
//  ̔ԑg񂩂瓯ԑg擾ꍇÅ֐Œׂ            //
//                                                                          //
//--------------------------------------------------------------------------//
function TDataTvScheduleItem.Compari(dt: TDataTvScheduleItem): Boolean;
begin
  result := False;

  //if FChannel <> dt.FChannel then exit;         // ǂقȂꍇ
  if FChTv <> dt.FChTv then exit;         // ǂقȂꍇ
  if FChTvEx <> dt.FChTvEx then exit;         // ǂقȂꍇ

  if (FStart.Compari(dt.FStart) <= 0) and
     (FStop.Compari(dt.FStart) > 0) then begin  // ̔ԑg̊JnɏdȂf[^ꍇ
    result := True;
    exit;
  end;
  if (FStart.Compari(dt.FStop) <= 0) and        // ̔ԑg̏IɏdȂf[^ꍇ
     (FStop.Compari(dt.FStop) > 0) then begin
    result := True;
    exit;
  end;

end;

{ TDataTvScheduleItems }

destructor TDataTvScheduleItems.Destroy;
begin
  Clear();
  inherited;
end;

procedure TDataTvScheduleItems.Add(d: TDataTvScheduleItem);
begin
  inherited Add(d);
end;

procedure TDataTvScheduleItems.Adds(ts: TDataTvScheduleItems);
var
  i : Integer;
  dt : TDataTvScheduleItem;
begin
  for i := 0 to ts.Count-1 do begin
    dt := ts[i];
    Add(dt);
  end;

end;

procedure TDataTvScheduleItems.Clear;
var
  i : Integer;
begin
  for i := 0 to Count-1 do begin
    Items[i].Free;
  end;
  inherited;
end;

procedure TDataTvScheduleItems.Delete(i: Integer);
begin
  Items[i].Free;
  inherited;
end;

procedure TDataTvScheduleItems.Delete(d: TDataTvScheduleItem);
var
  i : Integer;
begin
  i := IndexOf(d);
  if i = -1 then exit;
  Delete(i);
end;

function TDataTvScheduleItems.GetItems(
  Index: Integer): TDataTvScheduleItem;
begin
  result := inherited Items[Index];
end;

function TDataTvScheduleItem.GetGenreStr: string;
begin
  result := TvScheduleGenreToStr(FGenre);
end;

procedure TDataTvScheduleItem.SetGenreStr(const Value: string);
begin
  FGenre := StrToTvScheduleGenre(Value);
end;


end.
