unit DataTvColumn;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,ExtCtrls,DefaultData,StringListEx,StringListKey;

//--------------------------------------------------------------------------//
//  ԑg\̕\ڂǗf[^NX                                  //
//--------------------------------------------------------------------------//
type
  TDataTvColumnItem = class(TPersistent)
  private
    { Private 錾 }
    FWidth: Integer;
    FMode: Integer;
    FCaption: string;
    FComment: string;
    function DataLoad(t : TStringListEx) : Boolean;
    function DataLoadDef(t : TStringListEx) : Boolean;
    function DataSave(t : TStringListEx) : Boolean;
  public
    { Public 錾 }
    procedure Assign(Source : TPersistent) ; override;

    property Caption : string read FCaption;
    property Comment : string read FComment;
    property Mode : Integer read FMode;
    property Width : Integer read FWidth write FWidth;
  end;

//--------------------------------------------------------------------------//
//  ԑg\̕\ڂǗ郊XgNX                                  //
//--------------------------------------------------------------------------//
type
  TDataTvColumnItems = class(TList)
  private
    { Private 錾 }
    function GetItems(Index: Integer): TDataTvColumnItem;
  public
    { Public 錾 }
    destructor Destroy;override;
    function Add() : TDataTvColumnItem;
    procedure Delete(i : Integer);
    procedure Clear();override;
    property Items[Index: Integer] : TDataTvColumnItem read GetItems;default;
    procedure Assign(a : TDataTvColumnItems);

  end;

//--------------------------------------------------------------------------//
//  ԑg\̕\ڂǗf[^NX                                  //
//--------------------------------------------------------------------------//
type
  TDataTvColumn = class(TPersistent)
  private
    { Private 錾 }
    FColumns : TDataTvColumnItems;
    FListFontSize : Integer;
  public
    { Public 錾 }
    constructor Create;
    destructor Destroy;override;

    procedure Assign(Source : TPersistent) ; override;

    function DataLoad(tk : TStringListKey) : Boolean;
    function DataSave(tk : TStringListKey) : Boolean;

    property Columns : TDataTvColumnItems read FColumns;
    property ListFontSize : Integer read FListFontSize write FListFontSize;
  end;


implementation

{ TDataListViewTv }

constructor TDataTvColumn.Create;
begin
  FColumns := TDataTvColumnItems.Create;
  FListFontSize := 12;
end;

destructor TDataTvColumn.Destroy;
begin
  FColumns.Free;
  inherited;
end;

function TDataTvColumn.DataLoad(tk : TStringListKey): Boolean;
var
  t,t2 : TStringListEx;
  i : Integer;
  d : TDataTvColumnItem;
begin
  if tk = nil then exit;
  t := tk.Values['TvColumn'];
  t2 := TStringListEx.Create;
  try
    FColumns.Clear;
    for i := 0 to t.Count-1 do begin
      d := FColumns.Add();
      t2.CommaTextEx := t[i];
      d.DataLoadDef(t2);
    end;
    result := True;
  finally
    t2.Free;
  end;
end;

function TDataTvColumn.DataSave(tk : TStringListKey): Boolean;
var
  t,t2 : TStringListEx;
  i : Integer;
  d : TDataTvColumnItem;
begin
  t := TStringListEx.Create;
  t2 := TStringListEx.Create;
  try
    result := False;
    for i := 0 to FColumns.Count-1 do begin
      d := FColumns.Items[i];
      t2.Clear;
      d.DataSave(t2);
      t.Add(t2.CommaTextEx);
    end;
    tk.Add('TvColumn',t);
    result := True;
  finally
    t2.Free;
    t.Free;
  end;

end;

procedure TDataTvColumn.Assign(Source: TPersistent);
var
  a : TDataTvColumn;
begin
  if Source is TDataTvColumn then begin
    a := TDataTvColumn(Source);
    FColumns.Assign(a.FColumns);
    FListFontSize := a.FListFontSize;
  end
  else begin
    inherited;
  end;
end;


{ TDataListViewTvColumnItems }

procedure TDataTvColumnItems.Delete(i: Integer);
begin
  Items[i].Free;
  inherited;
end;

function TDataTvColumnItems.Add: TDataTvColumnItem;
var
  d : TDataTvColumnItem;
begin
  d := TDataTvColumnItem.Create;
  inherited Add(d);
  result := d;
end;

procedure TDataTvColumnItems.Assign(a: TDataTvColumnItems);
var
  i : Integer;
  d : TDataTvColumnItem;
begin
  Clear();
  for i := 0 to a.Count-1 do begin
    d := Add();
    d.Assign(a[i]);
  end;
end;

procedure TDataTvColumnItems.Clear;
var
  i : Integer;
begin
  for i := 0 to Count-1 do begin
    Items[i].Free;
  end;
  inherited;
end;


//**************************************************************************//
//                                                                          //
//  `@NXjCxg@`                                              //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
destructor TDataTvColumnItems.Destroy;
begin
  Clear();
  inherited;
end;

function TDataTvColumnItems.GetItems(Index: Integer): TDataTvColumnItem;
begin
  result := inherited Items[Index];
end;


{ TDataListViewTvColumnItem }

procedure TDataTvColumnItem.Assign(Source: TPersistent);
var
  a : TDataTvColumnItem;
begin
  if Source is TDataTvColumnItem then begin
    a := TDataTvColumnItem(Source);
    FComment := a.FComment;
    FCaption := a.FCaption;
    FMode := a.FMode;
    FWidth := a.FWidth;
  end
  else begin
    inherited;
  end;
end;

function TDataTvColumnItem.DataLoad(t: TStringListEx): Boolean;
begin
  FComment := t.GetStrs('Comment',FComment);
  FCaption := t.GetStrs('Caption',FCaption);
  FMode := t.GetInts('Mode',FMode);
  FWidth := t.GetInts('Width',FWidth);
  result := True;
end;

function TDataTvColumnItem.DataLoadDef(t: TStringListEx): Boolean;
begin
  FComment := t.GetStr();
  FCaption := t.GetStr();
  FMode := t.GetInt();
  FWidth := t.GetInt();
  result := True;
end;

function TDataTvColumnItem.DataSave(t: TStringListEx): Boolean;
begin
  t.SetStrs('Comment',FComment);
  t.SetStrs('Caption',FCaption);
  t.SetInts('Mode',FMode);
  t.SetInts('Width',FWidth);
  result := True;
end;


end.
