unit DataTvChannel;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,StringListEx,StringListKey,MultiEvent;

const
  ConfigDataVersion = 3;             // ݒۑ̃o[Wԍ

 // M̌n\B
type
  TTvChannelStatusMode = (cmNormal,cmCsAnalog,cmCsDigital,cmBsDigital,cmCATV);
const
  TTvChannelStatusTbl :array[0..4] of string = ('ng^BSAiO','SkyPerfecTV!','SkyPerfecTV!110','BSfW^','b`su');


//--------------------------------------------------------------------------//
//  `lf[^NX                                                  //
//--------------------------------------------------------------------------//
type
  TDataTvChannelItem = class(TPersistent)
  private
    { Private 錾 }                 // ϐ𑝂₷ƂAssign,CheckEqualɔf邱
    FOwner : TObject;                // ̃`l̔ԑgXg
    FTvSchedules : TList;            // ̃`lgpĂԑgf[^ꗗ
    FName: string;                   // `l
    FChannelTv: Integer;             // TVԑg\Ŏgp`lԍ
    FVisible: Boolean;               // `lgp邩ۂ
    FPageNo : Integer;               // TVԑg\ł̃y[Wԍ
    FMode : TTvChannelStatusMode;    // 0 : ng 1``l
    FAdrNo : string;                 // nR[h
    FExtensionIndex: Integer;        // -1ȊO:̌ƂȂf[^ԍiۑj

    FExtended: Boolean;              // True : \iۑj
    FExtendTime: Integer;            // Z镪
    FChannelEx: Integer;             // CS,BSȂǂŎgp鋤ʃ`lԍi-1:j
    FUseTvGuide: Boolean;            // True : ʏ̔ԑg\擾\
    FUseCsAnalog: Boolean;           // True : SkyPerfectTv擾\
    FUseCsDigital: Boolean;          // True : SkyPerfectTv2擾\
    FBsAnalog : Boolean;             // True : BSAiO
    FIndexNo: Integer;
    FGenreName: string;
    FUseBsDigital: Boolean;              // p`lȂǂ̃W
    procedure AssignOnTvJapan(a : TDataTvChannelItem);
    procedure AssignSkyPerfectTv(a : TDataTvChannelItem);
    procedure AssignSkyPerfectTv110(a : TDataTvChannelItem);
  public
    { Public 錾 }
    constructor Create;
    destructor Destroy;override;
    procedure Assign(Source : TPersistent) ; override;
    function DataLoad(t : TStringListEx) : Boolean;
    function DataSave(t : TStringListEx) : Boolean;

    function CheckEqual(a : TDataTvChannelItem) : Boolean;
    function CheckSkyPerfect110(a : TDataTvChannelItem) : Boolean;
    function CheckChEx(a : TDataTvChannelItem) : Boolean;
    function CheckAdrPage(a : TDataTvChannelItem) : Boolean;
    procedure AssignEx(a : TDataTvChannelItem;aMode : TTvChannelStatusMode);

    property Name : string read FName write FName;
    //property Channel : Integer read FChannel write FChannel;
    property ChannelTv : Integer read FChannelTv write FChannelTv;
    property Visible : Boolean read FVisible write FVisible;
    property PageNo : Integer read FPageNo write FPageNo;
    property Mode : TTvChannelStatusMode read FMode write FMode;
    property AdrNo : string read FAdrNo write FAdrNo;
    property ExtensionIndex : Integer read FExtensionIndex write FExtensionIndex;
    property Extended : Boolean read FExtended write FExtended;
    property ExtendTime : Integer read FExtendTime write FExtendTime;
    property ChannelEx : Integer read FChannelEx write FChannelEx;
    property UseTvGuide : Boolean read FUseTvGuide write FUseTvGuide;
    property UseCsAnalog : Boolean read FUseCsAnalog write FUseCsAnalog;
    property UseCsDigital : Boolean read FUseCsDigital write FUseCsDigital;
    property UseBsDigital : Boolean read FUseBsDigital write FUseBsDigital;
    property GenreName  : string read FGenreName write FGenreName;
    property IndexNo : Integer read FIndexNo write FIndexNo;
    property BsAnalog : Boolean read FBsAnalog write FBsAnalog;
    property TvSchedules : TList read FTvSchedules;
  end;

//--------------------------------------------------------------------------//
//  `lf[^XgǗNX                                        //
//--------------------------------------------------------------------------//
type
  TDataTvChannelItems = class(TList)
  private
    { Private 錾 }
    FOnChanges: TMultiEventSend;
    procedure DoChange();
    function GetItems(Index: Integer): TDataTvChannelItem;
    function GetTvExs(Tv, Ex: Integer): TDataTvChannelItem;


  public
    { Public 錾 }
    constructor Create;
    destructor Destroy;override;
    procedure Assign(Source : TDataTvChannelItems);
    procedure Sort();
    function Add() : TDataTvChannelItem;
    procedure Delete(i : Integer);
    procedure Clear();override;

    procedure AssignOnTvJapan(a : TDataTvChannelItems);
    procedure AssignSkyPerfectTv110(a : TDataTvChannelItems);
    procedure AssignSkyPerfectTv(a : TDataTvChannelItems);

    function IndexOfOnTvJapan(dc : TDataTvChannelItem;aMode : TTvChannelStatusMode) : Integer;
    function IndexOfSkyPerfectTv(dc : TDataTvChannelItem) : Integer;
    function IndexOfSkyPerfectTv110(d : TDataTvChannelItem) : Integer;

    function IndexOfTvEx(d : TDataTvChannelItem) : Integer;
    function IndexOfAdrPage(d : TDataTvChannelItem) : Integer;

    property TvExs[Tv,Ex : Integer] : TDataTvChannelItem read GetTvExs;

    property Items[Index: Integer] : TDataTvChannelItem read GetItems;default;

  end;

//--------------------------------------------------------------------------//
//  `lf[^ǗNX                                              //
//--------------------------------------------------------------------------//
type
  TDataTvChannel = class(TPersistent)
  private
    { Private 錾 }
    FItems : TDataTvChannelItems;               // `lf[^ꗗ
    FOnChanges: TMultiEventSend;
    procedure DoChange();
  public
    { Public 錾 }
    constructor Create();
    destructor Destroy;override;

    procedure Assign(Source : TPersistent) ; override;

    procedure AssignEx(Source : TDataTvChannelItems;aMode : TTvChannelStatusMode);
    function IndexOfEx(aChannelEx : Integer) : Integer;
    function CheckEqual(a : TDataTvChannelItems) : Boolean;
    function GetEqual(d : TDataTvChannelItem) : TDataTvChannelItem;
    function GetChannelEx(Channel : Integer;Mode : TTvChannelStatusMode): TDataTvChannelItem;
    function GetChannelEqual(a : TDataTvChannelItem): TDataTvChannelItem;

    function DataLoad(tt : TStringListKey) : Boolean;
    function DataSave(tk: TStringListKey) : Boolean;
    function DataCheck(var Msg : string) : Boolean;

    procedure ExtensionReset();

    property Items : TDataTvChannelItems read FItems;

    property OnChanges : TMultiEventSend read FOnChanges write FOnChanges;
  end;

implementation

{ TConfigChannelItems }

//**************************************************************************//
//                                                                          //
//  `@NXCxg@`                                              //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
constructor TDataTvChannelItems.Create;
begin
  FOnChanges := TMultiEventSend.Create(nil);
end;

//**************************************************************************//
//                                                                          //
//  `@NXjCxg@`                                              //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
destructor TDataTvChannelItems.Destroy;
begin
  Clear();
  FOnChanges.Free;
  inherited;
end;

function TDataTvChannelItems.Add: TDataTvChannelItem;
var
  d : TDataTvChannelItem;
begin
  d := TDataTvChannelItem.Create;
  inherited Add(d);
  result := d;
  d.FOwner := Self;
end;

//**************************************************************************//
//                                                                          //
//  `@NX@`                                                  //
//                                                                          //
//   - Input -  Source :                                              //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
procedure TDataTvChannelItems.Assign(Source: TDataTvChannelItems);
var
  a : TDataTvChannelItems;
  d : TDataTvChannelItem;
  i : Integer;
begin
  if Source is TDataTvChannelItems then begin
    a := TDataTvChannelItems(Source);
    Clear;
    for i := 0 to a.Count-1 do begin
      d := Add();
      d.Assign(a.Items[i]);
    end;
    DoChange();
  end
  else begin
    inherited Assign(Source);
  end;
end;

procedure TDataTvChannelItems.AssignOnTvJapan(
  a: TDataTvChannelItems);
var
  i,j : Integer;
  d : TDataTvChannelItem;
begin
  for j := 0 to a.Count-1 do begin
    i := IndexOfOnTvJapan(a.Items[j],a.Items[j].FMode);
    if i = -1 then begin
      d := Add();
      d.Assign(a.Items[j]);
    end
    else begin
      Items[i].AssignOnTvJapan(a.Items[j]);
    end;
  end;
end;

procedure TDataTvChannelItems.AssignSkyPerfectTv(
  a: TDataTvChannelItems);
var
  i,j : Integer;
  d : TDataTvChannelItem;
begin
  for j := 0 to a.Count-1 do begin
    i := IndexOfSkyPerfectTv(a.Items[j]);
    if i = -1 then begin
      d := Add();
      d.Assign(a.Items[j]);
    end
    else begin
      Items[i].AssignSkyPerfectTv(a.Items[j]);
    end;
  end;

end;


procedure TDataTvChannelItems.AssignSkyPerfectTv110(
  a: TDataTvChannelItems);
var
  i,j : Integer;
  d : TDataTvChannelItem;
begin
  for j := 0 to a.Count-1 do begin
    i := IndexOfSkyPerfectTv110(a.Items[j]);
    if i = -1 then begin
      d := Add();
      d.Assign(a.Items[j]);
    end
    else begin
      Items[i].AssignSkyPerfectTv110(a.Items[j]);
    end;
  end;

end;


procedure TDataTvChannelItems.Clear;
var
  i : Integer;
begin
  for i := 0 to Count-1 do begin
    Items[i].Free;
  end;
  inherited;
end;


procedure TDataTvChannelItems.Delete(i: Integer);
begin
  Items[i].Free;
  inherited;
end;

function TDataTvChannelItems.IndexOfTvEx(
  d: TDataTvChannelItem): Integer;
var
  d2 : TDataTvChannelItem;
  i : Integer;
begin
  result := -1;
  for i := 0 to Count-1 do begin
    d2 := Items[i];
    if d2.CheckChEx(d) then begin
      result := i;
      exit;
    end;
  end;

end;

function TDataTvChannelItems.IndexOfOnTvJapan(
  dc: TDataTvChannelItem;aMode : TTvChannelStatusMode): Integer;
var
  d : TDataTvChannelItem;
  i : Integer;
begin
  result := -1;
  for i := 0 to Count-1 do begin
    d := Items[i];
    if d.FMode <> aMode then continue;
    if d.ChannelEx = dc.ChannelEx then begin
      result := i;
      exit;
    end;
  end;
end;

function TDataTvChannelItems.IndexOfSkyPerfectTv(
  dc: TDataTvChannelItem): Integer;
var
  d : TDataTvChannelItem;
  i : Integer;
begin
  result := -1;
  for i := 0 to Count-1 do begin
    d := Items[i];
    //if not d.UseCsAnalog then continue;
    if d.Mode <> cmCsAnalog then continue;
    if d.ChannelEx = dc.ChannelEx then begin
      result := i;
      exit;
    end;
  end;
end;

function TDataTvChannelItems.IndexOfAdrPage(
  d: TDataTvChannelItem): Integer;
var
  d2 : TDataTvChannelItem;
  i : Integer;
begin
  result := -1;
  for i := 0 to Count-1 do begin
    d2 := Items[i];
    if d2.CheckAdrPage(d) then begin
      result := i;
      exit;
    end;
  end;
end;

function TDataTvChannelItems.IndexOfSkyPerfectTv110(
  d: TDataTvChannelItem): Integer;
var
  d2 : TDataTvChannelItem;
  i : Integer;
begin
  result := -1;
  for i := 0 to Count-1 do begin
    d2 := Items[i];
    if d.Mode <> cmCsDigital then continue;
    if d2.CheckSkyPerfect110(d) then begin
      result := i;
      exit;
    end;
  end;
end;

function TDataTvChannelItems.GetItems(Index: Integer): TDataTvChannelItem;
begin
  result := inherited Items[Index];
end;

function TDataTvChannelItems.GetTvExs(Tv,
  Ex: Integer): TDataTvChannelItem;
var
  i : Integer;
  d : TDataTvChannelItem;
begin
  result := nil;
  for i := 0 to Count-1 do begin
    d := Items[i];
    if (d.ChannelTv = Tv) and
       (d.ChannelEx = Ex) then begin
      result := d;
      exit;
    end;
  end;
  {
  result := nil;
  if Tv <> 0 then begin
    for i := 0 to Count-1 do begin
      d := Items[i];
      if d.ChannelTv = Tv then begin
        result := d;
        exit;
      end;
    end;
  end
  else begin
    for i := 0 to Count-1 do begin
      d := Items[i];
      if d.ChannelEx = Ex then begin
        result := d;
        exit;
      end;
    end;
  end;
  }
end;

{ TConfigChannelItem }

//**************************************************************************//
//                                                                          //
//  `@NXCxg@`                                              //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
constructor TDataTvChannelItem.Create;
begin
  FTvSchedules := TList.Create;
  FExtensionIndex := -1;
  FExtendTime := 30;
end;

destructor TDataTvChannelItem.Destroy;
begin
  FTvSchedules.Clear;
  FTvSchedules.Free;
  inherited;
end;

//**************************************************************************//
//                                                                          //
//  `@NX@`                                                  //
//                                                                          //
//   - Input -  Source :                                              //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
procedure TDataTvChannelItem.Assign(Source: TPersistent);
var
  a : TDataTvChannelItem;
begin
  if Source is TDataTvChannelItem then begin
    a := TDataTvChannelItem(Source);
    FName         := a.FName;
    FChannelTv    := a.FChannelTv;
    FVisible      := a.FVisible;
    FPageNo       := a.FPageNo;
    FMode         := a.FMode;
    FAdrNo        := a.FAdrNo;
    FExtendTime   := a.FExtendTime;
    FChannelEx    := a.FChannelEx;
    FUseTvGuide   := a.FUseTvGuide;
    FUseCsAnalog  := a.FUseCsAnalog;
    FUseCsDigital := a.FUseCsDigital;
    FUseBsDigital := a.FUseBsDigital;
    FGenreName    := a.FGenreName;
    FBsAnalog     := a.FBsAnalog;
  end
  else begin
    inherited;
  end;
end;

//**************************************************************************//
//                                                                          //
//  `@NXi擾TCgʁj@`                              //
//                                                                          //
//   - Input -  Source :                                              //
//                                                                          //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
procedure TDataTvChannelItem.AssignEx(a: TDataTvChannelItem;
  aMode: TTvChannelStatusMode);
begin
  case aMode of
    cmNormal :    begin
                    FName         := a.FName;
                    FChannelTv    := a.FChannelTv;
                    FPageNo       := a.FPageNo;
                    FMode         := a.FMode;
                    FAdrNo        := a.FAdrNo;
                    FChannelEx    := a.FChannelEx;
                    FUseTvGuide   := True;
                    if FGenreName = '' then FGenreName    := a.FGenreName;
                    FBsAnalog := False;
                    case FChannelTv of
                      3,14,17: FBsAnalog := True;
                    end;

                  end;
    cmCsAnalog :  begin
                    FName         := a.FName;
                    FChannelEx    := a.FChannelEx;
                    FUseCsAnalog  := True;
                    FMode         := a.FMode;
                    FGenreName    := a.FGenreName;
                  end;
    cmCsDigital : begin
                    FName         := a.FName;
                    FChannelEx    := a.FChannelEx;
                    FUseCsDigital := True;
                    FMode         := a.FMode;
                    FGenreName    := a.FGenreName;
                  end;
  end;

end;

procedure TDataTvChannelItem.AssignOnTvJapan(
  a: TDataTvChannelItem);
begin
  //FName         := a.FName;
  FChannelEx    := a.FChannelEx;
  FChannelTv    := a.FChannelTv;
  FAdrNo        := a.FAdrNo;
  FPageNo       := a.FPageNo;
  FUseTvGuide   := True;
  FMode         := a.FMode;
end;

procedure TDataTvChannelItem.AssignSkyPerfectTv(
  a: TDataTvChannelItem);
begin
  FName         := a.FName;
  FChannelEx    := a.FChannelEx;
  FUseCsAnalog  := True;
  FGenreName    := a.FGenreName;
  FMode         := cmCsAnalog;
end;

procedure TDataTvChannelItem.AssignSkyPerfectTv110(
  a: TDataTvChannelItem);
begin
  FName         := a.FName;
  FChannelEx    := a.FChannelEx;
  FUseCsDigital := True;
  FGenreName    := a.FGenreName;
  FMode         := cmCsDigital;
end;

//**************************************************************************//
//                                                                          //
//  `@w肳ꂽf[^ƑSĈv邩@`                            //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - True : SĈv                                             //
//                                                                          //
//**************************************************************************//
function TDataTvChannelItem.CheckEqual(a: TDataTvChannelItem): Boolean;
begin
  result := False;
  if FName         <> a.FName         then exit;
  if FChannelTv    <> a.FChannelTv    then exit;
  if FVisible      <> a.FVisible      then exit;
  if FPageNo       <> a.FPageNo       then exit;
  if FMode         <> a.FMode         then exit;
  if FAdrNo        <> a.FAdrNo        then exit;
  if FExtendTime   <> a.FExtendTime   then exit;
  if FChannelEx    <> a.FChannelEx    then exit;
  if FUseTvGuide   <> a.FUseTvGuide   then exit;
  if FUseCsAnalog  <> a.FUseCsAnalog  then exit;
  if FUseCsDigital <> a.FUseCsDigital then exit;
  if FUseBsDigital <> a.FUseBsDigital then exit;
  if FGenreName    <> a.FGenreName    then exit;
  if FBsAnalog     <> a.FBsAnalog     then exit;
  result := True;
end;

function TDataTvChannelItem.CheckSkyPerfect110(
  a: TDataTvChannelItem): Boolean;
begin
  result := False;
  if FMode <> cmCsDigital then exit;
  if FChannelEx <> a.FChannelEx then exit;
  result := True;
end;

function TDataTvChannelItem.CheckChEx(a: TDataTvChannelItem): Boolean;
begin
  result := False;
  if FChannelTv <> a.FChannelTv then exit;
  if FChannelEx <> a.FChannelEx then exit;
  result := True;
end;

function TDataTvChannelItem.CheckAdrPage(
  a: TDataTvChannelItem): Boolean;
begin
  result := False;
  if FAdrNo <> a.FAdrNo then exit;
  if FPageNo <> a.FPageNo then exit;
  result := True;
end;

//**************************************************************************//
//                                                                          //
//  `@f[^ǂݍ݁@`                                                  //
//                                                                          //
//   - Input -  t : f[^ǂݍޕ񃊃Xg                            //
//                                                                          //
//   - Output - True :                                                  //
//                                                                          //
//**************************************************************************//
function TDataTvChannelItem.DataLoad(t: TStringListEx): Boolean;
begin
  //result := False;
  FName         := t.GetStrs('Name',FName);
  FChannelTv    := t.GetInts('ChannelTv',FChannelTv);
  FVisible      := t.GetBools('Visible',FVisible);
  FPageNo       := t.GetInts('PageNo',FPageNo);
  FMode         := TTvChannelStatusMode(t.GetInts('Mode',Integer(FMode)));
  FAdrNo        := t.GetStrs('AdrNo',FAdrNo);
  FExtendTime   := t.GetInts('ExtendTime',FExtendTime);
  FChannelEx    := t.GetInts('ChannelEx',FChannelEx);
  FUseTvGuide   := t.GetBools('UseTvGuide',FUseTvGuide);
  FUseBsDigital := t.GetBools('UseBsDigital',FUseBsDigital);
  FUseCsAnalog  := t.GetBools('UseCsAnalog',FUseCsAnalog);
  FUseCsDigital := t.GetBools('UseCsDigital',FUseCsDigital);
  FGenreName    := t.GetStrs('GenreName',FGenreName);
  FBsAnalog     := t.GetBools('BsAnalog',FBsAnalog);
  result := True;
end;

//**************************************************************************//
//                                                                          //
//  `@f[^݁@`                                                  //
//                                                                          //
//   - Input -  t : f[^ޕ񃊃Xg                            //
//                                                                          //
//   - Output - True :                                                  //
//                                                                          //
//**************************************************************************//
function TDataTvChannelItem.DataSave(t: TStringListEx): Boolean;
begin
  t.SetStrs('Name',FName);
  t.SetInts('ChannelTv',FChannelTv);
  t.SetBools('Visible',FVisible);
  t.SetInts('PageNo',FPageNo);
  t.SetInts('Mode',Ord(FMode));
  t.SetStrs('AdrNo',FAdrNo);
  t.SetInts('ExtendTime',FExtendTime);
  t.SetInts('ChannelEx',FChannelEx);
  t.SetBools('UseTvGuide',FUseTvGuide);
  t.SetBools('UseBsDigital',FUseBsDigital);
  t.SetBools('UseCsAnalog',FUseCsAnalog);
  t.SetBools('UseCsDigital',FUseCsDigital);
  t.SetStrs('GenreName',FGenreName);
  t.SetBools('BsAnalog',FBsAnalog);
  result := True;
end;

// 錾ȂɂȂ菑Ă_ɒ
// Ԓl@Item1 < Item2̂Ƃ|Pȉ
//     @Item1 = Item2̂Ƃ@O
//     @Item1 > Item2̂Ƃ@Pȏ
function Compare(Item1, Item2: Pointer): Integer;
const
  Tbl : array[0..3] of Integer= (0,2,3,1);
var
  d1,d2 : TDataTvChannelItem;
begin
  d1 := Item1;
  d2 := Item2;
  result := Tbl[Ord(d1.Mode)] - Tbl[Ord(d2.Mode)];
  if result = 0 then begin
    result := d1.IndexNo - d2.IndexNo;
  end;
end;

//**************************************************************************//
//                                                                          //
//  `@\[g@`                                                      //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
procedure TDataTvChannelItems.Sort;
var
  i : Integer;
begin
  for i := 0 to Count-1 do begin
    Items[i].IndexNo := i;
  end;

  inherited Sort(@Compare);
end;

procedure TDataTvChannelItems.DoChange;
begin
  FOnChanges.Notify(Self);
end;


{ TDataTvScheduleChannel }

constructor TDataTvChannel.Create;
begin
  FItems := TDataTvChannelItems.Create;
  FOnChanges := TMultiEventSend.Create(nil);
end;

destructor TDataTvChannel.Destroy;
begin
  FOnChanges.Free;
  FItems.Free;
  inherited;
end;

procedure TDataTvChannel.Assign(Source: TPersistent);
var
  a : TDataTvChannel;
begin
  if Source is TDataTvChannel then begin
    a := TDataTvChannel(Source);
    FItems.Assign(a.FItems);
  end
  else begin
    inherited;
  end;
end;

//**************************************************************************//
//                                                                          //
//  `@NXi擾TCgʁj@`                              //
//                                                                          //
//   - Input -  Source :                                              //
//                                                                          //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
procedure TDataTvChannel.AssignEx(
  Source: TDataTvChannelItems; aMode: TTvChannelStatusMode);
var
  //a : TDataTvScheduleChannelItems;
  d1,d2 : TDataTvChannelItem;
  j : Integer;
begin
  if Source is TDataTvChannelItems then begin
    //a := TDataTvScheduleChannelItems(Source);
    for j := 0 to Source.Count-1 do begin
      d1 := Source.Items[j];

      d2 := GetEqual(d1);

      if d2 <> nil then begin                   // ǈꗗɑ݂ꍇ
        d2.AssignEx(d1,aMode);                  // f[^㏑
      end
      else begin                                // ꗗɑ݂Ȃꍇ
        d2 := FItems.Add();                            // f[^ꗗɒǉ
        d2.AssignEx(d1,aMode);
      end;
    end;

  end
  else begin
    inherited;
  end;
end;

//**************************************************************************//
//                                                                          //
//  `@w肳ꂽ`lf[^ƑSĈv邩@`                  //
//                                                                          //
//   - Input -  a : r`lf[^                                //
//                                                                          //
//   - Output - True : SĈv                                             //
//                                                                          //
//**************************************************************************//
function TDataTvChannel.CheckEqual(
  a: TDataTvChannelItems): Boolean;
var
  i : Integer;
begin
  result := False;
  if FItems.Count <> a.Count then exit;
  for i := 0 to FItems.Count-1 do begin
    if not Items[i].CheckEqual(a.Items[i]) then exit;
  end;
  result := True;
end;

//**************************************************************************//
//                                                                          //
//  `@ݒf[^ɐݒRꂪmF@`                                //
//                                                                          //
//   - Input -  Msg : G[\                                    //
//                                                                          //
//   - Output - True : f[^R͂Ȃ                                     //
//                                                                          //
//**************************************************************************//
function TDataTvChannel.DataCheck(var Msg: string): Boolean;
var
  i : Integer;
  f : Boolean;
begin
  result := True;
  f := False;
  for i := 0 to FItems.Count-1 do begin
    if Items[i].Visible then begin
      f := True;
      break;
    end;
  end;
  if not f then begin
    Msg := '\`lKPȏIĂB';
    result := False;
  end;
end;

function TDataTvChannel.DataLoad(tt: TStringListKey): Boolean;
var
  t,t2 : TStringListEx;
  j : Integer;
  d : TDataTvChannelItem;
begin
  t := tt.Values['Channel'];
  t2 := TStringListEx.Create;
  try
    result := False;
    if t = nil then exit;
    if t.GetInts('Version',-1) <> ConfigDataVersion then begin
      result := False;
      exit;
    end;
    for j := 1 to t.Count-1 do begin
      t2.CommaTextEx := t[j];
      d := FItems.Add();
      d.DataLoad(t2);
    end;
    //Sort();
    DoChange();
    result := True;
  finally
    t2.Free;
  end;
end;

//**************************************************************************//
//                                                                          //
//  `@`lf[^ށ@`                                      //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - True : I                                             //
//                                                                          //
//**************************************************************************//
function TDataTvChannel.DataSave(tk: TStringListKey): Boolean;
var
  t,t2 : TStringListEx;
  j : Integer;
  d : TDataTvChannelItem;
begin
  t := TStringListEx.Create;
  t2 := TStringListEx.Create;
  try
    result := False;
    t.Clear;
    t.SetInts('Version',ConfigDataVersion);
    for j := 0 to FItems.Count-1 do begin
      d := Items[j];
      d.DataSave(t2);
      t.Add(t2.CommaTextEx);
    end;
    tk.Add('Channel',t);
    result := True;
  finally
    t2.Free;
    t.Free;
  end;
end;

procedure TDataTvChannel.DoChange;
begin
  FOnChanges.Notify(Self);
end;

//**************************************************************************//
//                                                                          //
//  `@tOZbg@`                                            //
//                                                                          //
//   - Input -  Ȃ                                                        //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
procedure TDataTvChannel.ExtensionReset;
var
  i :Integer;
begin
  for i := 0 to FItems.Count-1 do begin
    Items[i].Extended := False;
    Items[i].FExtensionIndex := -1;
  end;
end;

//**************************************************************************//
//                                                                          //
//  `@w肵`lf[^Xg擾@`                        //
//                                                                          //
//   - Input -  a : `lf[^                                        //
//                                                                          //
//   - Output - `lf[^                                            //
//                                                                          //
//**************************************************************************//
function TDataTvChannel.GetChannelEqual(
  a: TDataTvChannelItem): TDataTvChannelItem;
var
  i : Integer;
  d : TDataTvChannelItem;
begin
  result := nil;
  for i := 0 to FItems.Count-1 do begin
    d := Items[i];
    if d.Mode = a.Mode then begin
      if d.Name = a.Name then begin
        result := d;
        exit;
      end;
    end;
  end;
end;

//**************************************************************************//
//                                                                          //
//  `@`lԍ`lf[^擾@`                        //
//                                                                          //
//   - Input -  Channel : `lԍ                                    //
//              Mode : n/BS/CS                                           //
//                                                                          //
//                                                                          //
//   - Output - `lf[^                                            //
//                                                                          //
//**************************************************************************//
function TDataTvChannel.GetChannelEx(Channel: Integer;
  Mode: TTvChannelStatusMode): TDataTvChannelItem;
var
  i : Integer;
  d : TDataTvChannelItem;
begin
  result := nil;
  for i := 0 to FItems.Count-1 do begin
    d := Items[i];
    if d.ChannelEx = Channel then begin
      if d.Mode = Mode then begin
        result := d;
        exit;
      end;
    end;
  end;
end;

//**************************************************************************//
//                                                                          //
//  `@Xg瓯̕ǂ擾@`                                    //
//                                                                          //
//   - Input -  Source :                                              //
//                                                                          //
//   - Output - Ȃ                                                        //
//                                                                          //
//**************************************************************************//
function TDataTvChannel.GetEqual(
  d: TDataTvChannelItem): TDataTvChannelItem;
var
  d2 : TDataTvChannelItem;
  i : Integer;
begin
  result := nil;
  for i := 0 to FItems.Count-1 do begin
    d2 := Items[i];
    if d.ChannelEx = -1 then continue;
    if d.ChannelEx <> d2.ChannelEx then continue;
    if d.Mode <> d2.Mode then continue;
    result := d2;
    exit;
  end;
end;

//--------------------------------------------------------------------------//
//                                                                          //
//  `@CS̃`lԍ`lCfbNX擾@`              //
//                                                                          //
//   - Input -  aChannel : CS`lԍ                                 //
//                                                                          //
//   - Output - `lCfbNX                                      //
//                                                                          //
//    Ԃꂽl  FConfigData.Channels[xxxx] ̂悤Ɏgpł         //
//                                                                          //
//--------------------------------------------------------------------------//
function TDataTvChannel.IndexOfEx(aChannelEx: Integer): Integer;
var
  i : Integer;
begin
  result := 0;
  for i := 0 to FItems.Count-1 do begin
    if FItems[i].ChannelEx = aChannelEx then begin
      result := i;
      exit;
    end;
  end;
end;

end.
