unit DataRdUsesChannel;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,CommInternet,ExtCtrls,DefaultData,DateTimeCtrl,
  StringListEx,StringListKey,DataTvStatus,DataRdRecReserveDateTime;

//--------------------------------------------------------------------------//
//  RDMł`lf[^NX                                    //
//--------------------------------------------------------------------------//
type
  TDataRdUsesChannelItem = class(TPersistent)
  private
    { Private 錾 }
    FName: string;                         // `l(CH1 BS1 CSƂ\)
    FLine: Integer;                        // qcF`lԍ(1,201Ƃ\)
  public
    { Public 錾 }
    procedure Assign(Source : TPersistent) ; override;
    function DataLoad(t : TStringListEx) : Boolean;
    function DataSave(t : TStringListEx) : Boolean;

    property Name : string read FName write FName;
    property Line : Integer read FLine write FLine;
  end;

//--------------------------------------------------------------------------//
//  RDMł`lꗗǗNX                            //
//--------------------------------------------------------------------------//
type
  TDataRdUsesChannelItems = class(TList)
  private
    { Private 錾 }
    function GetItems(Index: Integer): TDataRdUsesChannelItem;
  public
    { Public 錾 }
    destructor Destroy;override;
    procedure Assign(a : TDataRdUsesChannelItems) ;
    function Add() : TDataRdUsesChannelItem;
    procedure Delete(i : Integer);
    procedure Clear();override;
    property Items[Index: Integer] : TDataRdUsesChannelItem read GetItems;default;

  end;

//--------------------------------------------------------------------------//
//  RDgpł`lf[^ǗNX                                //
//--------------------------------------------------------------------------//
type
  TDataRdUsesChannel = class(TPersistent)
  private
    { Private 錾 }
    FItems : TDataRdUsesChannelItems;
    FStrings : TStringListEx;
  public
    { Public 錾 }
    constructor Create;
    destructor Destroy;override;

    procedure Assign(Source : TPersistent) ; override;

    property Items : TDataRdUsesChannelItems read FItems;

    function DataLoad(t : TStringListEx) : Boolean;
    function DataSave(t : TStringListEx) : Boolean;

    procedure MakeList();
  end;

implementation

{ TDataRdUsesChannel }

constructor TDataRdUsesChannel.Create;
begin
  FItems := TDataRdUsesChannelItems.Create;
end;

destructor TDataRdUsesChannel.Destroy;
begin
  FItems.Free;
  inherited;
end;

procedure TDataRdUsesChannel.Assign(Source: TPersistent);
var
  a : TDataRdUsesChannel;
begin
  if Source is TDataRdUsesChannel then begin
    a := TDataRdUsesChannel(Source);
    FItems.Assign(a.FItems);
    FStrings.Assign(a.FStrings);
  end
  else begin
    inherited;
  end;
end;

function TDataRdUsesChannel.DataLoad(t : TStringListEx): Boolean;
begin

end;

function TDataRdUsesChannel.DataSave(t : TStringListEx): Boolean;
var
  t2 : TStringListEx;
  i : Integer;
  d : TDataRdUsesChannelItem;
begin
  t2 := TStringListEx.Create;
  try
    t.Clear;
    result := False;
    for i := 0 to FItems.Count-1 do begin
      d := FItems[i];
      t2.Clear;
      d.DataSave(t);
      //t.Add(t2.CommaTextEx);
    end;
    result := True;
  finally
    t2.Free;
  end;
end;

procedure TDataRdUsesChannel.MakeList;
begin

end;

{ TDataRdUsesChannelItems }

destructor TDataRdUsesChannelItems.Destroy;
begin
  Clear();
  inherited;
end;

function TDataRdUsesChannelItems.Add: TDataRdUsesChannelItem;
var
  d : TDataRdUsesChannelItem;
begin
  d := TDataRdUsesChannelItem.Create;
  inherited Add(d);
  result := d;
end;

procedure TDataRdUsesChannelItems.Assign(a: TDataRdUsesChannelItems);
var
  d : TDataRdUsesChannelItem;
  i : Integer;
begin
  Clear;
  for i := 0 to a.Count-1 do begin
    d := Add();
    d.Assign(a.Items[i]);
  end;

end;

procedure TDataRdUsesChannelItems.Clear;
var
  i : Integer;
begin
  for i := 0 to Count-1 do begin
    Items[i].Free;
  end;
  inherited;
end;

procedure TDataRdUsesChannelItems.Delete(i: Integer);
begin
  Items[i].Free;
  inherited;
end;

function TDataRdUsesChannelItems.GetItems(
  Index: Integer): TDataRdUsesChannelItem;
begin
  result := inherited Items[Index];
end;

{ TDataRdUsesChannelItem }

procedure TDataRdUsesChannelItem.Assign(Source: TPersistent);
var
  a : TDataRdUsesChannelItem;
begin
  if Source is TDataRdUsesChannelItem then begin
    a := TDataRdUsesChannelItem(Source);
    FName := a.FName;
    FLine := a.FLine;
  end
  else begin
    inherited;
  end;
end;

function TDataRdUsesChannelItem.DataLoad(t: TStringListEx): Boolean;
begin
  FName := t.GetStrs('Name',FName);
  FLine := t.GetInts('Line',FLine);
  result := True;
end;

function TDataRdUsesChannelItem.DataSave(t: TStringListEx): Boolean;
begin
  t.SetStrs('Name',FName);
  t.SetInts('Line',FLine);
  result := True;
end;

end.
