unit DataRdRecReserveTitleLink;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,CommInternet,ExtCtrls,DefaultData,DateTimeCtrl,
  StringListEx,DataTvStatus,DataRdRecReserveDateTime,
  DataRdRecReserveList;

//--------------------------------------------------------------------------//
//  ԑgǂ                                                            //
//--------------------------------------------------------------------------//
type
  TDataRdRecReserveTitleLinkItemMode = (dtlOff,      // ؂
                                           dtlOn        // 
                                          );
const
  TDataRdRecReserveTitleLinkItemModeStr : array[0..1] of string =
                                         ('OFF',
                                          'ON'
                                          );

//--------------------------------------------------------------------------//
//  RDgpłԑgǂf[^NX                                  //
//--------------------------------------------------------------------------//
type
  TDataRdRecReserveTitleLinkItem = class(TDataRdRecReserveListItem)
  private
    { Private 錾 }
    FMode: TDataRdRecReserveTitleLinkItemMode;
    function GetModeStr: string;
    procedure SetModeStr(const Value: string);
  public
    { Public 錾 }
    procedure Assign(Source : TPersistent) ; override;
    function DataLoad(t : TStringListEx) : Boolean;override;
    function DataSave(t : TStringListEx) : Boolean;override;

    property Mode : TDataRdRecReserveTitleLinkItemMode read FMode write FMode;
    property ModeStr : string read GetModeStr write SetModeStr;
  end;

//--------------------------------------------------------------------------//
//  RDgpłԑgǂꗗǗNX                          //
//--------------------------------------------------------------------------//
type
  TDataRdRecReserveTitleLinkItems = class(TDataRdRecReserveListItemsEx)
  private
    { Private 錾 }
    function GetItems(Index: Integer): TDataRdRecReserveTitleLinkItem;
    function GetModes(
      Mode: TDataRdRecReserveTitleLinkItemMode): TDataRdRecReserveTitleLinkItem;
  public
    { Public 錾 }
    procedure Assign(a : TDataRdRecReserveTitleLinkItems) ;
    function Add() : TDataRdRecReserveTitleLinkItem;
    property Items[Index: Integer] : TDataRdRecReserveTitleLinkItem read GetItems;default;

    function IndexOfMode(Mode : TDataRdRecReserveTitleLinkItemMode) : Integer;
    function ModeToValue(Mode : TDataRdRecReserveTitleLinkItemMode) : string;
    property Modes[Mode : TDataRdRecReserveTitleLinkItemMode] : TDataRdRecReserveTitleLinkItem read GetModes;

  end;

//--------------------------------------------------------------------------//
//  RDgpłԑgǂǗNX                              //
//--------------------------------------------------------------------------//
type
  TDataRdRecReserveTitleLink = class(TPersistent)
  private
    { Private 錾 }
    FItems : TDataRdRecReserveTitleLinkItems;
  public
    { Public 錾 }
    constructor Create;
    destructor Destroy;override;

    procedure Assign(Source : TPersistent) ; override;

    property Items : TDataRdRecReserveTitleLinkItems read FItems;

    function DataLoad(ts : TStringListEx) : Boolean;
    function DataSave(ts : TStringListEx) : Boolean;

  end;

  function StrToTitleLinkMode(const str : string) : TDataRdRecReserveTitleLinkItemMode;
  function TitleLinkModeToStr(const Mode : TDataRdRecReserveTitleLinkItemMode) : string;

implementation

{ TDataRdRecReserveDvdr }

constructor TDataRdRecReserveTitleLink.Create;
begin
  FItems := TDataRdRecReserveTitleLinkItems.Create;
end;

destructor TDataRdRecReserveTitleLink.Destroy;
begin
  FItems.Free;
  inherited;
end;

procedure TDataRdRecReserveTitleLink.Assign(Source: TPersistent);
var
  a : TDataRdRecReserveTitleLink;
begin
  if Source is TDataRdRecReserveTitleLink then begin
    a := TDataRdRecReserveTitleLink(Source);
    FItems.Assign(a.FItems);
  end
  else begin
    inherited;
  end;
end;

function TDataRdRecReserveTitleLink.DataLoad(ts: TStringListEx): Boolean;
var
  i : Integer;
  d : TDataRdRecReserveTitleLinkItem;
  t : TStringListEx;
begin
  t := TStringListEx.Create;
  try
    result := False;
    FItems.Clear;
    for i := 0 to ts.Count-1 do begin
      d := FItems.Add();
      t.CommaTextEx := ts[i];
      d.DataLoad(t);
    end;
    result := True;
  finally
    t.Free;
  end;
end;

function TDataRdRecReserveTitleLink.DataSave(ts: TStringListEx): Boolean;
var
  i : Integer;
  d : TDataRdRecReserveTitleLinkItem;
  t : TStringListEx;
begin
  t := TStringListEx.Create;
  try
    result := False;
    for i := 0 to FItems.Count-1 do begin
      t.Clear;
      d := FItems[i];
      d.DataSave(t);
      ts.Add(t.CommaTextEx);
    end;
    result := True;
  finally
    t.Free;
  end;
end;

{ TDataRdRecReserveDvdrItems }

function TDataRdRecReserveTitleLinkItems.Add: TDataRdRecReserveTitleLinkItem;
var
  d : TDataRdRecReserveTitleLinkItem;
begin
  d := TDataRdRecReserveTitleLinkItem.Create;
  inherited Add(d);
  result := d;
end;

procedure TDataRdRecReserveTitleLinkItems.Assign(a: TDataRdRecReserveTitleLinkItems);
var
  d : TDataRdRecReserveTitleLinkItem;
  i : Integer;
begin
  Clear;
  for i := 0 to a.Count-1 do begin
    d := Add();
    d.Assign(a.Items[i]);
  end;
end;

function TDataRdRecReserveTitleLinkItems.GetItems(
  Index: Integer): TDataRdRecReserveTitleLinkItem;
begin
  result := inherited Items[Index];
end;

function TDataRdRecReserveTitleLinkItems.GetModes(
  Mode: TDataRdRecReserveTitleLinkItemMode): TDataRdRecReserveTitleLinkItem;
var
  i : Integer;
begin
  result := nil;
  i := IndexOfMode(Mode);
  if i = -1 then exit;
  result := Items[i];
end;

function TDataRdRecReserveTitleLinkItems.IndexOfMode(
  Mode: TDataRdRecReserveTitleLinkItemMode): Integer;
var
  i : Integer;
begin
  result := -1;
  for i := 0 to Count-1 do begin
    if Items[i].Mode = Mode then begin
      result := i;
      exit;
    end;
  end;
end;

function TDataRdRecReserveTitleLinkItems.ModeToValue(
  Mode: TDataRdRecReserveTitleLinkItemMode): string;
var
  i : Integer;
begin
  result := '';
  i := IndexOfMode(Mode);
  if i = -1 then exit;
  result := Items[i].Value;
end;

{ TDataRdRecReserveDvdrItem }

procedure TDataRdRecReserveTitleLinkItem.Assign(Source: TPersistent);
var
  a : TDataRdRecReserveTitleLinkItem;
begin
  if Source is TDataRdRecReserveTitleLinkItem then begin
    a := TDataRdRecReserveTitleLinkItem(Source);
    inherited;
    FMode     := a.FMode;
  end
  else begin
    inherited;
  end;
end;

function TDataRdRecReserveTitleLinkItem.DataLoad(t: TStringListEx): Boolean;
begin
  inherited DataLoad(t);
  ModeStr   := t.GetStrs('Mode',ModeStr);
  result := True;
end;

function TDataRdRecReserveTitleLinkItem.DataSave(t: TStringListEx): Boolean;
begin
  inherited DataSave(t);
  t.SetStrs('Mode',ModeStr);
  result := True;
end;

function TDataRdRecReserveTitleLinkItem.GetModeStr: string;
begin
  result := TitleLinkModeToStr(FMode);
end;

procedure TDataRdRecReserveTitleLinkItem.SetModeStr(const Value: string);
begin
  FMode := StrToTitleLinkMode(Value);
end;

function StrToTitleLinkMode(const str : string) : TDataRdRecReserveTitleLinkItemMode;
var
  i : Integer;
begin
  result := dtlOff;
  for i := 0 to High(TDataRdRecReserveTitleLinkItemModeStr) do begin
    if TDataRdRecReserveTitleLinkItemModeStr[i] = str then begin
      result := TDataRdRecReserveTitleLinkItemMode(i);
      break;
    end;
  end;
end;

function TitleLinkModeToStr(const Mode : TDataRdRecReserveTitleLinkItemMode) : string;
var
  i : Integer;
begin
  i := Ord(Mode);
  result := TDataRdRecReserveTitleLinkItemModeStr[i];
end;


end.
