unit DataRdRecReserveRecPriority;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,CommInternet,ExtCtrls,DefaultData,DateTimeCtrl,
  StringListEx,DataTvStatus,DataRdRecReserveDateTime,
  DataRdRecReserveList;

//--------------------------------------------------------------------------//
//  ^Dx                                                              //
//--------------------------------------------------------------------------//
type
  TDataRdRecReserveRecPriorityItemMode = (drpHigher,      // ŗD
                                          drpHigh,        // D
                                          drpNormal,      // W
                                          drpLow,         // D
                                          drpUser         // [U[\
                                          );
const
  TDataRdRecReserveRecPriorityItemModeStr : array[0..4] of string =
                                         ('Higher',
                                          'High',
                                          'Normal',
                                          'Low',
                                          'User'
                                          );

  TDataRdRecReserveRecPriorityItemModeViewStr : array[0..4] of string =
                                         ('ŗD',
                                          'D',
                                          '',
                                          'D',
                                          'w'
                                          );
//--------------------------------------------------------------------------//
//  RDgpł^Dxf[^NX                                    //
//--------------------------------------------------------------------------//
type
  TDataRdRecReserveRecPriorityItem = class(TDataRdRecReserveListItem)
  private
    { Private 錾 }
    FMode: TDataRdRecReserveRecPriorityItemMode;
    function GetModeStr: string;
    procedure SetModeStr(const Value: string);
  public
    { Public 錾 }
    procedure Assign(Source : TPersistent) ; override;
    function DataLoad(t : TStringListEx) : Boolean;override;
    function DataSave(t : TStringListEx) : Boolean;override;

    property Mode : TDataRdRecReserveRecPriorityItemMode read FMode write FMode;
    property ModeStr : string read GetModeStr write SetModeStr;
  end;

//--------------------------------------------------------------------------//
//  RDgpł^DxꗗǗNX                            //
//--------------------------------------------------------------------------//
type
  TDataRdRecReserveRecPriorityItems = class(TDataRdRecReserveListItemsEx)
  private
    { Private 錾 }
    function GetItems(Index: Integer): TDataRdRecReserveRecPriorityItem;
    function GetModes(
      Mode: TDataRdRecReserveRecPriorityItemMode): TDataRdRecReserveRecPriorityItem;
  public
    { Public 錾 }
    procedure Assign(a : TDataRdRecReserveRecPriorityItems) ;
    function Add() : TDataRdRecReserveRecPriorityItem;
    property Items[Index: Integer] : TDataRdRecReserveRecPriorityItem read GetItems;default;

    function IndexOfMode(Mode : TDataRdRecReserveRecPriorityItemMode) : Integer;
    function ModeToValue(Mode : TDataRdRecReserveRecPriorityItemMode) : string;
    property Modes[Mode : TDataRdRecReserveRecPriorityItemMode] : TDataRdRecReserveRecPriorityItem read GetModes;

  end;

//--------------------------------------------------------------------------//
//  RDgpł^DxǗNX                                //
//--------------------------------------------------------------------------//
type
  TDataRdRecReserveRecPriority = class(TPersistent)
  private
    { Private 錾 }
    FItems : TDataRdRecReserveRecPriorityItems;
  public
    { Public 錾 }
    constructor Create;
    destructor Destroy;override;

    procedure Assign(Source : TPersistent) ; override;

    property Items : TDataRdRecReserveRecPriorityItems read FItems;

    function DataLoad(ts : TStringListEx) : Boolean;
    function DataSave(ts : TStringListEx) : Boolean;

  end;

  function StrToRecPriorityMode(const str : string) : TDataRdRecReserveRecPriorityItemMode;
  function RecPriorityModeToStr(const Mode : TDataRdRecReserveRecPriorityItemMode) : string;
  // ϐ\p̕擾
  function RecPriorityModeToViewStr(const Mode : TDataRdRecReserveRecPriorityItemMode) : string;

implementation

{ TDataRdRecReserveDvdr }

constructor TDataRdRecReserveRecPriority.Create;
begin
  FItems := TDataRdRecReserveRecPriorityItems.Create;
end;

destructor TDataRdRecReserveRecPriority.Destroy;
begin
  FItems.Free;
  inherited;
end;

procedure TDataRdRecReserveRecPriority.Assign(Source: TPersistent);
var
  a : TDataRdRecReserveRecPriority;
begin
  if Source is TDataRdRecReserveRecPriority then begin
    a := TDataRdRecReserveRecPriority(Source);
    FItems.Assign(a.FItems);
  end
  else begin
    inherited;
  end;
end;

function TDataRdRecReserveRecPriority.DataLoad(ts: TStringListEx): Boolean;
var
  i : Integer;
  d : TDataRdRecReserveRecPriorityItem;
  t : TStringListEx;
begin
  t := TStringListEx.Create;
  try
    result := False;
    FItems.Clear;
    for i := 0 to ts.Count-1 do begin
      d := FItems.Add();
      t.CommaTextEx := ts[i];
      d.DataLoad(t);
    end;
    result := True;
  finally
    t.Free;
  end;
end;

function TDataRdRecReserveRecPriority.DataSave(ts: TStringListEx): Boolean;
var
  i : Integer;
  d : TDataRdRecReserveRecPriorityItem;
  t : TStringListEx;
begin
  t := TStringListEx.Create;
  try
    result := False;
    for i := 0 to FItems.Count-1 do begin
      t.Clear;
      d := FItems[i];
      d.DataSave(t);
      ts.Add(t.CommaTextEx);
    end;
    result := True;
  finally
    t.Free;
  end;
end;

{ TDataRdRecReserveDvdrItems }

function TDataRdRecReserveRecPriorityItems.Add: TDataRdRecReserveRecPriorityItem;
var
  d : TDataRdRecReserveRecPriorityItem;
begin
  d := TDataRdRecReserveRecPriorityItem.Create;
  inherited Add(d);
  result := d;
end;

procedure TDataRdRecReserveRecPriorityItems.Assign(a: TDataRdRecReserveRecPriorityItems);
var
  d : TDataRdRecReserveRecPriorityItem;
  i : Integer;
begin
  Clear;
  for i := 0 to a.Count-1 do begin
    d := Add();
    d.Assign(a.Items[i]);
  end;
end;

function TDataRdRecReserveRecPriorityItems.GetItems(
  Index: Integer): TDataRdRecReserveRecPriorityItem;
begin
  result := inherited Items[Index];
end;

function TDataRdRecReserveRecPriorityItems.GetModes(
  Mode: TDataRdRecReserveRecPriorityItemMode): TDataRdRecReserveRecPriorityItem;
var
  i : Integer;
begin
  result := nil;
  i := IndexOfMode(Mode);
  if i = -1 then exit;
  result := Items[i];
end;

function TDataRdRecReserveRecPriorityItems.IndexOfMode(
  Mode: TDataRdRecReserveRecPriorityItemMode): Integer;
var
  i : Integer;
begin
  result := -1;
  for i := 0 to Count-1 do begin
    if Items[i].Mode = Mode then begin
      result := i;
      exit;
    end;
  end;
end;

function TDataRdRecReserveRecPriorityItems.ModeToValue(
  Mode: TDataRdRecReserveRecPriorityItemMode): string;
var
  i : Integer;
begin
  result := '';
  i := IndexOfMode(Mode);
  if i = -1 then exit;
  result := Items[i].Value;
end;

{ TDataRdRecReserveDvdrItem }

procedure TDataRdRecReserveRecPriorityItem.Assign(Source: TPersistent);
var
  a : TDataRdRecReserveRecPriorityItem;
begin
  if Source is TDataRdRecReserveRecPriorityItem then begin
    a := TDataRdRecReserveRecPriorityItem(Source);
    inherited;
    FMode     := a.FMode;
  end
  else begin
    inherited;
  end;
end;

function TDataRdRecReserveRecPriorityItem.DataLoad(t: TStringListEx): Boolean;
begin
  inherited DataLoad(t);
  ModeStr   := t.GetStrs('Mode',ModeStr);
  result := True;
end;

function TDataRdRecReserveRecPriorityItem.DataSave(t: TStringListEx): Boolean;
begin
  inherited DataSave(t);
  t.SetStrs('Mode',ModeStr);
  result := True;
end;

function TDataRdRecReserveRecPriorityItem.GetModeStr: string;
begin
  result := RecPriorityModeToStr(FMode);
end;

procedure TDataRdRecReserveRecPriorityItem.SetModeStr(const Value: string);
begin
  FMode := StrToRecPriorityMode(Value);
end;

function StrToRecPriorityMode(const str : string) : TDataRdRecReserveRecPriorityItemMode;
var
  i : Integer;
begin
  result := drpUser;
  for i := 0 to High(TDataRdRecReserveRecPriorityItemModeStr) do begin
    if TDataRdRecReserveRecPriorityItemModeStr[i] = str then begin
      result := TDataRdRecReserveRecPriorityItemMode(i);
      break;
    end;
  end;
end;

function RecPriorityModeToStr(const Mode : TDataRdRecReserveRecPriorityItemMode) : string;
var
  i : Integer;
begin
  i := Ord(Mode);
  result := TDataRdRecReserveRecPriorityItemModeStr[i];
end;

function RecPriorityModeToViewStr(const Mode : TDataRdRecReserveRecPriorityItemMode) : string;
var
  i : Integer;
begin
  i := Ord(Mode);
  result := TDataRdRecReserveRecPriorityItemModeViewStr[i];
end;

end.
