unit DataRdRecReserveRate;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,CommInternet,ExtCtrls,DefaultData,DateTimeCtrl,
  StringListEx,DataTvStatus,DataRdRecReserveDateTime,
  DataRdRecReserveList;

//--------------------------------------------------------------------------//
//  掿[h                                                              //
//--------------------------------------------------------------------------//
type
  TDataRdRecReserveRateItemMode =  (rmSP,rmLP,rmJust,rm10,rm14,
                                    rm20,rm22,rm24,rm26,rm28,
                                    rm30,rm32,rm34,rm36,rm38,
                                    rm40,rm42,rm44,rm46,rm48,
                                    rm50,rm52,rm54,rm56,rm58,
                                    rm60,rm62,rm64,rm66,rm68,
                                    rm70,rm72,rm74,rm76,rm78,
                                    rm80,rm82,rm84,rm86,rm88,
                                    rm90,rm92,
                                    rmA1,rmA2,rmDL,rmSave);
const
  TDataRdRecReserveRateItemModeStr : array[0..45] of string =
                                   ('SP','LP','Just','MN1.0','MN1.4',
                                    'MN2.0','MN2.2','MN2.4','MN2.6','MN2.8',
                                    'MN3.0','MN3.2','MN3.4','MN3.6','MN3.8',
                                    'MN4.0','MN4.2','MN4.4','MN4.6','MN4.8',
                                    'MN5.0','MN5.2','MN5.4','MN5.6','MN5.8',
                                    'MN6.0','MN6.2','MN6.4','MN6.6','MN6.8',
                                    'MN7.0','MN7.2','MN7.4','MN7.6','MN7.8',
                                    'MN8.0','MN8.2','MN8.4','MN8.6','MN8.8',
                                    'MN9.0','MN9.2',
                                    'A1','A2','DL','SAVE');

// [őMۂ̕\L
const
  TDataRdRecReserveRateItemModeStrMail : array[0..45] of string =
                                   ('SP','LP','Just','MN10','MN14',
                                    'MN20','MN22','MN24','MN26','MN28',
                                    'MN30','MN32','MN34','MN36','MN38',
                                    'MN40','MN42','MN44','MN46','MN48',
                                    'MN50','MN52','MN54','MN56','MN58',
                                    'MN60','MN62','MN64','MN66','MN68',
                                    'MN70','MN72','MN74','MN76','MN78',
                                    'MN80','MN82','MN84','MN86','MN88',
                                    'MN90','MN92',
                                    'A1','A2','DL','SAVE');
//--------------------------------------------------------------------------//
//  RDgpł掿[gf[^NX                                    //
//--------------------------------------------------------------------------//
type
  TDataRdRecReserveRateItem = class(TDataRdRecReserveListItem)
  private
    { Private 錾 }
    FMode: TDataRdRecReserveRateItemMode;
    function GetModeStr: string;
    procedure SetModeStr(const Value: string);
  public
    { Public 錾 }
    procedure Assign(Source : TPersistent) ; override;
    function DataLoad(t : TStringListEx) : Boolean;override;
    function DataSave(t : TStringListEx) : Boolean;override;

    property Mode : TDataRdRecReserveRateItemMode read FMode write FMode;
    property ModeStr : string read GetModeStr write SetModeStr;
  end;

//--------------------------------------------------------------------------//
//  RDgpł掿[gꗗǗNX                            //
//--------------------------------------------------------------------------//
type
  TDataRdRecReserveRateItems = class(TDataRdRecReserveListItemsEx)
  private
    { Private 錾 }
    function GetItems(Index: Integer): TDataRdRecReserveRateItem;
    function GetModes(
      Mode: TDataRdRecReserveRateItemMode): TDataRdRecReserveRateItem;
  public
    { Public 錾 }
    procedure Assign(a : TDataRdRecReserveRateItems) ;
    function Add() : TDataRdRecReserveRateItem;
    property Items[Index: Integer] : TDataRdRecReserveRateItem read GetItems;default;

    function IndexOfMode(Mode : TDataRdRecReserveRateItemMode) : Integer;
    function ModeToValue(Mode : TDataRdRecReserveRateItemMode) : string;
    property Modes[Mode : TDataRdRecReserveRateItemMode] : TDataRdRecReserveRateItem read GetModes;

  end;

//--------------------------------------------------------------------------//
//  RDgpł掿[gǗNX                                //
//--------------------------------------------------------------------------//
type
  TDataRdRecReserveRate = class(TPersistent)
  private
    { Private 錾 }
    FItems : TDataRdRecReserveRateItems;
  public
    { Public 錾 }
    constructor Create;
    destructor Destroy;override;

    procedure Assign(Source : TPersistent) ; override;

    property Items : TDataRdRecReserveRateItems read FItems;

    function DataLoad(ts : TStringListEx) : Boolean;
    function DataSave(ts : TStringListEx) : Boolean;

  end;

  function StrToRateMode(const str : string) : TDataRdRecReserveRateItemMode;
  function RateModeToStr(const Mode : TDataRdRecReserveRateItemMode) : string;

implementation


{ TDataRdRecReserveRate }

constructor TDataRdRecReserveRate.Create;
begin
  FItems := TDataRdRecReserveRateItems.Create;
end;

destructor TDataRdRecReserveRate.Destroy;
begin
  FItems.Free;
  inherited;
end;

procedure TDataRdRecReserveRate.Assign(Source: TPersistent);
var
  a : TDataRdRecReserveRate;
begin
  if Source is TDataRdRecReserveRate then begin
    a := TDataRdRecReserveRate(Source);
    FItems.Assign(a.FItems);
  end
  else begin
    inherited;
  end;
end;

function TDataRdRecReserveRate.DataLoad(ts: TStringListEx): Boolean;
var
  i : Integer;
  d : TDataRdRecReserveRateItem;
  t : TStringListEx;
begin
  t := TStringListEx.Create;
  try
    result := False;
    FItems.Clear;
    for i := 0 to ts.Count-1 do begin
      d := FItems.Add();
      t.CommaTextEx := ts[i];
      d.DataLoad(t);
    end;
    result := True;
  finally
    t.Free;
  end;
end;

function TDataRdRecReserveRate.DataSave(ts: TStringListEx): Boolean;
var
  i : Integer;
  d : TDataRdRecReserveRateItem;
  t : TStringListEx;
begin
  t := TStringListEx.Create;
  try
    result := False;
    for i := 0 to FItems.Count-1 do begin
      t.Clear;
      d := FItems[i];
      d.DataSave(t);
      ts.Add(t.CommaTextEx);
    end;
    result := True;
  finally
    t.Free;
  end;
end;

{ TDataRdRecReserveRateItems }

function TDataRdRecReserveRateItems.Add: TDataRdRecReserveRateItem;
var
  d : TDataRdRecReserveRateItem;
begin
  d := TDataRdRecReserveRateItem.Create;
  inherited Add(d);
  result := d;
end;

procedure TDataRdRecReserveRateItems.Assign(a: TDataRdRecReserveRateItems);
var
  d : TDataRdRecReserveRateItem;
  i : Integer;
begin
  Clear;
  for i := 0 to a.Count-1 do begin
    d := Add();
    d.Assign(a.Items[i]);
  end;
end;

function TDataRdRecReserveRateItems.GetItems(
  Index: Integer): TDataRdRecReserveRateItem;
begin
  result := inherited Items[Index];
end;

function TDataRdRecReserveRateItems.GetModes(
  Mode: TDataRdRecReserveRateItemMode): TDataRdRecReserveRateItem;
var
  i : Integer;
begin
  result := nil;
  i := IndexOfMode(Mode);
  if i = -1 then exit;
  result := Items[i];
end;

function TDataRdRecReserveRateItems.IndexOfMode(
  Mode: TDataRdRecReserveRateItemMode): Integer;
var
  i : Integer;
begin
  result := -1;
  for i := 0 to Count-1 do begin
    if Items[i].Mode = Mode then begin
      result := i;
      exit;
    end;
  end;
end;

function TDataRdRecReserveRateItems.ModeToValue(
  Mode: TDataRdRecReserveRateItemMode): string;
var
  i : Integer;
begin
  result := '';
  i := IndexOfMode(Mode);
  if i = -1 then exit;
  result := Items[i].Value;
end;

{ TDataRdRecReserveRateItem }

procedure TDataRdRecReserveRateItem.Assign(Source: TPersistent);
var
  a : TDataRdRecReserveRateItem;
begin
  if Source is TDataRdRecReserveRateItem then begin
    a := TDataRdRecReserveRateItem(Source);
    inherited;
    FMode     := a.FMode;
  end
  else begin
    inherited;
  end;
end;

function TDataRdRecReserveRateItem.DataLoad(t: TStringListEx): Boolean;
begin
  inherited DataLoad(t);
  ModeStr   := t.GetStrs('Mode',ModeStr);
  result := True;
end;

function TDataRdRecReserveRateItem.DataSave(t: TStringListEx): Boolean;
begin
  inherited DataSave(t);
  t.SetStrs('Mode',ModeStr);
  result := True;
end;

function TDataRdRecReserveRateItem.GetModeStr: string;
begin
  result := RateModeToStr(FMode);
end;

procedure TDataRdRecReserveRateItem.SetModeStr(const Value: string);
begin
  FMode := StrToRateMode(Value);
end;

function StrToRateMode(const str : string) : TDataRdRecReserveRateItemMode;
var
  i : Integer;
begin
  result := rmSP;
  for i := 0 to High(TDataRdRecReserveRateItemModeStr) do begin
    if TDataRdRecReserveRateItemModeStr[i] = str then begin
      result := TDataRdRecReserveRateItemMode(i);
      break;
    end;
  end;
end;

function RateModeToStr(const Mode : TDataRdRecReserveRateItemMode) : string;
var
  i : Integer;
begin
  i := Ord(Mode);
  result := TDataRdRecReserveRateItemModeStr[i];
end;

end.
