unit DataRdRecReserveMuteChapter;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,CommInternet,ExtCtrls,DefaultData,DateTimeCtrl,
  StringListEx,DataTvStatus,DataRdRecReserveDateTime,
  DataRdRecReserveList;

//--------------------------------------------------------------------------//
//  `v^[                                              //
//--------------------------------------------------------------------------//
type
  // Ǘp̌^
  TDataRdRecReserveMuteChapterItemMode = (mcOFF,mcON);
const
  // ۑɎgpf[^^
  TDataRdRecReserveMuteChapterItemModeStr : array[0..1] of string = ('OFF','ON');

//--------------------------------------------------------------------------//
//  RDgpł閳`v^[f[^NX                    //
//--------------------------------------------------------------------------//
type
  TDataRdRecReserveMuteChapterItem = class(TDataRdRecReserveListItem)
  private
    { Private 錾 }
    FMode: TDataRdRecReserveMuteChapterItemMode;
    function GetModeStr: string;
    procedure SetModeStr(const Value: string);
  public
    { Public 錾 }
    procedure Assign(Source : TPersistent) ; override;
    function DataLoad(t : TStringListEx) : Boolean;override;
    function DataSave(t : TStringListEx) : Boolean;override;

    property Mode : TDataRdRecReserveMuteChapterItemMode read FMode write FMode;
    property ModeStr : string read GetModeStr write SetModeStr;
  end;

//--------------------------------------------------------------------------//
//  RDgpł閳`v^[ꗗǗNX            //
//--------------------------------------------------------------------------//
type
  TDataRdRecReserveMuteChapterItems = class(TDataRdRecReserveListItemsEx)
  private
    { Private 錾 }
    function GetItems(Index: Integer): TDataRdRecReserveMuteChapterItem;
    function GetModes(
      Mode: TDataRdRecReserveMuteChapterItemMode): TDataRdRecReserveMuteChapterItem;
  public
    { Public 錾 }
    procedure Assign(a : TDataRdRecReserveMuteChapterItems) ;
    function Add() : TDataRdRecReserveMuteChapterItem;
    property Items[Index: Integer] : TDataRdRecReserveMuteChapterItem read GetItems;default;

    function ModeToValue(Mode : TDataRdRecReserveMuteChapterItemMode) : string;
    property Modes[Mode : TDataRdRecReserveMuteChapterItemMode] : TDataRdRecReserveMuteChapterItem read GetModes;
    function IndexOfMode(Mode : TDataRdRecReserveMuteChapterItemMode) : Integer;

  end;

//--------------------------------------------------------------------------//
//  RDgpł閳`v^[ǗNX                //
//--------------------------------------------------------------------------//
type
  TDataRdRecReserveMuteChapter = class(TPersistent)
  private
    { Private 錾 }
    FItems : TDataRdRecReserveMuteChapterItems;
  public
    { Public 錾 }
    constructor Create;
    destructor Destroy;override;

    procedure Assign(Source : TPersistent) ; override;

    property Items : TDataRdRecReserveMuteChapterItems read FItems;

    function DataLoad(ts : TStringListEx) : Boolean;
    function DataSave(ts : TStringListEx) : Boolean;

  end;

  function StrToMuteChapterMode(const str : string) : TDataRdRecReserveMuteChapterItemMode;
  function MuteChapterModeToStr(const Mode : TDataRdRecReserveMuteChapterItemMode) : string;

implementation

{ TDataRdRecReserveAspect }

constructor TDataRdRecReserveMuteChapter.Create;
begin
  FItems := TDataRdRecReserveMuteChapterItems.Create;
end;

destructor TDataRdRecReserveMuteChapter.Destroy;
begin
  FItems.Free;
  inherited;
end;

procedure TDataRdRecReserveMuteChapter.Assign(Source: TPersistent);
var
  a : TDataRdRecReserveMuteChapter;
begin
  if Source is TDataRdRecReserveMuteChapter then begin
    a := TDataRdRecReserveMuteChapter(Source);
    FItems.Assign(a.FItems);
  end
  else begin
    inherited;
  end;
end;

function TDataRdRecReserveMuteChapter.DataLoad(ts: TStringListEx): Boolean;
var
  i : Integer;
  d : TDataRdRecReserveMuteChapterItem;
  t : TStringListEx;
begin
  t := TStringListEx.Create;
  try
    result := False;
    FItems.Clear;
    for i := 0 to ts.Count-1 do begin
      d := FItems.Add();
      t.CommaTextEx := ts[i];
      d.DataLoad(t);
    end;
    result := True;
  finally
    t.Free;
  end;
end;

function TDataRdRecReserveMuteChapter.DataSave(ts: TStringListEx): Boolean;
var
  i : Integer;
  d : TDataRdRecReserveMuteChapterItem;
  t : TStringListEx;
begin
  t := TStringListEx.Create;
  try
    result := False;
    for i := 0 to FItems.Count-1 do begin
      t.Clear;
      d := FItems[i];
      d.DataSave(t);
      ts.Add(t.CommaTextEx);
    end;
    result := True;
  finally
    t.Free;
  end;
end;

{ TDataRdRecReserveAspectItems }

function TDataRdRecReserveMuteChapterItems.Add: TDataRdRecReserveMuteChapterItem;
var
  d : TDataRdRecReserveMuteChapterItem;
begin
  d := TDataRdRecReserveMuteChapterItem.Create;
  inherited Add(d);
  result := d;
end;

procedure TDataRdRecReserveMuteChapterItems.Assign(
  a: TDataRdRecReserveMuteChapterItems);
var
  d : TDataRdRecReserveMuteChapterItem;
  i : Integer;
begin
  Clear;
  for i := 0 to a.Count-1 do begin
    d := Add();
    d.Assign(a.Items[i]);
  end;
end;

function TDataRdRecReserveMuteChapterItems.GetItems(
  Index: Integer): TDataRdRecReserveMuteChapterItem;
begin
  result := inherited Items[Index];
end;

function TDataRdRecReserveMuteChapterItems.GetModes(
  Mode: TDataRdRecReserveMuteChapterItemMode): TDataRdRecReserveMuteChapterItem;
var
  i : Integer;
begin
  result := nil;
  i := IndexOfMode(Mode);
  if i = -1 then exit;
  result := Items[i];
end;

function TDataRdRecReserveMuteChapterItems.IndexOfMode(
  Mode: TDataRdRecReserveMuteChapterItemMode): Integer;
var
  i : Integer;
begin
  result := -1;
  for i := 0 to Count-1 do begin
    if Items[i].Mode = Mode then begin
      result := i;
      exit;
    end;
  end;
end;

function TDataRdRecReserveMuteChapterItems.ModeToValue(
  Mode: TDataRdRecReserveMuteChapterItemMode): string;
var
  i : Integer;
begin
  result := '';
  i := IndexOfMode(Mode);
  if i = -1 then exit;
  result := Items[i].Value;
end;

{ TDataRdRecReserveAspectItem }

procedure TDataRdRecReserveMuteChapterItem.Assign(Source: TPersistent);
var
  a : TDataRdRecReserveMuteChapterItem;
begin
  if Source is TDataRdRecReserveMuteChapterItem then begin
    a := TDataRdRecReserveMuteChapterItem(Source);
    inherited;
    FMode     := a.FMode;
  end
  else begin
    inherited;
  end;
end;

function TDataRdRecReserveMuteChapterItem.DataLoad(t: TStringListEx): Boolean;
begin
  inherited DataLoad(t);
  ModeStr   := t.GetStrs('Mode',ModeStr);
  result := True;
end;

function TDataRdRecReserveMuteChapterItem.DataSave(t: TStringListEx): Boolean;
begin
  inherited DataSave(t);
  t.SetStrs('Mode',ModeStr);
  result := True;
end;

function TDataRdRecReserveMuteChapterItem.GetModeStr: string;
begin
  result := MuteChapterModeToStr(FMode);
end;

procedure TDataRdRecReserveMuteChapterItem.SetModeStr(const Value: string);
begin
  FMode := StrToMuteChapterMode(Value);
end;

function StrToMuteChapterMode(const str : string) : TDataRdRecReserveMuteChapterItemMode;
var
  i : Integer;
begin
  result := mcOFF;
  for i := 0 to High(TDataRdRecReserveMuteChapterItemModeStr) do begin
    if TDataRdRecReserveMuteChapterItemModeStr[i] = str then begin
      result := TDataRdRecReserveMuteChapterItemMode(i);
      break;
    end;
  end;
end;

function MuteChapterModeToStr(const Mode : TDataRdRecReserveMuteChapterItemMode) : string;
var
  i : Integer;
begin
  i := Ord(Mode);
  result := TDataRdRecReserveMuteChapterItemModeStr[i];
end;


end.
