unit DataRdRecReserveMedia;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,CommInternet,ExtCtrls,DefaultData,DateTimeCtrl,
  StringListEx,DataTvStatus,DataRdRecReserveDateTime,
  DataRdRecReserveList;

//--------------------------------------------------------------------------//
//  L^fBA                                                            //
//--------------------------------------------------------------------------//
type
  TDataRdRecReserveMediaItemMode = (rmHdd,rmDvd,rmAB);

const
  TDataRdRecReserveMediaItemModeStr : array[0..2] of string = ('HDD','DVD','AB');
//--------------------------------------------------------------------------//
//  RDgpłL^fBANX                                        //
//--------------------------------------------------------------------------//
type
  TDataRdRecReserveMediaItem = class(TDataRdRecReserveListItem)
  private
    { Private 錾 }
    FMode: TDataRdRecReserveMediaItemMode;
    function GetModeStr: string;
    procedure SetModeStr(const Value: string);
  public
    { Public 錾 }
    procedure Assign(Source : TPersistent) ; override;
    function DataLoad(t : TStringListEx) : Boolean;override;
    function DataSave(t : TStringListEx) : Boolean;override;

    property Mode : TDataRdRecReserveMediaItemMode read FMode write FMode;
    property ModeStr : string read GetModeStr write SetModeStr;
  end;

//--------------------------------------------------------------------------//
//  RDgpłL^fBAꗗǗNX                          //
//--------------------------------------------------------------------------//
type
  TDataRdRecReserveMediaItems = class(TDataRdRecReserveListItemsEx)
  private
    { Private 錾 }
    function GetItems(Index: Integer): TDataRdRecReserveMediaItem;
    function GetModes(
      Mode: TDataRdRecReserveMediaItemMode): TDataRdRecReserveMediaItem;
  public
    { Public 錾 }
    procedure Assign(a : TDataRdRecReserveMediaItems) ;
    function Add() : TDataRdRecReserveMediaItem;
    property Items[Index: Integer] : TDataRdRecReserveMediaItem read GetItems;default;

    function IndexOfMode(Mode : TDataRdRecReserveMediaItemMode) : Integer;
    function ModeToValue(Mode : TDataRdRecReserveMediaItemMode) : string;
    property Modes[Mode : TDataRdRecReserveMediaItemMode] : TDataRdRecReserveMediaItem read GetModes;
  end;

//--------------------------------------------------------------------------//
//  RDgpł鉹ǗNX                                      //
//--------------------------------------------------------------------------//
type
  TDataRdRecReserveMedia = class(TPersistent)
  private
    { Private 錾 }
    FItems : TDataRdRecReserveMediaItems;
  public
    { Public 錾 }
    constructor Create;
    destructor Destroy;override;

    procedure Assign(Source : TPersistent) ; override;

    property Items : TDataRdRecReserveMediaItems read FItems;

    function DataLoad(ts : TStringListEx) : Boolean;
    function DataSave(ts : TStringListEx) : Boolean;

  end;

  function StrToMediaMode(const str : string) : TDataRdRecReserveMediaItemMode;
  function MediaModeToStr(const Mode : TDataRdRecReserveMediaItemMode) : string;

implementation

{ TDataRdRecReserveMedia }

constructor TDataRdRecReserveMedia.Create;
begin
  FItems := TDataRdRecReserveMediaItems.Create;
end;

destructor TDataRdRecReserveMedia.Destroy;
begin
  FItems.Free;
  inherited;
end;
procedure TDataRdRecReserveMedia.Assign(Source: TPersistent);
var
  a : TDataRdRecReserveMedia;
begin
  if Source is TDataRdRecReserveMedia then begin
    a := TDataRdRecReserveMedia(Source);
    FItems.Assign(a.FItems);
  end
  else begin
    inherited;
  end;
end;

function TDataRdRecReserveMedia.DataLoad(ts: TStringListEx): Boolean;
var
  i : Integer;
  d : TDataRdRecReserveMediaItem;
  t : TStringListEx;
begin
  t := TStringListEx.Create;
  try
    result := False;
    FItems.Clear;
    for i := 0 to ts.Count-1 do begin
      d := FItems.Add();
      t.CommaTextEx := ts[i];
      d.DataLoad(t);
    end;
    result := True;
  finally
    t.Free;
  end;
end;

function TDataRdRecReserveMedia.DataSave(ts: TStringListEx): Boolean;
var
  i : Integer;
  d : TDataRdRecReserveMediaItem;
  t : TStringListEx;
begin
  t := TStringListEx.Create;
  try
    result := False;
    for i := 0 to FItems.Count-1 do begin
      t.Clear;
      d := FItems[i];
      d.DataSave(t);
      ts.Add(t.CommaTextEx);
    end;
    result := True;
  finally
    t.Free;
  end;
end;


{ TDataRdRecReserveMediaItems }

function TDataRdRecReserveMediaItems.Add: TDataRdRecReserveMediaItem;
var
  d : TDataRdRecReserveMediaItem;
begin
  d := TDataRdRecReserveMediaItem.Create;
  inherited Add(d);
  result := d;
end;

procedure TDataRdRecReserveMediaItems.Assign(
  a: TDataRdRecReserveMediaItems);
var
  d : TDataRdRecReserveMediaItem;
  i : Integer;
begin
  Clear;
  for i := 0 to a.Count-1 do begin
    d := Add();
    d.Assign(a.Items[i]);
  end;
end;

function TDataRdRecReserveMediaItems.GetItems(
  Index: Integer): TDataRdRecReserveMediaItem;
begin
  result := inherited Items[Index];
end;

function TDataRdRecReserveMediaItems.GetModes(
  Mode: TDataRdRecReserveMediaItemMode): TDataRdRecReserveMediaItem;
var
  i : Integer;
begin
  result := nil;
  i := IndexOfMode(Mode);
  if i = -1 then exit;
  result := Items[i];
end;

function TDataRdRecReserveMediaItems.IndexOfMode(
  Mode: TDataRdRecReserveMediaItemMode): Integer;
var
  i : Integer;
begin
  result := -1;
  for i := 0 to Count-1 do begin
    if Items[i].Mode = Mode then begin
      result := i;
      exit;
    end;
  end;
end;

function TDataRdRecReserveMediaItems.ModeToValue(
  Mode: TDataRdRecReserveMediaItemMode): string;
var
  i : Integer;
begin
  result := '';
  i := IndexOfMode(Mode);
  if i = -1 then exit;
  result := Items[i].Value;
end;

{ TDataRdRecReserveMediaItem }

procedure TDataRdRecReserveMediaItem.Assign(Source: TPersistent);
var
  a : TDataRdRecReserveMediaItem;
begin
  if Source is TDataRdRecReserveMediaItem then begin
    a := TDataRdRecReserveMediaItem(Source);
    inherited;
    FMode     := a.FMode;
  end
  else begin
    inherited;
  end;
end;

function TDataRdRecReserveMediaItem.DataLoad(t: TStringListEx): Boolean;
begin
  inherited DataLoad(t);
  ModeStr   := t.GetStrs('Mode',ModeStr);
  result := True;
end;

function TDataRdRecReserveMediaItem.DataSave(t: TStringListEx): Boolean;
begin
  inherited DataSave(t);
  t.SetStrs('Mode',ModeStr);
  result := True;
end;

function TDataRdRecReserveMediaItem.GetModeStr: string;
begin
  result := MediaModeToStr(FMode);
end;

procedure TDataRdRecReserveMediaItem.SetModeStr(const Value: string);
begin
  FMode := StrToMediaMode(Value);
end;

function StrToMediaMode(const str : string) : TDataRdRecReserveMediaItemMode;
var
  i : Integer;
begin
  result := rmHdd;
  for i := 0 to High(TDataRdRecReserveMediaItemModeStr) do begin
    if TDataRdRecReserveMediaItemModeStr[i] = str then begin
      result := TDataRdRecReserveMediaItemMode(i);
      break;
    end;
  end;
end;

function MediaModeToStr(const Mode : TDataRdRecReserveMediaItemMode) : string;
var
  i : Integer;
begin
  i := Ord(Mode);
  result := TDataRdRecReserveMediaItemModeStr[i];
end;

end.
