unit DataRdRecReserveMagicChapter;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,CommInternet,ExtCtrls,DefaultData,DateTimeCtrl,
  StringListEx,DataTvStatus,DataRdRecReserveDateTime,
  DataRdRecReserveList;

//--------------------------------------------------------------------------//
//  }WbN`v^[                                                      //
//--------------------------------------------------------------------------//
type
  TDataRdRecReserveMagicChapterItemMode = (dmcOff,      // ؂
                                           dmcOn        // 
                                          );
const
  TDataRdRecReserveMagicChapterItemModeStr : array[0..1] of string =
                                         ('OFF',
                                          'ON'
                                          );

//--------------------------------------------------------------------------//
//  RDgpł}WbN`v^[f[^NX                            //
//--------------------------------------------------------------------------//
type
  TDataRdRecReserveMagicChapterItem = class(TDataRdRecReserveListItem)
  private
    { Private 錾 }
    FMode: TDataRdRecReserveMagicChapterItemMode;
    function GetModeStr: string;
    procedure SetModeStr(const Value: string);
  public
    { Public 錾 }
    procedure Assign(Source : TPersistent) ; override;
    function DataLoad(t : TStringListEx) : Boolean;override;
    function DataSave(t : TStringListEx) : Boolean;override;

    property Mode : TDataRdRecReserveMagicChapterItemMode read FMode write FMode;
    property ModeStr : string read GetModeStr write SetModeStr;
  end;

//--------------------------------------------------------------------------//
//  RDgpł}WbN`v^[ꗗǗNX                    //
//--------------------------------------------------------------------------//
type
  TDataRdRecReserveMagicChapterItems = class(TDataRdRecReserveListItemsEx)
  private
    { Private 錾 }
    function GetItems(Index: Integer): TDataRdRecReserveMagicChapterItem;
    function GetModes(
      Mode: TDataRdRecReserveMagicChapterItemMode): TDataRdRecReserveMagicChapterItem;
  public
    { Public 錾 }
    procedure Assign(a : TDataRdRecReserveMagicChapterItems) ;
    function Add() : TDataRdRecReserveMagicChapterItem;
    property Items[Index: Integer] : TDataRdRecReserveMagicChapterItem read GetItems;default;

    function IndexOfMode(Mode : TDataRdRecReserveMagicChapterItemMode) : Integer;
    function ModeToValue(Mode : TDataRdRecReserveMagicChapterItemMode) : string;
    property Modes[Mode : TDataRdRecReserveMagicChapterItemMode] : TDataRdRecReserveMagicChapterItem read GetModes;

  end;

//--------------------------------------------------------------------------//
//  RDgpł}WbN`v^[ǗNX                        //
//--------------------------------------------------------------------------//
type
  TDataRdRecReserveMagicChapter = class(TPersistent)
  private
    { Private 錾 }
    FItems : TDataRdRecReserveMagicChapterItems;
  public
    { Public 錾 }
    constructor Create;
    destructor Destroy;override;

    procedure Assign(Source : TPersistent) ; override;

    property Items : TDataRdRecReserveMagicChapterItems read FItems;

    function DataLoad(ts : TStringListEx) : Boolean;
    function DataSave(ts : TStringListEx) : Boolean;

  end;

  function StrToRecPriorityMode(const str : string) : TDataRdRecReserveMagicChapterItemMode;
  function RecPriorityModeToStr(const Mode : TDataRdRecReserveMagicChapterItemMode) : string;

implementation

{ TDataRdRecReserveDvdr }

constructor TDataRdRecReserveMagicChapter.Create;
begin
  FItems := TDataRdRecReserveMagicChapterItems.Create;
end;

destructor TDataRdRecReserveMagicChapter.Destroy;
begin
  FItems.Free;
  inherited;
end;

procedure TDataRdRecReserveMagicChapter.Assign(Source: TPersistent);
var
  a : TDataRdRecReserveMagicChapter;
begin
  if Source is TDataRdRecReserveMagicChapter then begin
    a := TDataRdRecReserveMagicChapter(Source);
    FItems.Assign(a.FItems);
  end
  else begin
    inherited;
  end;
end;

function TDataRdRecReserveMagicChapter.DataLoad(ts: TStringListEx): Boolean;
var
  i : Integer;
  d : TDataRdRecReserveMagicChapterItem;
  t : TStringListEx;
begin
  t := TStringListEx.Create;
  try
    result := False;
    FItems.Clear;
    for i := 0 to ts.Count-1 do begin
      d := FItems.Add();
      t.CommaTextEx := ts[i];
      d.DataLoad(t);
    end;
    result := True;
  finally
    t.Free;
  end;
end;

function TDataRdRecReserveMagicChapter.DataSave(ts: TStringListEx): Boolean;
var
  i : Integer;
  d : TDataRdRecReserveMagicChapterItem;
  t : TStringListEx;
begin
  t := TStringListEx.Create;
  try
    result := False;
    for i := 0 to FItems.Count-1 do begin
      t.Clear;
      d := FItems[i];
      d.DataSave(t);
      ts.Add(t.CommaTextEx);
    end;
    result := True;
  finally
    t.Free;
  end;
end;

{ TDataRdRecReserveDvdrItems }

function TDataRdRecReserveMagicChapterItems.Add: TDataRdRecReserveMagicChapterItem;
var
  d : TDataRdRecReserveMagicChapterItem;
begin
  d := TDataRdRecReserveMagicChapterItem.Create;
  inherited Add(d);
  result := d;
end;

procedure TDataRdRecReserveMagicChapterItems.Assign(a: TDataRdRecReserveMagicChapterItems);
var
  d : TDataRdRecReserveMagicChapterItem;
  i : Integer;
begin
  Clear;
  for i := 0 to a.Count-1 do begin
    d := Add();
    d.Assign(a.Items[i]);
  end;
end;

function TDataRdRecReserveMagicChapterItems.GetItems(
  Index: Integer): TDataRdRecReserveMagicChapterItem;
begin
  result := inherited Items[Index];
end;

function TDataRdRecReserveMagicChapterItems.GetModes(
  Mode: TDataRdRecReserveMagicChapterItemMode): TDataRdRecReserveMagicChapterItem;
var
  i : Integer;
begin
  result := nil;
  i := IndexOfMode(Mode);
  if i = -1 then exit;
  result := Items[i];
end;

function TDataRdRecReserveMagicChapterItems.IndexOfMode(
  Mode: TDataRdRecReserveMagicChapterItemMode): Integer;
var
  i : Integer;
begin
  result := -1;
  for i := 0 to Count-1 do begin
    if Items[i].Mode = Mode then begin
      result := i;
      exit;
    end;
  end;
end;

function TDataRdRecReserveMagicChapterItems.ModeToValue(
  Mode: TDataRdRecReserveMagicChapterItemMode): string;
var
  i : Integer;
begin
  result := '';
  i := IndexOfMode(Mode);
  if i = -1 then exit;
  result := Items[i].Value;
end;

{ TDataRdRecReserveDvdrItem }

procedure TDataRdRecReserveMagicChapterItem.Assign(Source: TPersistent);
var
  a : TDataRdRecReserveMagicChapterItem;
begin
  if Source is TDataRdRecReserveMagicChapterItem then begin
    a := TDataRdRecReserveMagicChapterItem(Source);
    inherited;
    FMode     := a.FMode;
  end
  else begin
    inherited;
  end;
end;

function TDataRdRecReserveMagicChapterItem.DataLoad(t: TStringListEx): Boolean;
begin
  inherited DataLoad(t);
  ModeStr   := t.GetStrs('Mode',ModeStr);
  result := True;
end;

function TDataRdRecReserveMagicChapterItem.DataSave(t: TStringListEx): Boolean;
begin
  inherited DataSave(t);
  t.SetStrs('Mode',ModeStr);
  result := True;
end;

function TDataRdRecReserveMagicChapterItem.GetModeStr: string;
begin
  result := RecPriorityModeToStr(FMode);
end;

procedure TDataRdRecReserveMagicChapterItem.SetModeStr(const Value: string);
begin
  FMode := StrToRecPriorityMode(Value);
end;

function StrToRecPriorityMode(const str : string) : TDataRdRecReserveMagicChapterItemMode;
var
  i : Integer;
begin
  result := dmcOff;
  for i := 0 to High(TDataRdRecReserveMagicChapterItemModeStr) do begin
    if TDataRdRecReserveMagicChapterItemModeStr[i] = str then begin
      result := TDataRdRecReserveMagicChapterItemMode(i);
      break;
    end;
  end;
end;

function RecPriorityModeToStr(const Mode : TDataRdRecReserveMagicChapterItemMode) : string;
var
  i : Integer;
begin
  i := Ord(Mode);
  result := TDataRdRecReserveMagicChapterItemModeStr[i];
end;


end.
