unit DataRdRecReserveList;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,CommInternet,ExtCtrls,DefaultData,DateTimeCtrl,
  StringListEx,DataTvStatus,DataRdRecReserveDateTime;

//--------------------------------------------------------------------------//
//  RDǗlXȃf[^NX                                          //
//--------------------------------------------------------------------------//
type
  TDataRdRecReserveListItem = class(TPersistent)
  private
    { Private 錾 }
    FNameList : string;                     // ^\ꗗŎgĂ\
    FNameInfo   : string;                   // ^\ڍ׏ŎgĂ\
    FValue     : string;                    // ^\ڍ׏Ŏgl
  public
    { Public 錾 }
    procedure Assign(Source : TPersistent) ; override;
    function DataLoad(t : TStringListEx) : Boolean;virtual;
    function DataSave(t : TStringListEx) : Boolean;virtual;

    property NameList : string read FNameList write FNameList;
    property NameInfo : string read FNameInfo write FNameInfo;
    property Value : string read FValue write FValue;
  end;

//--------------------------------------------------------------------------//
//  RDǗlXȈꗗǗNX                                  //
//--------------------------------------------------------------------------//
type
  TDataRdRecReserveListItemsEx = class(TList)
  private
    { Private 錾 }
  public
    { Public 錾 }
    destructor Destroy;override;
    procedure Delete(i : Integer);
    procedure Clear();override;

    function IndexOfValue(const Value: string) : Integer;
    function IndexOfInfo(const Info : string) : Integer;
    function IndexOfList(const List : string) : Integer;
  end;

//--------------------------------------------------------------------------//
//  RDǗlXȈꗗǗNX                                  //
//--------------------------------------------------------------------------//
type
  TDataRdRecReserveListItemsEx2 = class(TDataRdRecReserveListItemsEx)
  private
    { Private 錾 }
    function GetItems(Index: Integer): TDataRdRecReserveListItem;
  public
    { Public 錾 }
    procedure Assign(a : TDataRdRecReserveListItemsEx2);
    function Add() : TDataRdRecReserveListItem;
    property Items[Index: Integer] : TDataRdRecReserveListItem read GetItems;default;

  end;
//--------------------------------------------------------------------------//
//  RDǗlXȂǗNX                                      //
//--------------------------------------------------------------------------//
type
  TDataRdRecReserveList = class(TPersistent)
  private
    { Private 錾 }
    FItems : TDataRdRecReserveListItemsEx2;
  public
    { Public 錾 }
    constructor Create;
    destructor Destroy;override;

    procedure Assign(Source : TPersistent) ; override;

    property Items : TDataRdRecReserveListItemsEx2 read FItems;

    function DataLoad(ts : TStringListEx) : Boolean;
    function DataSave(ts : TStringListEx) : Boolean;

  end;

implementation

{ TDataRdRecReserveList }
constructor TDataRdRecReserveList.Create;
begin
  FItems := TDataRdRecReserveListItemsEx2.Create;
end;

destructor TDataRdRecReserveList.Destroy;
begin
  FItems.Free;
  inherited;
end;

procedure TDataRdRecReserveList.Assign(Source: TPersistent);
var
  a : TDataRdRecReserveList;
begin
  if Source is TDataRdRecReserveList then begin
    a := TDataRdRecReserveList(Source);
    FItems.Assign(a.FItems);
  end
  else begin
    inherited;
  end;
end;

function TDataRdRecReserveList.DataLoad(ts: TStringListEx): Boolean;
var
  i : Integer;
  d : TDataRdRecReserveListItem;
  t : TStringListEx;
begin
  t := TStringListEx.Create;
  try
    result := False;
    FItems.Clear;
    for i := 0 to ts.Count-1 do begin
      d := FItems.Add();
      t.CommaTextEx := ts[i];
      d.DataLoad(t);
    end;
    result := True;
  finally
    t.Free;
  end;
end;

function TDataRdRecReserveList.DataSave(ts: TStringListEx): Boolean;
var
  i : Integer;
  d : TDataRdRecReserveListItem;
  t : TStringListEx;
begin
  t := TStringListEx.Create;
  try
    result := False;
    for i := 0 to FItems.Count-1 do begin
      t.Clear;
      d := FItems[i];
      d.DataSave(t);
      ts.Add(t.CommaTextEx);
    end;
    result := True;
  finally
    t.Free;
  end;
end;

{ TDataRdRecReserveListItemsEx }

destructor TDataRdRecReserveListItemsEx.Destroy;
begin
  Clear();
  inherited;
end;

procedure TDataRdRecReserveListItemsEx.Clear;
var
  i : Integer;
begin
  for i := 0 to Count-1 do begin
    TDataRdRecReserveListItem(inherited Items[i]).Free;
  end;
  inherited;
end;

procedure TDataRdRecReserveListItemsEx.Delete(i: Integer);
begin
  TDataRdRecReserveListItem(inherited Items[i]).Free;
  inherited;
end;

function TDataRdRecReserveListItemsEx.IndexOfValue(
  const Value: string): Integer;
var
  i : Integer;
begin
  result := -1;
  for i := 0 to Count-1 do begin
    if TDataRdRecReserveListItem(inherited Items[i]).Value = Value then begin
      result := i;
      exit;
    end;
  end;
end;

function TDataRdRecReserveListItemsEx.IndexOfInfo(
  const Info: string): Integer;
var
  i : Integer;
begin
  result := -1;
  for i := 0 to Count-1 do begin
    if TDataRdRecReserveListItem(inherited Items[i]).NameInfo = Info then begin
      result := i;
      exit;
    end;
  end;
end;

function TDataRdRecReserveListItemsEx.IndexOfList(
  const List: string): Integer;
var
  i : Integer;
  d : TDataRdRecReserveListItem;
begin
  result := -1;
  for i := 0 to Count-1 do begin
    d := TDataRdRecReserveListItem(inherited Items[i]);
    if d.NameList = List then begin
      result := i;
      exit;
    end;
  end;
end;

{ TDataRdRecReserveListItem }

procedure TDataRdRecReserveListItem.Assign(Source: TPersistent);
var
  a : TDataRdRecReserveListItem;
begin
  if Source is TDataRdRecReserveListItem then begin
    a := TDataRdRecReserveListItem(Source);
    FNameList := a.FNameList;
    FNameInfo := a.FNameInfo;
    FValue    := a.FValue;
  end
  else begin
    inherited;
  end;
end;

function TDataRdRecReserveListItem.DataLoad(t: TStringListEx): Boolean;
begin
  FNameList := t.GetStrs('NameList',FNameList);
  FNameInfo := t.GetStrs('NameInfo',FNameInfo);
  FValue    := t.GetStrs('Value',FValue);
  result := True;
end;

function TDataRdRecReserveListItem.DataSave(t: TStringListEx): Boolean;
begin
  t.SetStrs('NameList',FNameList);
  t.SetStrs('NameInfo',FNameInfo);
  t.SetStrs('Value',FValue);
  result := True;
end;

{ TDataRdRecReserveListItemsEx }

function TDataRdRecReserveListItemsEx2.Add: TDataRdRecReserveListItem;
var
  d : TDataRdRecReserveListItem;
begin
  d := TDataRdRecReserveListItem.Create;
  inherited Add(d);
  result := d;
end;

procedure TDataRdRecReserveListItemsEx2.Assign(
  a: TDataRdRecReserveListItemsEx2);
var
  d : TDataRdRecReserveListItem;
  i : Integer;
begin
  Clear;
  for i := 0 to a.Count-1 do begin
    d := Add();
    d.Assign(a.Items[i]);
  end;
end;

function TDataRdRecReserveListItemsEx2.GetItems(
  Index: Integer): TDataRdRecReserveListItem;
begin
  result := inherited Items[Index];
end;

end.
