unit DataRdRecReserveLineVoice;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,CommInternet,ExtCtrls,DefaultData,DateTimeCtrl,
  StringListEx,DataTvStatus,DataRdRecReserveDateTime,
  DataRdRecReserveList;

//--------------------------------------------------------------------------//
//  C͐؂ւ                                                      //
//--------------------------------------------------------------------------//
type
  TDataRdRecReserveLineVoiceItemMode = (rlvStereo,rlvLeft,rlvRight,rlvLeftAndRight);
const
  TDataRdRecReserveLineVoiceItemModeStr : array[0..3] of string = ('Stereo','Left','Right','L_AND_R');

//--------------------------------------------------------------------------//
//  RDgpł鉹f[^NX                                          //
//--------------------------------------------------------------------------//
type
  TDataRdRecReserveLineVoiceItem = class(TDataRdRecReserveListItem)
  private
    { Private 錾 }
    FMode: TDataRdRecReserveLineVoiceItemMode;
    function GetModeStr: string;
    procedure SetModeStr(const Value: string);
  public
    { Public 錾 }
    procedure Assign(Source : TPersistent) ; override;
    function DataLoad(t : TStringListEx) : Boolean;override;
    function DataSave(t : TStringListEx) : Boolean;override;

    property Mode : TDataRdRecReserveLineVoiceItemMode read FMode write FMode;
    property ModeStr : string read GetModeStr write SetModeStr;
  end;

//--------------------------------------------------------------------------//
//  RDgpł鉹ꗗǗNX                                  //
//--------------------------------------------------------------------------//
type
  TDataRdRecReserveLineVoiceItems = class(TDataRdRecReserveListItemsEx)
  private
    { Private 錾 }
    function GetItems(Index: Integer): TDataRdRecReserveLineVoiceItem;
    function GetModes(
      Mode: TDataRdRecReserveLineVoiceItemMode): TDataRdRecReserveLineVoiceItem;
  public
    { Public 錾 }
    procedure Assign(a : TDataRdRecReserveLineVoiceItems) ;
    function Add() : TDataRdRecReserveLineVoiceItem;
    property Items[Index: Integer] : TDataRdRecReserveLineVoiceItem read GetItems;default;

    function IndexOfMode(Mode : TDataRdRecReserveLineVoiceItemMode) : Integer;
    function ModeToValue(Mode : TDataRdRecReserveLineVoiceItemMode) : string;
    property Modes[Mode : TDataRdRecReserveLineVoiceItemMode] : TDataRdRecReserveLineVoiceItem read GetModes;
  end;

//--------------------------------------------------------------------------//
//  RDgpł鉹ǗNX                                      //
//--------------------------------------------------------------------------//
type
  TDataRdRecReserveLineVoice = class(TPersistent)
  private
    { Private 錾 }
    FItems : TDataRdRecReserveLineVoiceItems;
  public
    { Public 錾 }
    constructor Create;
    destructor Destroy;override;

    procedure Assign(Source : TPersistent) ; override;

    property Items : TDataRdRecReserveLineVoiceItems read FItems;

    function DataLoad(ts : TStringListEx) : Boolean;
    function DataSave(ts : TStringListEx) : Boolean;

  end;

  function StrToLineVoiceMode(const str : string) : TDataRdRecReserveLineVoiceItemMode;
  function LineVoiceModeToStr(const Mode : TDataRdRecReserveLineVoiceItemMode) : string;

implementation

{ TDataRdRecReserveLineVoice }

constructor TDataRdRecReserveLineVoice.Create;
begin
  FItems := TDataRdRecReserveLineVoiceItems.Create;
end;

destructor TDataRdRecReserveLineVoice.Destroy;
begin
  FItems.Free;
  inherited;
end;

procedure TDataRdRecReserveLineVoice.Assign(Source: TPersistent);
var
  a : TDataRdRecReserveLineVoice;
begin
  if Source is TDataRdRecReserveLineVoice then begin
    a := TDataRdRecReserveLineVoice(Source);
    FItems.Assign(a.FItems);
  end
  else begin
    inherited;
  end;
end;

function TDataRdRecReserveLineVoice.DataLoad(ts: TStringListEx): Boolean;
var
  i : Integer;
  d : TDataRdRecReserveLineVoiceItem;
  t : TStringListEx;
begin
  t := TStringListEx.Create;
  try
    result := False;
    FItems.Clear;
    for i := 0 to ts.Count-1 do begin
      d := FItems.Add();
      t.CommaTextEx := ts[i];
      d.DataLoad(t);
    end;
    result := True;
  finally
    t.Free;
  end;
end;

function TDataRdRecReserveLineVoice.DataSave(ts: TStringListEx): Boolean;
var
  i : Integer;
  d : TDataRdRecReserveLineVoiceItem;
  t : TStringListEx;
begin
  t := TStringListEx.Create;
  try
    result := False;
    for i := 0 to FItems.Count-1 do begin
      t.Clear;
      d := FItems[i];
      d.DataSave(t);
      ts.Add(t.CommaTextEx);
    end;
    result := True;
  finally
    t.Free;
  end;
end;

{ TDataRdRecReserveLineVoiceItems }

function TDataRdRecReserveLineVoiceItems.Add: TDataRdRecReserveLineVoiceItem;
var
  d : TDataRdRecReserveLineVoiceItem;
begin
  d := TDataRdRecReserveLineVoiceItem.Create;
  inherited Add(d);
  result := d;
end;

procedure TDataRdRecReserveLineVoiceItems.Assign(
  a: TDataRdRecReserveLineVoiceItems);
var
  d : TDataRdRecReserveLineVoiceItem;
  i : Integer;
begin
  Clear;
  for i := 0 to a.Count-1 do begin
    d := Add();
    d.Assign(a.Items[i]);
  end;
end;

function TDataRdRecReserveLineVoiceItems.GetItems(
  Index: Integer): TDataRdRecReserveLineVoiceItem;
begin
  result := inherited Items[Index];
end;

function TDataRdRecReserveLineVoiceItems.GetModes(
  Mode: TDataRdRecReserveLineVoiceItemMode): TDataRdRecReserveLineVoiceItem;
var
  i : Integer;
begin
  result := nil;
  i := IndexOfMode(Mode);
  if i = -1 then exit;
  result := Items[i];
end;

function TDataRdRecReserveLineVoiceItems.IndexOfMode(
  Mode: TDataRdRecReserveLineVoiceItemMode): Integer;
var
  i : Integer;
begin
  result := -1;
  for i := 0 to Count-1 do begin
    if Items[i].Mode = Mode then begin
      result := i;
      exit;
    end;
  end;
end;

function TDataRdRecReserveLineVoiceItems.ModeToValue(
  Mode: TDataRdRecReserveLineVoiceItemMode): string;
var
  i : Integer;
begin
  result := '';
  i := IndexOfMode(Mode);
  if i = -1 then exit;
  result := Items[i].Value;
end;

{ TDataRdRecReserveLineVoiceItem }

procedure TDataRdRecReserveLineVoiceItem.Assign(Source: TPersistent);
var
  a : TDataRdRecReserveLineVoiceItem;
begin
  if Source is TDataRdRecReserveLineVoiceItem then begin
    a := TDataRdRecReserveLineVoiceItem(Source);
    inherited;
    FMode     := a.FMode;
  end
  else begin
    inherited;
  end;
end;

function TDataRdRecReserveLineVoiceItem.DataLoad(
  t: TStringListEx): Boolean;
begin
  inherited DataLoad(t);
  ModeStr   := t.GetStrs('Mode',ModeStr);
  result := True;
end;

function TDataRdRecReserveLineVoiceItem.DataSave(
  t: TStringListEx): Boolean;
begin
  inherited DataSave(t);
  t.SetStrs('Mode',ModeStr);
  result := True;
end;

function TDataRdRecReserveLineVoiceItem.GetModeStr: string;
var
  i : Integer;
begin
  i := Ord(FMode);
  result := TDataRdRecReserveLineVoiceItemModeStr[i];
end;

procedure TDataRdRecReserveLineVoiceItem.SetModeStr(const Value: string);
var
  i : Integer;
begin
  FMode := rlvStereo;
  for i := 0 to High(TDataRdRecReserveLineVoiceItemModeStr) do begin
    if TDataRdRecReserveLineVoiceItemModeStr[i] = Value then begin
      FMode := TDataRdRecReserveLineVoiceItemMode(i);
      break;
    end;
  end;
end;

function StrToLineVoiceMode(const str : string) : TDataRdRecReserveLineVoiceItemMode;
var
  i : Integer;
begin
  result := rlvStereo;
  for i := 0 to High(TDataRdRecReserveLineVoiceItemModeStr) do begin
    if TDataRdRecReserveLineVoiceItemModeStr[i] = str then begin
      result := TDataRdRecReserveLineVoiceItemMode(i);
      break;
    end;
  end;
end;

function LineVoiceModeToStr(const Mode : TDataRdRecReserveLineVoiceItemMode) : string;
var
  i : Integer;
begin
  i := Ord(Mode);
  result := TDataRdRecReserveLineVoiceItemModeStr[i];
end;

end.
