unit DataRdRecReserveInfo;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,CommInternet,ExtCtrls,DefaultData,DateTimeCtrl,StringListKey,
  StringListEx,DataRdRecReserveFolder,DataRdRecReserveRate,DataRdRecReserveAudio,
  DataRdRecReserveChannel,DataRdRecReserveGenru,DataRdRecReserveMedia,
  DataRdRecReserveDvdr,DataRdRecReserveAspect,DataRdRecReserveChapterMultiVoice,
  DataRdRecReserveLineVoice,DataRdRecReserveEncode,DataRdRecReserveDvdChapter,
  DataRdRecReserveRecPriority,DataRdRecReserveMagicChapter,
  DataRdRecReserveMuteChapter,DataRdRecReserveCmChapter,DataRdRecReserveTitleLink;

//--------------------------------------------------------------------------//
//  RDPŋʂ̏ǗNX                                      //
//--------------------------------------------------------------------------//
type
  TDataRdRecReserveInfo = class(TPersistent)
  private
    { Private 錾 }
    FFolders : TDataRdRecReserveFolder;                  // tH_ꗗ
    FBCMedhia: TDataRdRecReserveChannel;                 // ʂ̎ށinAiAnfWABSACSj
    FChannels : TDataRdRecReserveChannel;                // qcgpł`lꗗ
    FGenres : TDataRdRecReserveGenre;                    // Wꗗ
    FRates: TDataRdRecReserveRate;                       // 掿[gꗗ
    FAudio: TDataRdRecReserveAudio;                      // 
    FMedia: TDataRdRecReserveMedia;                      // ^惁fBA
    FDvdr: TDataRdRecReserveDvdr;                        // cuc݊[h
    FAspect : TDataRdRecReserveAspect;                   // L^ʔ䗦
    FCapMultiVoice : TDataRdRecReserveChapterMultiVoice; // `v^[idj
    FLineVoice : TDataRdRecReserveLineVoice;             // CI
    FEncode : TDataRdRecReserveEncode;                   // GR[_ꗗ
    FDvdChapter : TDataRdRecReserveDvdChapter;           // DVD`v^[
    FRecPriority : TDataRdRecReserveRecPriority;         // ^Dx
    FMagicChapter: TDataRdRecReserveMagicChapter;        // }WbN`v^[
    FMuteChapter: TDataRdRecReserveMuteChapter;          // `v^[
    FCmChapter : TDataRdRecReserveCmChapter;             // {Ҏ`v^[
    FTitleLink : TDataRdRecReserveTitleLink;             // ԑgǂ
    FChanged: Boolean;                                   // True : f[^ύXꂽigpj
  public
    { Public 錾 }
    constructor Create();
    destructor Destroy;override;
    procedure Assign(Source : TPersistent) ; override;

    function DataSave(tk : TStringListKey;Name : string) : Boolean;
    function DataLoad(tk : TStringListKey;Name : string) : Boolean;
    // tH_ꗗ
    property Folders : TDataRdRecReserveFolder read FFolders;
    // ʂ̎ށinAiAnfWABSACSj
    property BCMedhia : TDataRdRecReserveChannel read FBCMedhia;
    // qcgpł`lꗗ
    property Channels : TDataRdRecReserveChannel read FChannels;
    // Wꗗ
    property Genres : TDataRdRecReserveGenre read FGenres;
    // 掿[gꗗ
    property Rates : TDataRdRecReserveRate read FRates;
    // 
    property Audio : TDataRdRecReserveAudio read FAudio;
    // ^惁fBA
    property Media : TDataRdRecReserveMedia read FMedia;
    // cuc݊[h
    property Dvdr : TDataRdRecReserveDvdr read FDvdr;
    // L^ʔ䗦
    property Aspect : TDataRdRecReserveAspect read FAspect;
    // `v^[idj
    property CapMultiVoice : TDataRdRecReserveChapterMultiVoice read FCapMultiVoice;
    // CI
    property LineVoice : TDataRdRecReserveLineVoice read FLineVoice;
    // CI
    property Encode : TDataRdRecReserveEncode read FEncode;
    // DVD`v^[
    property DvdChapter : TDataRdRecReserveDvdChapter read FDvdChapter;
    // ^Dx
    property RecPriority : TDataRdRecReserveRecPriority read FRecPriority;
    // }WbN`v^[
    property MagicChapter : TDataRdRecReserveMagicChapter read FMagicChapter;
    // `v^[
    property MuteChapter : TDataRdRecReserveMuteChapter read FMuteChapter;
    // {Ҏ`v^[
    property CmChapter : TDataRdRecReserveCmChapter read FCmChapter;
    // ԑgǂ
    property TitleLink : TDataRdRecReserveTitleLink read FTitleLink;
    // True : f[^ύXꂽigpj
    property Changed : Boolean read FChanged write FChanged;
  end;

implementation

{ TDataRdRecReserveInfo }

constructor TDataRdRecReserveInfo.Create;
begin
  FFolders := TDataRdRecReserveFolder.Create;
  FChannels := TDataRdRecReserveChannel.Create;
  FGenres := TDataRdRecReserveGenre.Create;
  FBCMedhia := TDataRdRecReserveChannel.Create;
  FRates := TDataRdRecReserveRate.Create;
  FAudio := TDataRdRecReserveAudio.Create;
  FMedia := TDataRdRecReserveMedia.Create;
  FDvdr := TDataRdRecReserveDvdr.Create;
  FAspect := TDataRdRecReserveAspect.Create;
  FCapMultiVoice := TDataRdRecReserveChapterMultiVoice.Create;
  FLineVoice := TDataRdRecReserveLineVoice.Create;
  FEncode := TDataRdRecReserveEncode.Create;
  FDvdChapter := TDataRdRecReserveDvdChapter.Create;
  FRecPriority := TDataRdRecReserveRecPriority.Create;
  FMagicChapter := TDataRdRecReserveMagicChapter.Create;
  FMuteChapter := TDataRdRecReserveMuteChapter.Create;
  FCmChapter := TDataRdRecReserveCmChapter.Create;
  FTitleLink := TDataRdRecReserveTitleLink.Create;
end;

destructor TDataRdRecReserveInfo.Destroy;
begin
  FTitleLink.Free;
  FCmChapter.Free;
  FMuteChapter.Free;
  FMagicChapter.Free;
  FRecPriority.Free;
  FDvdChapter.Free;
  FEncode.Free;
  FLineVoice.Free;
  FCapMultiVoice.Free;
  FAspect.Free;
  FDvdr.Free;
  FMedia.Free;
  FAudio.Free;
  FRates.Free;
  FBCMedhia.Free;
  FGenres.Free;
  FChannels.Free;
  FFolders.Free;
  inherited;
end;

procedure TDataRdRecReserveInfo.Assign(Source: TPersistent);
var
  a : TDataRdRecReserveInfo;
begin
  if Source is TDataRdRecReserveInfo then begin
    a := TDataRdRecReserveInfo(Source);
    FFolders.Assign(a.FFolders);
    FChannels.Assign(a.FChannels);
    FGenres.Assign(a.FGenres);
    FBCMedhia.Assign(a.FBCMedhia);
    FRates.Assign(a.FRates);
    FAudio.Assign(a.FAudio);
    FMedia.Assign(a.FMedia);
    FDvdr.Assign(a.FDvdr);
    FAspect.Assign(a.FAspect);
    FCapMultiVoice.Assign(a.FCapMultiVoice);
    FLineVoice.Assign(a.FLineVoice);
    FEncode.Assign(a.FEncode);
    FDvdChapter.Assign(a.FDvdChapter);
    FRecPriority.Assign(a.FRecPriority);
    FMagicChapter.Assign(a.FMagicChapter);
    FMuteChapter.Assign(a.FMuteChapter);
    FCmChapter.Assign(a.FCmChapter);
    FTitleLink.Assign(a.FTitleLink);
  end
  else begin
    inherited;
  end;
end;

function TDataRdRecReserveInfo.DataLoad(tk: TStringListKey;
  Name: string): Boolean;
var
  ts : TStringListEx;
begin
  //ts := TStringListEx.Create;
  try
    result := False;
    ts := tk.Values[Name + '_BCMedhia'];
    if ts <> nil then begin
      FBCMedhia.DataLoad(ts);
    end;
    ts := tk.Values[Name + '_Channel'];
    if ts <> nil then begin
      FChannels.DataLoad(ts);
    end;
    ts := tk.Values[Name + '_Folder'];
    if ts <> nil then begin
      FFolders.DataLoad(ts);
    end;
    ts := tk.Values[Name + '_Genre'];
    if ts <> nil then begin
      FGenres.DataLoad(ts);
    end;
    ts := tk.Values[Name + '_Rate'];
    if ts <> nil then begin
      FRates.DataLoad(ts);
    end;
    ts := tk.Values[Name + '_Audio'];
    if ts <> nil then begin
      FAudio.DataLoad(ts);
    end;
    ts := tk.Values[Name + '_Media'];
    if ts <> nil then begin
      FMedia.DataLoad(ts);
    end;
    ts := tk.Values[Name + '_Dvdr'];
    if ts <> nil then begin
      FDvdr.DataLoad(ts);
    end;
    ts := tk.Values[Name + '_Aspect'];
    if ts <> nil then begin
      FAspect.DataLoad(ts);
    end;
    ts := tk.Values[Name + '_ChapterMultiVoice'];
    if ts <> nil then begin
      FCapMultiVoice.DataLoad(ts);
    end;
    ts := tk.Values[Name + '_LineVoice'];
    if ts <> nil then begin
      FLineVoice.DataLoad(ts);
    end;
    ts := tk.Values[Name + '_Encode'];
    if ts <> nil then begin
      FEncode.DataLoad(ts);
    end;
    ts := tk.Values[Name + '_DvdChapter'];
    if ts <> nil then begin
      FDvdChapter.DataLoad(ts);
    end;
    ts := tk.Values[Name + '_RecPriority'];
    if ts <> nil then begin
      FRecPriority.DataLoad(ts);
    end;
    ts := tk.Values[Name + '_MagicChapter'];
    if ts <> nil then begin
      FMagicChapter.DataLoad(ts);
    end;
    ts := tk.Values[Name + '_MuteChapter'];
    if ts <> nil then begin
      FMuteChapter.DataLoad(ts);
    end;
    ts := tk.Values[Name + '_CmChapter'];
    if ts <> nil then begin
      FCmChapter.DataLoad(ts);
    end;
    ts := tk.Values[Name + '_TitleLink'];
    if ts <> nil then begin
      FTitleLink.DataLoad(ts);
    end;
    result := True;
  finally
   // ts.Free;
  end;
end;

function TDataRdRecReserveInfo.DataSave(tk: TStringListKey;
  Name: string): Boolean;
var
  ts : TStringListEx;
begin
  ts := TStringListEx.Create;
  try
    result := False;
    ts.Clear;
    FBCMedhia.DataSave(ts);
    tk.Add(Name + '_BCMedhia',ts);
    ts.Clear;
    FChannels.DataSave(ts);
    tk.Add(Name + '_Channel',ts);
    ts.Clear;
    FFolders.DataSave(ts);
    tk.Add(Name + '_Folder',ts);
    ts.Clear;
    FGenres.DataSave(ts);
    tk.Add(Name + '_Genre',ts);
    ts.Clear;
    FRates.DataSave(ts);
    tk.Add(Name + '_Rate',ts);
    ts.Clear;
    FAudio.DataSave(ts);
    tk.Add(Name + '_Audio',ts);
    ts.Clear;
    FMedia.DataSave(ts);
    tk.Add(Name + '_Media',ts);
    ts.Clear;
    FDvdr.DataSave(ts);
    tk.Add(Name + '_Dvdr',ts);
    ts.Clear;
    FAspect.DataSave(ts);
    tk.Add(Name + '_Aspect',ts);
    ts.Clear;
    FCapMultiVoice.DataSave(ts);
    tk.Add(Name + '_ChapterMultiVoice',ts);
    ts.Clear;
    FLineVoice.DataSave(ts);
    tk.Add(Name + '_LineVoice',ts);
    ts.Clear;
    FEncode.DataSave(ts);
    tk.Add(Name + '_Encode',ts);
    ts.Clear;
    FDvdChapter.DataSave(ts);
    tk.Add(Name + '_DvdChapter',ts);
    ts.Clear;
    FRecPriority.DataSave(ts);
    tk.Add(Name + '_RecPriority',ts);
    ts.Clear;
    FMagicChapter.DataSave(ts);
    tk.Add(Name + '_MagicChapter',ts);
    ts.Clear;
    FMuteChapter.DataSave(ts);
    tk.Add(Name + '_MuteChapter',ts);
    ts.Clear;
    FCmChapter.DataSave(ts);
    tk.Add(Name + '_CmChapter',ts);
    ts.Clear;
    FTitleLink.DataSave(ts);
    tk.Add(Name + '_TitleLink',ts);
    result := True;
  finally
    ts.Free;
  end;
end;

end.
