unit DataRdRecReserveGenru;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,CommInternet,ExtCtrls,DefaultData,DateTimeCtrl,
  StringListEx,DataTvStatus,DataRdRecReserveDateTime,
  DataRdRecReserveList,DataTvScheduleGenre;

//--------------------------------------------------------------------------//
//  RDgpł鉹f[^NX                                          //
//--------------------------------------------------------------------------//
type
  TDataRdRecReserveGenreItem = class(TDataRdRecReserveListItem)
  private
    { Private 錾 }
    FMode: TDataTvScheduleGenre;
    function GetModeStr: string;
    procedure SetModeStr(const Value: string);
  public
    { Public 錾 }
    procedure Assign(Source : TPersistent) ; override;
    function DataLoad(t : TStringListEx) : Boolean;override;
    function DataSave(t : TStringListEx) : Boolean;override;

    property Mode : TDataTvScheduleGenre read FMode write FMode;
    property ModeStr : string read GetModeStr write SetModeStr;
  end;

//--------------------------------------------------------------------------//
//  RDgpłWǗNX                                  //
//--------------------------------------------------------------------------//
type
  TDataRdRecReserveGenreItems = class(TDataRdRecReserveListItemsEx)
  private
    { Private 錾 }
    function GetItems(Index: Integer): TDataRdRecReserveGenreItem;
    function GetModes(
      Mode: TDataTvScheduleGenre): TDataRdRecReserveGenreItem;
  public
    { Public 錾 }
    procedure Assign(a : TDataRdRecReserveGenreItems);
    function Add() : TDataRdRecReserveGenreItem;
    property Items[Index: Integer] : TDataRdRecReserveGenreItem read GetItems;default;

    function IndexOfMode(Mode : TDataTvScheduleGenre) : Integer;
    function ModeToValue(Mode : TDataTvScheduleGenre) : Integer;
    property Modes[Mode : TDataTvScheduleGenre] : TDataRdRecReserveGenreItem read GetModes;
  end;

//--------------------------------------------------------------------------//
//  RDǗĂWǗNX                                //
//--------------------------------------------------------------------------//
type
  TDataRdRecReserveGenre = class(TPersistent)
  private
    { Private 錾 }
    FItems : TDataRdRecReserveGenreItems;
  public
    { Public 錾 }
    constructor Create;
    destructor Destroy;override;

    procedure Assign(Source : TPersistent) ; override;

    property Items : TDataRdRecReserveGenreItems read FItems;

    function DataLoad(ts : TStringListEx) : Boolean;
    function DataSave(ts : TStringListEx) : Boolean;

  end;

  function StrToGenreMode(const str : string) : TDataTvScheduleGenre;
  function GenreModeToStr(const Mode : TDataTvScheduleGenre) : string;

implementation

{ TDataRdRecReserveGenre }

constructor TDataRdRecReserveGenre.Create;
begin
  FItems := TDataRdRecReserveGenreItems.Create;
end;

destructor TDataRdRecReserveGenre.Destroy;
begin
  FItems.Free;
  inherited;
end;

procedure TDataRdRecReserveGenre.Assign(Source: TPersistent);
var
  a : TDataRdRecReserveGenre;
begin
  if Source is TDataRdRecReserveGenre then begin
    a := TDataRdRecReserveGenre(Source);
    FItems.Assign(a.FItems);
  end
  else begin
    inherited;
  end;
end;

function TDataRdRecReserveGenre.DataLoad(ts: TStringListEx): Boolean;
var
  i : Integer;
  d : TDataRdRecReserveGenreItem;
  t : TStringListEx;
begin
  t := TStringListEx.Create;
  try
    result := False;
    FItems.Clear;
    for i := 0 to ts.Count-1 do begin
      d := FItems.Add();
      t.CommaTextEx := ts[i];
      d.DataLoad(t);
    end;
    result := True;
  finally
    t.Free;
  end;
end;

function TDataRdRecReserveGenre.DataSave(ts: TStringListEx): Boolean;
var
  i : Integer;
  d : TDataRdRecReserveGenreItem;
  t : TStringListEx;
begin
  t := TStringListEx.Create;
  try
    result := False;
    for i := 0 to FItems.Count-1 do begin
      t.Clear;
      d := FItems[i];
      d.DataSave(t);
      ts.Add(t.CommaTextEx);
    end;
    result := True;
  finally
    t.Free;
  end;
end;

{ TDataRdRecReserveGenreItems }

function TDataRdRecReserveGenreItems.Add: TDataRdRecReserveGenreItem;
var
  d : TDataRdRecReserveGenreItem;
begin
  d := TDataRdRecReserveGenreItem.Create;
  inherited Add(d);
  result := d;
end;

procedure TDataRdRecReserveGenreItems.Assign(
  a: TDataRdRecReserveGenreItems);
var
  d : TDataRdRecReserveGenreItem;
  i : Integer;
begin
  Clear;
  for i := 0 to a.Count-1 do begin
    d := Add();
    d.Assign(a.Items[i]);
  end;
end;

function TDataRdRecReserveGenreItems.GetItems(
  Index: Integer): TDataRdRecReserveGenreItem;
begin
  result := inherited Items[Index];
end;

function TDataRdRecReserveGenreItems.GetModes(
  Mode: TDataTvScheduleGenre): TDataRdRecReserveGenreItem;
var
  i : Integer;
begin
  result := nil;
  i := IndexOfMode(Mode);
  if i = -1 then exit;
  result := Items[i];
end;

function TDataRdRecReserveGenreItems.IndexOfMode(
  Mode: TDataTvScheduleGenre): Integer;
var
  i : Integer;
begin
  result := -1;
  for i := 0 to Count-1 do begin
    if Items[i].Mode = Mode then begin
      result := i;
      exit;
    end;
  end;
end;

function TDataRdRecReserveGenreItems.ModeToValue(
  Mode: TDataTvScheduleGenre): Integer;
var
  i : Integer;
begin
  result := High(TDataTvScheduleGenreStr);
  i := IndexOfMode(Mode);
  if i = -1 then exit;
  result := StrToIntDef(Items[i].Value,0);
end;

{ TDataRdRecReserveGenreItem }

procedure TDataRdRecReserveGenreItem.Assign(Source: TPersistent);
var
  a : TDataRdRecReserveGenreItem;
begin
  if Source is TDataRdRecReserveGenreItem then begin
    a := TDataRdRecReserveGenreItem(Source);
    inherited;
    FMode     := a.FMode;
  end
  else begin
    inherited;
  end;
end;

function TDataRdRecReserveGenreItem.DataLoad(t: TStringListEx): Boolean;
begin
  inherited DataLoad(t);
  ModeStr   := t.GetStrs('Mode',ModeStr);
  result := True;
end;

function TDataRdRecReserveGenreItem.DataSave(t: TStringListEx): Boolean;
begin
  inherited DataSave(t);
  t.SetStrs('Mode',ModeStr);
  result := True;
end;

function TDataRdRecReserveGenreItem.GetModeStr: string;
begin
  result := GenreModeToStr(FMode);
end;

procedure TDataRdRecReserveGenreItem.SetModeStr(const Value: string);
begin
  FMode := StrToGenreMode(Value);
end;

function StrToGenreMode(const str : string) : TDataTvScheduleGenre;
var
  i : Integer;
begin
  result := rgEtc;
  for i := 0 to High(TDataTvScheduleGenreStr) do begin
    if TDataTvScheduleGenreStr[i] = str then begin
      result := TDataTvScheduleGenre(i);
      break;
    end;
  end;
end;

function GenreModeToStr(const Mode : TDataTvScheduleGenre) : string;
var
  i : Integer;
begin
  i := Ord(Mode);
  result := TDataTvScheduleGenreStr[i];
end;

end.
