unit DataRdRecReserveFolder;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,CommInternet,ExtCtrls,DefaultData,DateTimeCtrl,
  StringListEx,DataTvStatus,DataRdRecReserveDateTime,
  DataRdRecReserveList;

//--------------------------------------------------------------------------//
//  RDgpł鉹f[^NX                                          //
//--------------------------------------------------------------------------//
type
  TDataRdRecReserveFolderItem = class(TDataRdRecReserveListItem)
  private
    { Private 錾 }
  public
    { Public 錾 }
  end;

//--------------------------------------------------------------------------//
//  RDgpłtH_ǗNX                                  //
//--------------------------------------------------------------------------//
type
  TDataRdRecReserveFolderItems = class(TDataRdRecReserveListItemsEx)
  private
    { Private 錾 }
    function GetItems(Index: Integer): TDataRdRecReserveFolderItem;
  public
    { Public 錾 }
    procedure Assign(a : TDataRdRecReserveFolderItems);
    function Add() : TDataRdRecReserveFolderItem;
    property Items[Index: Integer] : TDataRdRecReserveFolderItem read GetItems;default;

  end;

//--------------------------------------------------------------------------//
//  RDǗĂtH_ǗNX                                //
//--------------------------------------------------------------------------//
type
  TDataRdRecReserveFolder = class(TPersistent)
  private
    { Private 錾 }
    FItems : TDataRdRecReserveFolderItems;
  public
    { Public 錾 }
    constructor Create;
    destructor Destroy;override;

    procedure Assign(Source : TPersistent) ; override;

    property Items : TDataRdRecReserveFolderItems read FItems;

    function DataLoad(ts : TStringListEx) : Boolean;
    function DataSave(ts : TStringListEx) : Boolean;

  end;

implementation

{ TDataRdRecReserveFolder }

constructor TDataRdRecReserveFolder.Create;
begin
  FItems := TDataRdRecReserveFolderItems.Create;
end;

destructor TDataRdRecReserveFolder.Destroy;
begin
  FItems.Free;
  inherited;
end;

procedure TDataRdRecReserveFolder.Assign(Source: TPersistent);
var
  a : TDataRdRecReserveFolder;
begin
  if Source is TDataRdRecReserveFolder then begin
    a := TDataRdRecReserveFolder(Source);
    FItems.Assign(a.FItems);
  end
  else begin
    inherited;
  end;
end;

function TDataRdRecReserveFolder.DataLoad(ts: TStringListEx): Boolean;
var
  i : Integer;
  d : TDataRdRecReserveFolderItem;
  t : TStringListEx;
begin
  t := TStringListEx.Create;
  try
    result := False;
    FItems.Clear;
    for i := 0 to ts.Count-1 do begin
      d := FItems.Add();
      t.CommaTextEx := ts[i];
      d.DataLoad(t);
    end;
    result := True;
  finally
    t.Free;
  end;
end;

function TDataRdRecReserveFolder.DataSave(ts: TStringListEx): Boolean;
var
  i : Integer;
  d : TDataRdRecReserveListItem;
  t : TStringListEx;
begin
  t := TStringListEx.Create;
  try
    result := False;
    for i := 0 to FItems.Count-1 do begin
      t.Clear;
      d := FItems[i];
      d.DataSave(t);
      ts.Add(t.CommaTextEx);
    end;
    result := True;
  finally
    t.Free;
  end;
end;

{ TDataRdRecReserveFolderItems }

procedure TDataRdRecReserveFolderItems.Assign(
  a: TDataRdRecReserveFolderItems);
var
  d : TDataRdRecReserveFolderItem;
  i : Integer;
begin
  Clear;
  for i := 0 to a.Count-1 do begin
    d := Add();
    d.Assign(a.Items[i]);
  end;
end;

function TDataRdRecReserveFolderItems.Add: TDataRdRecReserveFolderItem;
var
  d : TDataRdRecReserveFolderItem;
begin
  d := TDataRdRecReserveFolderItem.Create;
  inherited Add(d);
  result := d;
end;

function TDataRdRecReserveFolderItems.GetItems(
  Index: Integer): TDataRdRecReserveFolderItem;
begin
  result := inherited Items[Index];
end;

end.
