unit DataRdRecReserveEncode;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,CommInternet,ExtCtrls,DefaultData,DateTimeCtrl,
  StringListEx,DataTvStatus,DataRdRecReserveDateTime,
  DataRdRecReserveList;

//--------------------------------------------------------------------------//
//  GR[_[                                                            //
//--------------------------------------------------------------------------//
type
  TDataRdRecReserveEncodeItemMode =    (encR1,encR2,encTS1,encTS2,encVR);
const
  TDataRdRecReserveEncodeItemModeStr : array[0..4] of string = ('R1','R2','TS1','TS2','VR');

//--------------------------------------------------------------------------//
//  RDgpł鉹f[^NX                                          //
//--------------------------------------------------------------------------//
type
  TDataRdRecReserveEncodeItem = class(TDataRdRecReserveListItem)
  private
    { Private 錾 }
    FMode: TDataRdRecReserveEncodeItemMode;
    function GetModeStr: string;
    procedure SetModeStr(const Value: string);
  public
    { Public 錾 }
    procedure Assign(Source : TPersistent) ; override;
    function DataLoad(t : TStringListEx) : Boolean;override;
    function DataSave(t : TStringListEx) : Boolean;override;

    property Mode : TDataRdRecReserveEncodeItemMode read FMode write FMode;
    property ModeStr : string read GetModeStr write SetModeStr;
  end;

//--------------------------------------------------------------------------//
//  RDgpł鉹ꗗǗNX                                  //
//--------------------------------------------------------------------------//
type
  TDataRdRecReserveEncodeItems = class(TDataRdRecReserveListItemsEx)
  private
    { Private 錾 }
    function GetItems(Index: Integer): TDataRdRecReserveEncodeItem;
    function GetModes(
      Mode: TDataRdRecReserveEncodeItemMode): TDataRdRecReserveEncodeItem;
  public
    { Public 錾 }
    procedure Assign(a : TDataRdRecReserveEncodeItems) ;
    function Add() : TDataRdRecReserveEncodeItem;
    property Items[Index: Integer] : TDataRdRecReserveEncodeItem read GetItems;default;
    function IndexOfMode(Mode : TDataRdRecReserveEncodeItemMode) : Integer;
    function ModeToValue(Mode : TDataRdRecReserveEncodeItemMode) : string;
    property Modes[Mode : TDataRdRecReserveEncodeItemMode] : TDataRdRecReserveEncodeItem read GetModes;
  end;

//--------------------------------------------------------------------------//
//  RDgpłGR[_ǗNX                                //
//--------------------------------------------------------------------------//
type
  TDataRdRecReserveEncode = class(TPersistent)
  private
    { Private 錾 }
    FItems : TDataRdRecReserveEncodeItems;
  public
    { Public 錾 }
    constructor Create;
    destructor Destroy;override;

    procedure Assign(Source : TPersistent) ; override;

    property Items : TDataRdRecReserveEncodeItems read FItems;

    function DataLoad(ts : TStringListEx) : Boolean;
    function DataSave(ts : TStringListEx) : Boolean;

  end;

  function StrToEncodeMode(const str : string) : TDataRdRecReserveEncodeItemMode;
  function EncodeModeToStr(const Mode : TDataRdRecReserveEncodeItemMode) : string;

implementation

{ TDataRdRecReserveEncode }

constructor TDataRdRecReserveEncode.Create;
begin
  FItems := TDataRdRecReserveEncodeItems.Create;
end;

destructor TDataRdRecReserveEncode.Destroy;
begin
  FItems.Free;
  inherited;
end;

procedure TDataRdRecReserveEncode.Assign(Source: TPersistent);
var
  a : TDataRdRecReserveEncode;
begin
  if Source is TDataRdRecReserveEncode then begin
    a := TDataRdRecReserveEncode(Source);
    FItems.Assign(a.FItems);
  end
  else begin
    inherited;
  end;
end;

function TDataRdRecReserveEncode.DataLoad(ts: TStringListEx): Boolean;
var
  i : Integer;
  d : TDataRdRecReserveEncodeItem;
  t : TStringListEx;
begin
  t := TStringListEx.Create;
  try
    result := False;
    FItems.Clear;
    for i := 0 to ts.Count-1 do begin
      d := FItems.Add();
      t.CommaTextEx := ts[i];
      d.DataLoad(t);
    end;
    result := True;
  finally
    t.Free;
  end;
end;

function TDataRdRecReserveEncode.DataSave(ts: TStringListEx): Boolean;
var
  i : Integer;
  d : TDataRdRecReserveEncodeItem;
  t : TStringListEx;
begin
  t := TStringListEx.Create;
  try
    result := False;
    for i := 0 to FItems.Count-1 do begin
      t.Clear;
      d := FItems[i];
      d.DataSave(t);
      ts.Add(t.CommaTextEx);
    end;
    result := True;
  finally
    t.Free;
  end;
end;

{ TDataRdRecReserveEncodeItems }

function TDataRdRecReserveEncodeItems.Add: TDataRdRecReserveEncodeItem;
var
  d : TDataRdRecReserveEncodeItem;
begin
  d := TDataRdRecReserveEncodeItem.Create;
  inherited Add(d);
  result := d;
end;

procedure TDataRdRecReserveEncodeItems.Assign(
  a: TDataRdRecReserveEncodeItems);
var
  d : TDataRdRecReserveEncodeItem;
  i : Integer;
begin
  Clear;
  for i := 0 to a.Count-1 do begin
    d := Add();
    d.Assign(a.Items[i]);
  end;
end;

function TDataRdRecReserveEncodeItems.GetItems(
  Index: Integer): TDataRdRecReserveEncodeItem;
begin
  result := inherited Items[Index];
end;

function TDataRdRecReserveEncodeItems.GetModes(
  Mode: TDataRdRecReserveEncodeItemMode): TDataRdRecReserveEncodeItem;
var
  i : Integer;
begin
  result := nil;
  i := IndexOfMode(Mode);
  if i = -1 then exit;
  result := Items[i];
end;

function TDataRdRecReserveEncodeItems.IndexOfMode(
  Mode: TDataRdRecReserveEncodeItemMode): Integer;
var
  i : Integer;
begin
  result := -1;
  for i := 0 to Count-1 do begin
    if Items[i].Mode = Mode then begin
      result := i;
      exit;
    end;
  end;
end;

function TDataRdRecReserveEncodeItems.ModeToValue(
  Mode: TDataRdRecReserveEncodeItemMode): string;
var
  i : Integer;
begin
  result := '';
  i := IndexOfMode(Mode);
  if i = -1 then exit;
  result := Items[i].Value;
end;

{ TDataRdRecReserveEncodeItem }

procedure TDataRdRecReserveEncodeItem.Assign(Source: TPersistent);
var
  a : TDataRdRecReserveEncodeItem;
begin
  if Source is TDataRdRecReserveEncodeItem then begin
    a := TDataRdRecReserveEncodeItem(Source);
    inherited;
    FMode     := a.FMode;
  end
  else begin
    inherited;
  end;
end;

function TDataRdRecReserveEncodeItem.DataLoad(t: TStringListEx): Boolean;
begin
  inherited DataLoad(t);
  ModeStr   := t.GetStrs('Mode',ModeStr);
  result := True;
end;

function TDataRdRecReserveEncodeItem.DataSave(t: TStringListEx): Boolean;
begin
  inherited DataSave(t);
  t.SetStrs('Mode',ModeStr);
  result := True;
end;

function TDataRdRecReserveEncodeItem.GetModeStr: string;
begin
  result := EncodeModeToStr(FMode);
end;

procedure TDataRdRecReserveEncodeItem.SetModeStr(const Value: string);
begin
  FMode := StrToEncodeMode(Value);
end;

function StrToEncodeMode(const str : string) : TDataRdRecReserveEncodeItemMode;
var
  i : Integer;
begin
  result := encR1;
  for i := 0 to High(TDataRdRecReserveEncodeItemModeStr) do begin
    if TDataRdRecReserveEncodeItemModeStr[i] = str then begin
      result := TDataRdRecReserveEncodeItemMode(i);
      break;
    end;
  end;
end;

function EncodeModeToStr(const Mode : TDataRdRecReserveEncodeItemMode) : string;
var
  i : Integer;
begin
  i := Ord(Mode);
  result := TDataRdRecReserveEncodeItemModeStr[i];
end;

end.
